/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cmd;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.enums.ManaSource;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.language.RPGFilter;
import mc.promcteam.engine.mccore.commands.CommandManager;
import mc.promcteam.engine.mccore.commands.ConfigurableCommand;
import mc.promcteam.engine.mccore.commands.IFunction;
import mc.promcteam.engine.mccore.config.CustomFilter;
import mc.promcteam.engine.mccore.config.Filter;
import mc.promcteam.engine.mccore.config.parse.NumberParser;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CmdMana
implements IFunction {
    private static final String NOT_PLAYER = "not-player";
    private static final String NOT_NUMBER = "not-number";
    private static final String NOT_POSITIVE = "not-positive";
    private static final String GAVE_MANA = "gave-mana";
    private static final String RECEIVED_MANA = "received-mana";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args) {
        if (sender instanceof Player && !SkillAPI.getSettings().isWorldEnabled(((Player)sender).getWorld()) && args.length == 1) {
            cmd.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
        } else if (args.length >= 1 && (args.length >= 2 || sender instanceof Player)) {
            double amount;
            OfflinePlayer target;
            OfflinePlayer offlinePlayer = target = args.length == 1 ? (OfflinePlayer)sender : Bukkit.getOfflinePlayer((String)args[0]);
            if (target == null) {
                cmd.sendMessage(sender, NOT_PLAYER, ChatColor.RED + "That is not a valid player name", new CustomFilter[0]);
                return;
            }
            try {
                amount = NumberParser.parseDouble((String)args[args.length == 1 ? 0 : 1]);
            }
            catch (Exception ex) {
                cmd.sendMessage(sender, NOT_NUMBER, ChatColor.RED + "That is not a valid mana amount", new CustomFilter[0]);
                return;
            }
            if (amount <= 0.0) {
                cmd.sendMessage(sender, NOT_POSITIVE, ChatColor.RED + "You must give a positive amount of mana", new CustomFilter[0]);
                return;
            }
            PlayerData data = SkillAPI.getPlayerData(target);
            data.giveMana(amount, ManaSource.COMMAND);
            if (target != sender) {
                cmd.sendMessage(sender, GAVE_MANA, ChatColor.DARK_GREEN + "You have given " + ChatColor.GOLD + "{player} {mana} mana", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.MANA.setReplacement("" + amount)});
            }
            if (target.isOnline()) {
                cmd.sendMessage((CommandSender)target.getPlayer(), RECEIVED_MANA, ChatColor.DARK_GREEN + "You have received " + ChatColor.GOLD + "{mana} mana " + ChatColor.DARK_GREEN + "from " + ChatColor.GOLD + "{player}", new CustomFilter[]{Filter.PLAYER.setReplacement(sender.getName()), RPGFilter.MANA.setReplacement("" + amount)});
            }
        } else {
            CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
        }
    }
}

