/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.sucy.skill.SkillAPI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import mc.promcteam.engine.mccore.util.VersionManager;
import mc.promcteam.engine.utils.Reflex;
import mc.promcteam.engine.utils.reflection.ReflectionManager;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Deprecated
public class ItemSerializer {
    private static final BiMap<String, Integer> ENCHANT_IDS = ImmutableBiMap.builder().put((Object)"PROTECTION_ENVIRONMENTAL", (Object)0).put((Object)"PROTECTION_FIRE", (Object)1).put((Object)"PROTECTION_FALL", (Object)2).put((Object)"PROTECTION_EXPLOSIONS", (Object)3).put((Object)"PROTECTION_PROJECTILE", (Object)4).put((Object)"OXYGEN", (Object)5).put((Object)"WATER_WORKER", (Object)6).put((Object)"THORNS", (Object)7).put((Object)"DEPTH_STRIDER", (Object)8).put((Object)"FROST_WALKER", (Object)9).put((Object)"BINDING_CURSE", (Object)10).put((Object)"DAMAGE_ALL", (Object)16).put((Object)"DAMAGE_UNDEAD", (Object)17).put((Object)"DAMAGE_ARTHROPODS", (Object)18).put((Object)"KNOCKBACK", (Object)19).put((Object)"FIRE_ASPECT", (Object)20).put((Object)"LOOT_BONUS_MOBS", (Object)21).put((Object)"SWEEPING_EDGE", (Object)22).put((Object)"DIG_SPEED", (Object)32).put((Object)"SILK_TOUCH", (Object)33).put((Object)"DURABILITY", (Object)34).put((Object)"LOOT_BONUS_BLOCKS", (Object)35).put((Object)"ARROW_DAMAGE", (Object)48).put((Object)"ARROW_KNOCKBACK", (Object)49).put((Object)"ARROW_FIRE", (Object)50).put((Object)"ARROW_INFINITE", (Object)51).put((Object)"LUCK", (Object)61).put((Object)"LURE", (Object)62).put((Object)"MENDING", (Object)70).put((Object)"VANISHING_CURSE", (Object)71).put((Object)"LOYALTY", (Object)80).put((Object)"IMPALING", (Object)81).put((Object)"RIPTIDE", (Object)82).put((Object)"CHANNELING", (Object)83).build();
    private static boolean initialized = false;
    private static Constructor<?> nbtTagListConstructor;
    private static Constructor<?> nbtTagCompoundConstructor;
    private static Constructor<?> craftItemConstructor;
    private static Constructor<?> craftItemNMSConstructor;
    private static Constructor<?> nmsItemConstructor;
    private static Method itemStack_save;
    private static Method nbtTagList_add;
    private static Method nbtTagList_size;
    private static Method nbtTagList_get;
    private static Method nbtCompressedStreamTools_write;
    private static Method nbtCompressedStreamTools_read;
    private static Method nbtTagCompound_set;
    private static Method nbtTagCompound_getList;
    private static Method nbtTagCompound_isEmpty;
    private static Field craftItemStack_getHandle;

    private static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            Class craftItemStack = Reflex.getCraftClass((String)"inventory.CraftItemStack");
            Class nmsItemStack = ReflectionManager.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.world.item.ItemStack") : Reflex.getNMSClass((String)"ItemStack");
            craftItemConstructor = Reflex.getConstructor((Class)craftItemStack, (Class[])new Class[]{ItemStack.class});
            craftItemConstructor.setAccessible(true);
            craftItemNMSConstructor = Reflex.getConstructor((Class)craftItemStack, (Class[])new Class[]{nmsItemStack});
            craftItemNMSConstructor.setAccessible(true);
            craftItemStack_getHandle = Reflex.getField((Class)craftItemStack, (String)"handle");
            craftItemStack_getHandle.setAccessible(true);
            Class nbtBase = ReflectionManager.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.nbt.NBTBase") : Reflex.getNMSClass((String)"NBTBase");
            Class nbtTagCompound = ReflectionManager.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.nbt.NBTTagCompound") : Reflex.getNMSClass((String)"NBTTagCompound");
            Class nbtTagList = ReflectionManager.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.nbt.NBTTagList") : Reflex.getNMSClass((String)"NBTTagList");
            Class nbtCompressedStreamTools = ReflectionManager.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.nbt.NBTCompressedStreamTools") : Reflex.getNMSClass((String)"NBTCompressedStreamTools");
            nmsItemConstructor = Reflex.getConstructor((Class)nmsItemStack, (Class[])new Class[]{nbtTagCompound});
            nmsItemConstructor.setAccessible(true);
            nbtTagCompoundConstructor = nbtTagCompound.getConstructor(new Class[0]);
            nbtTagListConstructor = nbtTagList.getConstructor(new Class[0]);
            if (ReflectionManager.MINOR_VERSION >= 18) {
                nbtTagCompound_set = Reflex.getMethod((Class)nbtTagCompound, (String)"a", (Class[])new Class[]{String.class, nbtBase});
                nbtTagCompound_getList = Reflex.getMethod((Class)nbtTagCompound, (String)"c", (Class[])new Class[]{String.class, Integer.TYPE});
                nbtTagCompound_isEmpty = Reflex.getMethod((Class)nbtTagCompound, (String)"f", (Class[])new Class[0]);
                itemStack_save = Reflex.getMethod((Class)nmsItemStack, (String)"b", (Class[])new Class[]{nbtTagCompound});
                nbtTagList_get = Reflex.getMethod((Class)nbtTagList, (String)"k", (Class[])new Class[]{Integer.TYPE});
            } else {
                nbtTagCompound_set = Reflex.getMethod((Class)nbtTagCompound, (String)"set", (Class[])new Class[]{String.class, nbtBase});
                nbtTagCompound_getList = Reflex.getMethod((Class)nbtTagCompound, (String)"getList", (Class[])new Class[]{String.class, Integer.TYPE});
                nbtTagCompound_isEmpty = Reflex.getMethod((Class)nbtTagCompound, (String)"isEmpty", (Class[])new Class[0]);
                itemStack_save = Reflex.getMethod((Class)nmsItemStack, (String)"save", (Class[])new Class[]{nbtTagCompound});
                nbtTagList_get = Reflex.getMethod((Class)nbtTagList, (String)"get", (Class[])new Class[]{Integer.TYPE});
            }
            nbtTagList_add = Reflex.getMethod((Class)nbtTagList, (String)"add", (Class[])new Class[]{nbtBase});
            nbtTagList_size = Reflex.getMethod((Class)nbtTagList, (String)"size", (Class[])new Class[0]);
            nbtCompressedStreamTools_write = Reflex.getMethod((Class)nbtCompressedStreamTools, (String)"a", (Class[])new Class[]{nbtTagCompound, DataOutput.class});
            nbtCompressedStreamTools_read = Reflex.getMethod((Class)nbtCompressedStreamTools, (String)"a", (Class[])new Class[]{DataInputStream.class});
        }
        catch (Exception ex) {
            SkillAPI.inst().getLogger().warning("Server doesn't support NBT serialization - resorting to a less complete implementation");
        }
    }

    public static String toBase64(ItemStack[] items) {
        if (items == null) {
            return null;
        }
        ItemSerializer.initialize();
        if (nbtCompressedStreamTools_read == null) {
            return ItemSerializer.basicSerialize(items);
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutput = new DataOutputStream(outputStream);
            Object itemList = Reflex.invokeConstructor(nbtTagListConstructor, (Object[])new Object[0]);
            for (ItemStack item : items) {
                Object outputObject = Reflex.invokeConstructor(nbtTagCompoundConstructor, (Object[])new Object[0]);
                Object craft = ItemSerializer.getCraftVersion(item);
                if (craft != null) {
                    Reflex.invokeMethod((Method)itemStack_save, (Object)craftItemStack_getHandle.get(craft), (Object[])new Object[]{outputObject});
                }
                Reflex.invokeMethod((Method)nbtTagList_add, (Object)itemList, (Object[])new Object[]{outputObject});
            }
            Object wrapper = Reflex.invokeConstructor(nbtTagCompoundConstructor, (Object[])new Object[0]);
            Reflex.invokeMethod((Method)nbtTagCompound_set, (Object)wrapper, (Object[])new Object[]{"i", itemList});
            Reflex.invokeMethod((Method)nbtCompressedStreamTools_write, null, (Object[])new Object[]{wrapper, dataOutput});
            return new BigInteger(1, outputStream.toByteArray()).toString(32);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ItemStack[] fromBase64(String data) {
        if (data == null) {
            return null;
        }
        ItemSerializer.initialize();
        if (data.indexOf(59) >= 0) {
            return ItemSerializer.basicDeserialize(data);
        }
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(new BigInteger(data, 32).toByteArray());
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            Object wrapper = Reflex.invokeMethod((Method)nbtCompressedStreamTools_read, null, (Object[])new Object[]{dataInputStream});
            Object itemList = Reflex.invokeMethod((Method)nbtTagCompound_getList, (Object)wrapper, (Object[])new Object[]{"i", 10});
            ItemStack[] items = new ItemStack[((Integer)Reflex.invokeMethod((Method)nbtTagList_size, (Object)itemList, (Object[])new Object[0])).intValue()];
            for (int i = 0; i < items.length; ++i) {
                Object inputObject = Reflex.invokeMethod((Method)nbtTagList_get, (Object)itemList, (Object[])new Object[]{i});
                if (((Boolean)Reflex.invokeMethod((Method)nbtTagCompound_isEmpty, (Object)inputObject, (Object[])new Object[0])).booleanValue()) continue;
                items[i] = (ItemStack)Reflex.invokeConstructor(craftItemNMSConstructor, (Object[])new Object[]{Reflex.invokeConstructor(nmsItemConstructor, (Object[])new Object[]{inputObject})});
            }
            return items;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static Object getCraftVersion(ItemStack stack) throws Exception {
        if (stack == null) {
            return null;
        }
        if (stack.getClass() == ItemStack.class) {
            return Reflex.invokeConstructor(craftItemConstructor, (Object[])new Object[]{stack});
        }
        return stack;
    }

    private static String basicSerialize(ItemStack[] items) {
        StringBuilder builder = new StringBuilder();
        builder.append(items.length);
        builder.append(';');
        for (int i = 0; i < items.length; ++i) {
            ItemMeta meta;
            Map isEnch;
            String isType;
            ItemStack is = items[i];
            if (is == null) continue;
            builder.append(i);
            builder.append('#');
            if (VersionManager.isVersionAtLeast((int)11605)) {
                isType = String.valueOf(is.getType());
                builder.append("t@");
                builder.append(isType);
            } else {
                isType = String.valueOf(is.getType().getId());
                builder.append("t@");
                builder.append(isType);
            }
            if (is.getDurability() != 0) {
                String isDurability = String.valueOf(is.getDurability());
                builder.append(":d@");
                builder.append(isDurability);
            }
            if (is.getAmount() != 1) {
                String isAmount = String.valueOf(is.getAmount());
                builder.append(":a@");
                builder.append(isAmount);
            }
            if ((isEnch = is.getEnchantments()).size() > 0) {
                for (Map.Entry ench : isEnch.entrySet()) {
                    builder.append(":e@");
                    builder.append(ENCHANT_IDS.get((Object)((Enchantment)ench.getKey()).getName()));
                    builder.append('@');
                    builder.append(ench.getValue());
                }
            }
            if ((meta = is.getItemMeta()) != null) {
                if (meta.hasDisplayName()) {
                    builder.append(":n@");
                    builder.append(meta.getDisplayName().replaceAll("[:@#;]", ""));
                }
                if (meta.hasLore()) {
                    for (String line : meta.getLore()) {
                        builder.append(":l@");
                        builder.append(line.replaceAll("[:;@#]", ""));
                    }
                }
            }
            builder.append(';');
        }
        return builder.toString();
    }

    private static ItemStack[] basicDeserialize(String invString) {
        String[] serializedBlocks = invString.split(";");
        if (serializedBlocks.length == 0) {
            return null;
        }
        String invInfo = serializedBlocks[0];
        ItemStack[] deserializedInventory = new ItemStack[Integer.valueOf(invInfo).intValue()];
        for (int i = 1; i <= deserializedInventory.length && i < serializedBlocks.length; ++i) {
            String[] serializedItemStack;
            String[] serializedBlock = serializedBlocks[i].split("#");
            int stackPosition = Integer.valueOf(serializedBlock[0]);
            if (stackPosition >= deserializedInventory.length) continue;
            ItemStack is = null;
            Boolean createdItemStack = false;
            for (String itemInfo : serializedItemStack = serializedBlock[1].split(":")) {
                ItemMeta meta;
                String[] itemAttribute = itemInfo.split("@");
                if (itemAttribute[0].equals("t")) {
                    Material mat;
                    if (VersionManager.isVersionAtLeast((int)11605)) {
                        String id = String.valueOf(itemAttribute[1]);
                        mat = Material.getMaterial((String)id);
                        is = new ItemStack(mat);
                        createdItemStack = true;
                        continue;
                    }
                    int id = Integer.valueOf(itemAttribute[1]);
                    if (id >= 2256) {
                        id -= 2267 - Material.values().length;
                    }
                    mat = Material.values()[id];
                    is = new ItemStack(mat);
                    createdItemStack = true;
                    continue;
                }
                if (itemAttribute[0].equals("d") && createdItemStack.booleanValue()) {
                    is.setDurability(Short.valueOf(itemAttribute[1]).shortValue());
                    continue;
                }
                if (itemAttribute[0].equals("a") && createdItemStack.booleanValue()) {
                    is.setAmount(Integer.valueOf(itemAttribute[1]).intValue());
                    continue;
                }
                if (itemAttribute[0].equals("e") && createdItemStack.booleanValue()) {
                    String name = (String)ENCHANT_IDS.inverse().getOrDefault((Object)Integer.valueOf(itemAttribute[1]), (Object)"OXYGEN");
                    is.addUnsafeEnchantment(Enchantment.getByName((String)name), Integer.valueOf(itemAttribute[2]).intValue());
                    continue;
                }
                if (itemAttribute[0].equals("n") && createdItemStack.booleanValue()) {
                    meta = is.getItemMeta();
                    if (meta == null) continue;
                    meta.setDisplayName(itemAttribute[1]);
                    is.setItemMeta(meta);
                    continue;
                }
                if (!itemAttribute[0].equals("l") || !createdItemStack.booleanValue() || (meta = is.getItemMeta()) == null) continue;
                ArrayList<String> lore = meta.getLore();
                if (lore == null) {
                    lore = new ArrayList<String>();
                }
                if (itemAttribute.length >= 1) {
                    lore.add(itemAttribute[1]);
                }
                meta.setLore(lore);
                is.setItemMeta(meta);
            }
            deserializedInventory[stackPosition] = is;
        }
        return deserializedInventory;
    }
}

