/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.skills;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.ReadOnlySettings;
import com.sucy.skill.api.Settings;
import com.sucy.skill.api.event.SkillDamageEvent;
import com.sucy.skill.api.event.TrueDamageEvent;
import com.sucy.skill.api.player.PlayerCombos;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkill;
import com.sucy.skill.api.skills.SkillShot;
import com.sucy.skill.api.skills.TargetSkill;
import com.sucy.skill.api.util.DamageLoreRemover;
import com.sucy.skill.api.util.Data;
import com.sucy.skill.dynamic.TempEntity;
import com.sucy.skill.gui.tool.IconHolder;
import com.sucy.skill.hook.NoCheatHook;
import com.sucy.skill.hook.PluginChecker;
import com.sucy.skill.language.RPGFilter;
import com.sucy.skill.log.Logger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mc.promcteam.engine.mccore.config.CustomFilter;
import mc.promcteam.engine.mccore.config.Filter;
import mc.promcteam.engine.mccore.config.FilterType;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import mc.promcteam.engine.mccore.config.parse.NumberParser;
import mc.promcteam.engine.mccore.util.TextFormatter;
import mc.promcteam.engine.mccore.util.VersionManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public abstract class Skill
implements IconHolder {
    private static final DecimalFormat FORMAT = new DecimalFormat("#########0.0#");
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String LAYOUT = "icon-lore";
    private static final String MAX = "max-level";
    private static final String REQ = "skill-req";
    private static final String REQLVL = "skill-req-lvl";
    private static final String MSG = "msg";
    private static final String PERM = "needs-permission";
    private static final String COOLDOWN_MESSAGE = "cooldown-message";
    private static final String DESC = "desc";
    private static final String ATTR = "attributes";
    private static final String COMBO = "combo";
    private static boolean skillDamage = false;
    protected final Settings settings = new Settings();
    private final ArrayList<String> description = new ArrayList();
    private final ReadOnlySettings readOnlySettings = new ReadOnlySettings(this.settings);
    private final String key;
    private List<String> iconLore;
    private ItemStack indicator;
    private String name;
    private String type;
    private String message;
    private String skillReq;
    private int maxLevel;
    private int skillReqLevel;
    private boolean needsPermission;
    private boolean cooldownMessage;
    private int combo;

    public Skill(String name, String type, Material indicator, int maxLevel) {
        this(name, type, new ItemStack(indicator), maxLevel, null, 0);
    }

    public Skill(String name, String type, Material indicator, int maxLevel, String skillReq, int skillReqLevel) {
        this(name, type, new ItemStack(indicator), maxLevel, skillReq, skillReqLevel);
    }

    public Skill(String name, String type, ItemStack indicator, int maxLevel) {
        this(name, type, indicator, maxLevel, null, 0);
    }

    public Skill(String name, String type, ItemStack indicator, int maxLevel, String skillReq, int skillReqLevel) {
        if (name == null) {
            throw new IllegalArgumentException("Skill name cannot be null");
        }
        if (type == null) {
            type = "Unknown type";
        }
        if (indicator == null) {
            indicator = new ItemStack(Material.APPLE);
        }
        if (maxLevel < 1) {
            maxLevel = 1;
        }
        this.key = name.toLowerCase();
        this.type = type;
        this.name = name;
        this.indicator = indicator;
        this.maxLevel = maxLevel;
        this.skillReq = skillReq;
        this.skillReqLevel = skillReqLevel;
        this.needsPermission = false;
        this.message = (String)SkillAPI.getLanguage().getMessage("Notifications.cast", true, FilterType.COLOR, new CustomFilter[0]).get(0);
        this.iconLore = SkillAPI.getLanguage().getMessage("Skill Tree.layout", true, FilterType.COLOR, new CustomFilter[0]);
    }

    public static boolean isSkillDamage() {
        return skillDamage;
    }

    public boolean hasCombo() {
        return this.combo >= 0;
    }

    public boolean canAutoLevel(int level) {
        return this.getCost(level) == 0;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public boolean hasMessage() {
        return this.message != null && this.message.length() > 0;
    }

    public int getCombo() {
        return this.combo;
    }

    public void setCombo(int combo) {
        this.combo = combo;
    }

    public void clearCombo() {
        this.combo = -1;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean needsPermission() {
        return this.needsPermission;
    }

    public ItemStack getIndicator() {
        return this.indicator;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasSkillReq() {
        return SkillAPI.getSkill(this.skillReq) != null && this.skillReqLevel > 0;
    }

    public String getSkillReq() {
        return this.skillReq;
    }

    public int getSkillReqLevel() {
        return this.skillReqLevel;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public int getLevelReq(int level) {
        return (int)this.settings.getAttr("level", level + 1);
    }

    public double getManaCost(int level) {
        return this.settings.getAttr("mana", level);
    }

    public double getCooldown(int level) {
        return this.settings.getAttr("cooldown", level);
    }

    public boolean cooldownMessage() {
        return this.cooldownMessage;
    }

    public double getRange(int level) {
        return this.settings.getAttr("range", level);
    }

    public int getCost(int level) {
        return (int)this.settings.getAttr("cost", level + 1);
    }

    public ReadOnlySettings getSettings() {
        return this.readOnlySettings;
    }

    public boolean canCast() {
        return this instanceof SkillShot || this instanceof TargetSkill;
    }

    public ItemStack getToolIndicator() {
        ItemStack item = new ItemStack(this.indicator.getType());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List lore;
            List list = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
            if (meta.hasDisplayName()) {
                lore.add(0, meta.getDisplayName());
            }
            lore.add("Level: " + this.getLevelReq(0));
            lore.add("Cost: " + this.getCost(0));
            meta.setLore(lore);
            meta.setDisplayName(this.name);
            item.setItemMeta(meta);
        }
        return item;
    }

    @Override
    public ItemStack getIcon(PlayerData data) {
        PlayerSkill skill = data.getSkill(this.name);
        if (skill != null) {
            return this.getIndicator(skill, false);
        }
        return this.getIndicator();
    }

    @Override
    public boolean isAllowed(Player player) {
        return !this.needsPermission() || player.hasPermission("skillapi.skill") || player.hasPermission("skillapi.skill." + this.name.toLowerCase().replace(" ", "-"));
    }

    public boolean hasDependency(PlayerData playerData) {
        if (this.getSkillReq() != null) {
            PlayerSkill req = playerData.getSkill(this.getSkillReq());
            return req == null || req.getLevel() >= this.getSkillReqLevel();
        }
        return true;
    }

    public boolean isCompatible(PlayerData playerData) {
        for (String skillName : this.settings.getStringList("incompatible")) {
            PlayerSkill skill = playerData.getSkill(skillName);
            if (skill == null || skill.getLevel() <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean hasInvestedEnough(PlayerData playerData) {
        PlayerSkill skill = playerData.getSkill(this.name);
        if (skill == null) {
            return false;
        }
        double reqPoints = this.settings.getAttr("points-spent-req", skill.getLevel(), 0.0);
        return (double)playerData.getInvestedSkillPoints() >= reqPoints;
    }

    public ItemStack getIndicator(PlayerSkill skillData, boolean brief) {
        PlayerCombos combos;
        Player player = skillData.getPlayerData().getPlayer();
        ItemStack item = new ItemStack(this.indicator.getType());
        item.setAmount(Math.max(1, skillData.getLevel()));
        ItemMeta meta = item.hasItemMeta() ? item.getItemMeta() : Bukkit.getItemFactory().getItemMeta(item.getType());
        ItemMeta iconMeta = this.indicator.getItemMeta();
        if (meta instanceof Damageable) {
            ((Damageable)meta).setDamage(((Damageable)iconMeta).getDamage());
        }
        if (iconMeta.hasCustomModelData()) {
            meta.setCustomModelData(Integer.valueOf(iconMeta.getCustomModelData()));
        }
        ArrayList<String> lore = new ArrayList<String>();
        String MET = (String)SkillAPI.getLanguage().getMessage("Skill Tree.requirement.met", true, FilterType.COLOR, new CustomFilter[0]).get(0);
        String NOT_MET = (String)SkillAPI.getLanguage().getMessage("Skill Tree.requirement.not-met", true, FilterType.COLOR, new CustomFilter[0]).get(0);
        MET = MET.substring(0, MET.length() - 2);
        NOT_MET = NOT_MET.substring(0, NOT_MET.length() - 2);
        String lvlReq = skillData.getLevelReq() <= skillData.getPlayerClass().getLevel() ? MET : NOT_MET;
        String costReq = skillData.getCost() <= skillData.getPlayerClass().getPoints() ? MET : NOT_MET;
        String spentReq = this.hasInvestedEnough(skillData.getPlayerData()) ? MET : NOT_MET;
        String branchReq = this.isCompatible(skillData.getPlayerData()) ? MET : NOT_MET;
        String skillReq = this.isCompatible(skillData.getPlayerData()) ? MET : NOT_MET;
        String attrChanging = (String)SkillAPI.getLanguage().getMessage("Skill Tree.attribute.changing", true, FilterType.COLOR, new CustomFilter[0]).get(0);
        String attrStatic = (String)SkillAPI.getLanguage().getMessage("Skill Tree.attribute.not-changing", true, FilterType.COLOR, new CustomFilter[0]).get(0);
        for (String line : this.iconLore) {
            try {
                int end;
                int start;
                line = line.replace("{level}", "" + skillData.getLevel()).replace("{req:lvl}", lvlReq).replace("{req:level}", lvlReq).replace("{req:cost}", costReq).replace("{req:spent}", spentReq).replace("{req:branch}", branchReq).replace("{req:skill}", skillReq).replace("{max}", "" + this.maxLevel).replace("{name}", this.name).replace("{type}", this.type).replace("{skill_points}", String.valueOf(skillData.getPlayerClass().getPoints()));
                while (line.contains("{attr:")) {
                    start = line.indexOf("{attr:");
                    end = line.indexOf("}", start);
                    String attr = line.substring(start + 6, end);
                    Object currValue = this.getAttr((LivingEntity)player, attr, Math.max(1, skillData.getLevel()));
                    Object nextValue = this.getAttr((LivingEntity)player, attr, Math.min(skillData.getLevel() + 1, this.maxLevel));
                    if (attr.equals("level") || attr.equals("cost")) {
                        currValue = nextValue = Integer.valueOf((int)Math.floor(NumberParser.parseDouble((String)nextValue.toString().replace(',', '.'))));
                    }
                    if (currValue.equals(nextValue) || brief) {
                        line = line.replace("{attr:" + attr + "}", attrStatic.replace("{name}", this.getAttrName(attr)).replace("{value}", currValue.toString()));
                        continue;
                    }
                    line = line.replace("{attr:" + attr + "}", attrChanging.replace("{name}", this.getAttrName(attr)).replace("{value}", currValue.toString()).replace("{new}", nextValue.toString()));
                }
                if (line.contains("{desc}")) {
                    for (String descLine : this.description) {
                        lore.add(line.replace("{desc}", descLine));
                    }
                    continue;
                }
                if (line.contains("{desc:")) {
                    String[] stringArray;
                    start = line.indexOf("{desc:");
                    String lineInfo = line.substring(start + 6, end = line.indexOf("}", start));
                    if (lineInfo.contains("-")) {
                        stringArray = lineInfo.split("-");
                    } else {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = lineInfo;
                        stringArray = stringArray2;
                        stringArray2[1] = lineInfo;
                    }
                    String[] split = stringArray;
                    start = Integer.parseInt(split[0]) - 1;
                    end = split[1].equals("x") ? this.description.size() : Integer.parseInt(split[1]);
                    for (int i = start; i < end && i < this.description.size(); ++i) {
                        lore.add(line.replace("{desc:" + lineInfo + "}", this.description.get(i)));
                    }
                    continue;
                }
                lore.add(line);
            }
            catch (Exception ex) {
                Logger.invalid("Skill icon filter for the skill \"" + this.name + "\" is invalid (Line = \"" + line + "\") - " + ex.getMessage());
            }
        }
        if (SkillAPI.getSettings().isCombosEnabled() && this.canCast() && (combos = skillData.getPlayerData().getComboData()).hasCombo(this)) {
            lore.addAll(Arrays.asList("", combos.getComboString(this)));
        }
        if (SkillAPI.getSettings().isShowBinds() && skillData.getBind() != null) {
            lore.add("");
            String type = TextFormatter.format((String)skillData.getBind().name().replace("LEGACY_", ""));
            lore.add(SkillAPI.getSettings().getBindText().replace("{material}", type));
        }
        if (lore.size() > 0) {
            meta.setDisplayName((String)lore.remove(0));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return DamageLoreRemover.removeAttackDmg(item);
    }

    protected String getAttrName(String key) {
        return TextFormatter.format((String)key);
    }

    protected Object getAttr(LivingEntity caster, String key, int level) {
        Object result = this.settings.getObj(key, level);
        if (result instanceof Double) {
            return this.format((Double)result);
        }
        return result;
    }

    protected String format(double value) {
        String result = FORMAT.format(value);
        if (result.endsWith(".0")) {
            return result.substring(0, result.length() - 2);
        }
        return result;
    }

    public void sendMessage(Player player, double radius) {
        if (this.hasMessage()) {
            radius *= radius;
            Location l = player.getLocation();
            for (Player p : player.getWorld().getPlayers()) {
                if (!(p.getLocation().distanceSquared(l) < radius)) continue;
                p.sendMessage(RPGFilter.SKILL.setReplacement(this.getName()).apply(Filter.PLAYER.setReplacement(player.getName()).apply(this.message)));
            }
        }
    }

    public void damage(LivingEntity target, double damage, LivingEntity source) {
        this.damage(target, damage, source, "default");
    }

    public void damage(LivingEntity target, double damage, LivingEntity source, String classification) {
        this.damage(target, damage, source, classification, true);
    }

    public void damage(LivingEntity target, double damage, LivingEntity source, String classification, boolean knockback) {
        this.damage(target, damage, source, classification, knockback, EntityDamageEvent.DamageCause.ENTITY_ATTACK);
    }

    public void damage(LivingEntity target, double damage, LivingEntity source, String classification, boolean knockback, EntityDamageEvent.DamageCause cause) {
        if (target instanceof TempEntity) {
            return;
        }
        if (target.equals(source)) {
            knockback = false;
        }
        if (!SkillAPI.getSettings().canAttack(source, target, cause)) {
            return;
        }
        SkillDamageEvent event = new SkillDamageEvent(this, source, target, damage, classification, knockback);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            target.setMetadata("damageCause", (MetadataValue)new FixedMetadataValue((Plugin)SkillAPI.inst(), (Object)cause));
            if (source instanceof Player) {
                Player player = (Player)source;
                if (PluginChecker.isNoCheatActive()) {
                    NoCheatHook.exempt(player);
                }
                skillDamage = true;
                target.setNoDamageTicks(0);
                if (knockback) {
                    target.damage(event.getDamage(), (Entity)source);
                } else {
                    target.damage(event.getDamage());
                }
                skillDamage = false;
                if (PluginChecker.isNoCheatActive()) {
                    NoCheatHook.unexempt(player);
                }
            } else {
                skillDamage = true;
                int ticks = target.getNoDamageTicks();
                target.setNoDamageTicks(0);
                if (VersionManager.isVersionAtMost((int)VersionManager.V1_5_2)) {
                    if (knockback) {
                        target.damage((double)((int)damage), (Entity)source);
                    } else {
                        target.damage((double)((int)damage));
                    }
                } else if (knockback) {
                    target.damage(damage, (Entity)source);
                } else {
                    target.damage(damage);
                }
                target.setNoDamageTicks(ticks);
                skillDamage = false;
            }
        }
    }

    public void trueDamage(LivingEntity target, double damage, LivingEntity source) {
        if (target instanceof TempEntity) {
            return;
        }
        TrueDamageEvent event = new TrueDamageEvent(this, source, target, damage);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled() && event.getDamage() != 0.0) {
            target.setHealth(Math.max(Math.min(target.getHealth() - event.getDamage(), target.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()), 0.0));
        }
    }

    public void playPreview(PlayerData playerData, int level) {
    }

    public void save(DataSection config) {
        config.set(NAME, (Object)this.name);
        config.set(TYPE, (Object)this.type.replace('\u00a7', '&'));
        config.set(MAX, (Object)this.maxLevel);
        config.set(REQ, (Object)this.skillReq);
        config.set(REQLVL, (Object)this.skillReqLevel);
        config.set(PERM, (Object)this.needsPermission);
        config.set(COOLDOWN_MESSAGE, (Object)this.cooldownMessage);
        if (this.combo >= 0 && this.canCast()) {
            config.set(COMBO, (Object)SkillAPI.getComboManager().getSaveString(this.combo));
        }
        this.settings.save(config.createSection(ATTR));
        if (this.hasMessage()) {
            config.set(MSG, (Object)this.message.replace('\u00a7', '&'));
        }
        Data.serializeIcon(this.indicator, config);
        config.set(DESC, this.description);
    }

    public void softSave(DataSection config) {
        boolean neededOnly;
        boolean bl = neededOnly = config.keys().size() > 0;
        if (!neededOnly) {
            this.save(config);
        }
    }

    public void load(DataSection config) {
        this.name = config.getString(NAME, this.name);
        this.type = TextFormatter.colorString((String)config.getString(TYPE, this.name));
        this.indicator = Data.parseIcon(config);
        this.maxLevel = config.getInt(MAX, this.maxLevel);
        this.skillReq = config.getString(REQ);
        if (this.skillReq == null || this.skillReq.length() == 0) {
            this.skillReq = null;
        }
        this.skillReqLevel = config.getInt(REQLVL, this.skillReqLevel);
        this.message = TextFormatter.colorString((String)config.getString(MSG, this.message));
        this.needsPermission = config.getString(PERM, "" + this.needsPermission).equalsIgnoreCase("true");
        this.cooldownMessage = config.getBoolean(COOLDOWN_MESSAGE, true);
        this.combo = SkillAPI.getComboManager().parseCombo(config.getString(COMBO));
        if (config.isList(DESC)) {
            this.description.clear();
            this.description.addAll(config.getList(DESC));
        }
        if (config.isList(LAYOUT)) {
            this.iconLore = TextFormatter.colorStringList((List)config.getList(LAYOUT));
        }
        this.settings.load(config.getSection(ATTR));
    }
}

