/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.projectile;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.Settings;
import com.sucy.skill.api.event.ItemProjectileExpireEvent;
import com.sucy.skill.api.event.ItemProjectileHitEvent;
import com.sucy.skill.api.event.ItemProjectileLandEvent;
import com.sucy.skill.api.event.ItemProjectileLaunchEvent;
import com.sucy.skill.api.projectile.CustomProjectile;
import com.sucy.skill.api.projectile.ProjectileCallback;
import com.sucy.skill.api.util.DamageLoreRemover;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.Metadatable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class ItemProjectile
extends CustomProjectile {
    private static final String NAME = "SkillAPI#";
    private static int NEXT = 0;
    private final Item item;
    private int life;
    private final boolean walls;
    private final double halfHeight;
    private final double halfWidth;
    private static final Vector X_AXIS = new Vector(1, 0, 0);
    private static final Vector Y_AXIS = new Vector(0, 1, 0);
    private static final Vector Z_AXIS = new Vector(0, 0, 1);

    public ItemProjectile(LivingEntity thrower, Location loc, Settings settings, ItemStack item, Vector vel, int lifespan, boolean collideWalls) {
        super(thrower, settings);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(NAME + NEXT++);
            item.setItemMeta(meta);
        }
        DamageLoreRemover.removeAttackDmg(item);
        this.item = thrower.getWorld().dropItem(loc.add(0.0, 1.0, 0.0), item);
        this.item.setVelocity(vel);
        this.item.setPickupDelay(Integer.MAX_VALUE);
        this.walls = collideWalls;
        this.halfHeight = this.item.getHeight() / 2.0;
        this.halfWidth = this.item.getWidth() / 2.0;
        this.life = lifespan;
        SkillAPI.setMeta((Metadatable)this.item, "itemProjectile", this);
        Bukkit.getPluginManager().callEvent((Event)new ItemProjectileLaunchEvent(this));
    }

    @Override
    public Location getLocation() {
        return this.item.getLocation();
    }

    @Override
    protected Event expire() {
        return this.land();
    }

    @Override
    protected Event land() {
        return new ItemProjectileLandEvent(this);
    }

    @Override
    protected Event hit(LivingEntity entity) {
        return new ItemProjectileHitEvent(this, entity);
    }

    @Override
    protected boolean landed() {
        if (this.item.isOnGround()) {
            return true;
        }
        if (this.walls) {
            Vector velocity = this.item.getVelocity();
            RayTraceResult raytrace = this.item.getWorld().rayTraceBlocks(this.item.getLocation(), velocity, velocity.length(), FluidCollisionMode.NEVER, true);
            if (raytrace == null) {
                raytrace = this.collideWall(velocity, X_AXIS);
            }
            if (raytrace == null) {
                raytrace = this.collideWall(velocity, Z_AXIS);
            }
            if (raytrace == null) {
                raytrace = this.collideWall(velocity, Y_AXIS);
            }
            if (raytrace != null) {
                this.item.teleport(raytrace.getHitPosition().toLocation(this.item.getWorld()));
                return true;
            }
        }
        return false;
    }

    @Nullable
    private RayTraceResult collideWall(Vector direction, Vector defaultDirection) {
        direction = direction.clone();
        direction.multiply(defaultDirection);
        if (direction.lengthSquared() == 0.0) {
            RayTraceResult result = this.collideWall(defaultDirection, defaultDirection);
            if (result == null) {
                result = this.collideWall(defaultDirection.clone().multiply(-1), defaultDirection);
            }
            return result;
        }
        return this.item.getWorld().rayTraceBlocks(this.item.getLocation().add(0.0, this.halfHeight, 0.0), direction, this.halfWidth + 0.1, FluidCollisionMode.NEVER, true);
    }

    @Override
    protected double getCollisionRadius() {
        return this.item.getVelocity().length() / 2.0;
    }

    @Override
    protected Vector getVelocity() {
        return this.item.getVelocity();
    }

    @Override
    protected void setVelocity(Vector velocity) {
        this.item.setVelocity(velocity);
    }

    public void run() {
        if (this.isTraveling()) {
            this.checkCollision(false);
        }
        --this.life;
        if (this.life <= 0) {
            if (this.settings.getBool("on-expire")) {
                this.callback.callback(this, null);
            }
            this.cancel();
            Bukkit.getPluginManager().callEvent((Event)new ItemProjectileExpireEvent(this));
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.item.remove();
    }

    public static ArrayList<ItemProjectile> spread(LivingEntity shooter, Vector center, Location loc, Settings settings, ItemStack item, double angle, int amount, ProjectileCallback callback, int lifespan, boolean collideWalls) {
        double speed = center.length();
        center.normalize();
        ArrayList<Vector> dirs = ItemProjectile.calcSpread(shooter.getLocation().getDirection(), angle, amount);
        ArrayList<ItemProjectile> list = new ArrayList<ItemProjectile>();
        for (Vector dir : dirs) {
            Vector vel = dir.multiply(speed);
            ItemProjectile p = new ItemProjectile(shooter, loc.clone(), settings, item, vel, lifespan, collideWalls);
            p.setCallback(callback);
            list.add(p);
        }
        return list;
    }

    public static ArrayList<ItemProjectile> rain(LivingEntity shooter, Location center, Settings settings, ItemStack item, double radius, double height, double speed, int amount, ProjectileCallback callback, int lifespan, boolean collideWalls) {
        Vector vel = new Vector(0.0, speed, 0.0);
        if (vel.getY() == 0.0) {
            vel.setY(1);
        }
        ArrayList<Location> locs = ItemProjectile.calcRain(center, radius, height, amount);
        ArrayList<ItemProjectile> list = new ArrayList<ItemProjectile>();
        for (Location l : locs) {
            l.setDirection(vel);
            ItemProjectile p = new ItemProjectile(shooter, l, settings, item, vel, lifespan, collideWalls);
            p.setCallback(callback);
            list.add(p);
        }
        return list;
    }
}

