/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.particle;

import com.sucy.skill.api.Settings;
import com.sucy.skill.api.enums.Direction;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.Nullable;

public final class ParticleHelper {
    public static final String ARRANGEMENT_KEY = "arrangement";
    public static final String POINTS_KEY = "particles";
    public static final String LEVEL = "level";
    public static final String PARTICLE_KEY = "particle";
    public static final String MATERIAL_KEY = "material";
    public static final String CMD_KEY = "type";
    public static final String DURABILITY_KEY = "durability";
    public static final String RADIUS_KEY = "radius";
    public static final String AMOUNT_KEY = "amount";
    public static final String DIRECTION_KEY = "direction";
    public static final String VISIBLE_RADIUS_KEY = "visible-radius";
    public static final String DX_KEY = "dx";
    public static final String DY_KEY = "dy";
    public static final String DZ_KEY = "dz";
    public static final String SPEED_KEY = "speed";
    public static final String DATA_KEY = "data";
    public static final String DUST_COLOR = "dust-color";
    public static final String FINAL_DUST_COLOR = "final-dust-color";
    public static final String DUST_SIZE = "dust-size";
    private static final Random random = new Random();

    private ParticleHelper() {
    }

    public static Particle getFromKey(String particleKey) {
        return Particle.valueOf((String)particleKey.toUpperCase().replace(' ', '_'));
    }

    public static void play(Location loc, Settings settings, @Nullable Set<Player> viewers, String particleKey, @Nullable BoundingBox targetHitbox) {
        double visibleRadius = settings.getDouble(particleKey + VISIBLE_RADIUS_KEY, 25.0);
        Particle particle = ParticleHelper.getFromKey(settings.getString(particleKey + PARTICLE_KEY, "Villager happy"));
        int amount = settings.getInt(particleKey + AMOUNT_KEY, 1);
        double dx = settings.getDouble(particleKey + DX_KEY, 0.0);
        double dy = settings.getDouble(particleKey + DY_KEY, 0.0);
        double dz = settings.getDouble(particleKey + DZ_KEY, 0.0);
        float speed = (float)settings.getDouble(particleKey + SPEED_KEY, 0.1);
        Object object = ParticleHelper.makeObject(particle, settings, particleKey);
        String arrangement = settings.getString(particleKey + ARRANGEMENT_KEY, "").toLowerCase();
        int level = settings.getInt(particleKey + LEVEL, 1);
        int points = (int)settings.getAttr(particleKey + POINTS_KEY, 0, 20.0);
        if (targetHitbox != null) {
            switch (arrangement) {
                case "sphere": 
                case "hemisphere": {
                    loc.add(0.0, targetHitbox.getHeight() / 2.0, 0.0);
                    break;
                }
            }
        }
        switch (arrangement) {
            case "circle": {
                ParticleHelper.fillCircle(loc, settings, level, points, visibleRadius, particle, amount, dx, dy, dz, speed, object, particleKey, viewers);
                break;
            }
            case "sphere": {
                ParticleHelper.fillSphere(loc, settings, level, points, visibleRadius, particle, amount, dx, dy, dz, speed, object, particleKey, viewers);
                break;
            }
            case "hemisphere": {
                ParticleHelper.fillHemisphere(loc, settings, level, points, visibleRadius, particle, amount, dx, dy, dz, speed, object, particleKey, viewers);
                break;
            }
            default: {
                if (viewers == null) {
                    viewers = ParticleHelper.filterPlayers(Objects.requireNonNull(loc.getWorld()).getPlayers(), loc, visibleRadius);
                }
                viewers.forEach(player -> player.spawnParticle(particle, loc, amount, dx, dy, dz, (double)speed, object));
            }
        }
    }

    public static void play(Location loc, Settings settings) {
        ParticleHelper.play(loc, settings, null, "", null);
    }

    public static void fillCircle(Location loc, Settings settings, int level, int points, double visibleRadius, Particle particle, int amount, double dx, double dy, double dz, float speed, Object object, String particleKey, @Nullable Set<Player> viewers) {
        double radius = settings.getAttr(particleKey + RADIUS_KEY, level, 3.0);
        World world = Objects.requireNonNull(loc.getWorld());
        List worldPlayers = world.getPlayers();
        double rSquared = radius * radius;
        double twoRadius = radius * 2.0;
        Location temp = loc.clone();
        int index = 0;
        Direction direction = null;
        if (settings.has(particleKey + DIRECTION_KEY)) {
            try {
                direction = Direction.valueOf(settings.getString(particleKey + DIRECTION_KEY));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (direction == null) {
            direction = Direction.XZ;
        }
        while (index < points) {
            if (direction == Direction.XY || direction == Direction.XZ) {
                temp.setX(loc.getX() + random.nextDouble() * twoRadius - radius);
            }
            if (direction == Direction.XY || direction == Direction.YZ) {
                temp.setY(loc.getY() + random.nextDouble() * twoRadius - radius);
            }
            if (direction == Direction.XZ || direction == Direction.YZ) {
                temp.setZ(loc.getZ() + random.nextDouble() * twoRadius - radius);
            }
            if (temp.distanceSquared(loc) > rSquared) continue;
            if (viewers == null) {
                viewers = ParticleHelper.filterPlayers(worldPlayers, temp, visibleRadius);
            }
            viewers.forEach(player -> player.spawnParticle(particle, temp, amount, dx, dy, dz, (double)speed, object));
            ++index;
        }
    }

    public static void fillCircle(Location loc, Settings settings, int level, int points, double visibleRadius, Particle particle, int amount, double dx, double dy, double dz, float speed, Object object) {
        ParticleHelper.fillCircle(loc, settings, level, points, visibleRadius, particle, amount, dx, dy, dz, speed, object, "", null);
    }

    public static void fillSphere(Location loc, Settings settings, int level, int points, double visibleRadius, Particle particle, int amount, double dx, double dy, double dz, float speed, Object object, String particleKey, @Nullable Set<Player> viewers) {
        double radius = settings.getAttr(particleKey + RADIUS_KEY, level, 3.0);
        World world = Objects.requireNonNull(loc.getWorld());
        List worldPlayers = world.getPlayers();
        double rSquared = radius * radius;
        double twoRadius = radius * 2.0;
        Location temp = loc.clone();
        int index = 0;
        while (index < points) {
            temp.setX(loc.getX() + random.nextDouble() * twoRadius - radius);
            temp.setY(loc.getY() + random.nextDouble() * twoRadius - radius);
            temp.setZ(loc.getZ() + random.nextDouble() * twoRadius - radius);
            if (temp.distanceSquared(loc) > rSquared) continue;
            if (viewers == null) {
                viewers = ParticleHelper.filterPlayers(worldPlayers, temp, visibleRadius);
            }
            viewers.forEach(player -> player.spawnParticle(particle, temp, amount, dx, dy, dz, (double)speed, object));
            ++index;
        }
    }

    public static void fillSphere(Location loc, Settings settings, int level, int points, double visibleRadius, Particle particle, int amount, double dx, double dy, double dz, float speed, Object object) {
        ParticleHelper.fillSphere(loc, settings, level, points, visibleRadius, particle, amount, dx, dy, dz, speed, object, "", null);
    }

    public static void fillHemisphere(Location loc, Settings settings, int level, int points, double visibleRadius, Particle particle, int amount, double dx, double dy, double dz, float speed, Object object, String particleKey, @Nullable Set<Player> viewers) {
        double radius = settings.getAttr(particleKey + RADIUS_KEY, level, 3.0);
        World world = Objects.requireNonNull(loc.getWorld());
        List worldPlayers = world.getPlayers();
        double rSquared = radius * radius;
        double twoRadius = radius * 2.0;
        Location temp = loc.clone();
        int index = 0;
        while (index < points) {
            temp.setX(loc.getX() + random.nextDouble() * twoRadius - radius);
            temp.setY(loc.getY() + random.nextDouble() * radius);
            temp.setZ(loc.getZ() + random.nextDouble() * twoRadius - radius);
            if (temp.distanceSquared(loc) > rSquared) continue;
            if (viewers == null) {
                viewers = ParticleHelper.filterPlayers(worldPlayers, temp, visibleRadius);
            }
            viewers.forEach(player -> player.spawnParticle(particle, temp, amount, dx, dy, dz, (double)speed, object));
            ++index;
        }
    }

    public static void fillHemisphere(Location loc, Settings settings, int level, int points, double visibleRadius, Particle particle, int amount, double dx, double dy, double dz, float speed, Object object) {
        ParticleHelper.fillHemisphere(loc, settings, level, points, visibleRadius, particle, amount, dx, dy, dz, speed, object, "", null);
    }

    public static Object makeObject(Particle particle, Settings settings, String particleKey) {
        return switch (particle) {
            case Particle.SCULK_CHARGE -> Float.valueOf(Float.parseFloat(settings.getString(particleKey + DATA_KEY, "0")));
            default -> ParticleHelper.makeObject(particle, Material.valueOf((String)settings.getString(particleKey + MATERIAL_KEY, "DIRT").toUpperCase().replace(" ", "_")), settings.getInt(particleKey + CMD_KEY, 0), settings.getInt(particleKey + DURABILITY_KEY, 0), Color.fromRGB((int)Integer.parseInt(settings.getString(particleKey + DUST_COLOR, "#FF0000").substring(1), 16)), Color.fromRGB((int)Integer.parseInt(settings.getString(particleKey + FINAL_DUST_COLOR, "#FF0000").substring(1), 16)), (float)settings.getDouble(particleKey + DUST_SIZE, 1.0));
        };
    }

    public static Object makeObject(Particle particle, Settings settings) {
        return ParticleHelper.makeObject(particle, settings, "");
    }

    public static Object makeObject(Particle particle, Material material, int cmd, int durability, Color dustColor, Color toColor, float dustSize) {
        BlockData object = null;
        switch (particle) {
            case REDSTONE: {
                object = new Particle.DustOptions(dustColor, dustSize);
                break;
            }
            case ITEM_CRACK: {
                ItemStack item = new ItemStack(material);
                ItemMeta meta = Objects.requireNonNull(item.getItemMeta());
                meta.setCustomModelData(Integer.valueOf(cmd));
                if (meta instanceof Damageable) {
                    ((Damageable)meta).setDamage(durability);
                }
                item.setItemMeta(meta);
                object = item;
                break;
            }
            case BLOCK_CRACK: 
            case BLOCK_DUST: 
            case FALLING_DUST: 
            case BLOCK_MARKER: {
                object = material.createBlockData();
                break;
            }
            case DUST_COLOR_TRANSITION: {
                object = new Particle.DustTransition(dustColor, toColor, dustSize);
            }
        }
        return object;
    }

    public static Set<Player> filterPlayers(Collection<Player> players, Location location, double visibleRadius) {
        visibleRadius *= visibleRadius;
        HashSet<Player> result = new HashSet<Player>();
        for (Player player : players) {
            if (!(location.distanceSquared(player.getLocation()) <= visibleRadius)) continue;
            result.add(player);
        }
        return result;
    }
}

