/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.particle;

import com.sucy.skill.api.particle.ParticleHelper;
import com.sucy.skill.api.particle.ParticleSettings;
import com.sucy.skill.api.particle.PolarSettings;
import com.sucy.skill.api.particle.direction.DirectionHandler;
import com.sucy.skill.api.particle.direction.Directions;
import com.sucy.skill.api.particle.direction.XZHandler;
import com.sucy.skill.data.Matrix3D;
import com.sucy.skill.data.Point2D;
import com.sucy.skill.data.Point3D;
import com.sucy.skill.data.formula.Formula;
import com.sucy.skill.data.formula.IValue;
import com.sucy.skill.data.formula.value.CustomValue;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class ParticleEffect {
    private static final XZHandler flatRot = (XZHandler)Directions.byName("XZ");
    private final PolarSettings shape;
    private final PolarSettings animation;
    private final ParticleSettings particle;
    private final IValue size;
    private final IValue animSize;
    private final DirectionHandler shapeDir;
    private final DirectionHandler animDir;
    private final boolean withRotation;
    private final double initialRotation;
    private final Matrix3D rotMatrix;
    private final String name;
    private final int interval;
    private final int view;

    public ParticleEffect(String name, PolarSettings shape, PolarSettings animation, ParticleSettings particle, DirectionHandler shapeDir, DirectionHandler animDir, String size, String animSize, int interval, int viewRange, boolean withRotation, double initialRotation) {
        this.name = name;
        this.shape = shape;
        this.animation = animation;
        this.withRotation = withRotation;
        this.initialRotation = Math.toRadians(initialRotation);
        if (this.initialRotation != 0.0) {
            double cos = Math.cos(this.initialRotation);
            double sin = Math.sin(this.initialRotation);
            this.rotMatrix = new Matrix3D(cos, 0.0, sin, 0.0, 1.0, 0.0, -sin, 0.0, cos);
        } else {
            this.rotMatrix = null;
        }
        this.size = new Formula(size, new CustomValue("t"), new CustomValue("p"), new CustomValue("c"), new CustomValue("s"), new CustomValue("x"), new CustomValue("y"), new CustomValue("z"), new CustomValue("v"));
        this.particle = particle;
        this.shapeDir = shapeDir;
        this.animDir = animDir;
        this.animSize = new Formula(animSize, new CustomValue("t"), new CustomValue("p"), new CustomValue("c"), new CustomValue("s"), new CustomValue("x"), new CustomValue("y"), new CustomValue("z"), new CustomValue("v"));
        this.interval = interval;
        this.view = viewRange;
        int points = shape.getPoints(shapeDir).length;
        animation.getPoints(animDir);
    }

    public String getName() {
        return this.name;
    }

    public int getInterval() {
        return this.interval;
    }

    public void play(Location loc, int frame, int level) {
        frame %= this.animation.getSteps();
        try {
            int next = (frame + 1) * this.animation.getCopies();
            Point3D[] animPoints = this.animation.getPoints(this.animDir);
            Point3D[] shapePoints = this.shape.getPoints(this.shapeDir);
            Point2D[] trig = this.animation.getTrig(frame);
            Point2D cs = trig[0];
            double t = this.animation.getT(frame);
            double p = (double)frame / (double)this.animation.getSteps();
            int j = 0;
            World world = Objects.requireNonNull(loc.getWorld());
            Set<Player> players = ParticleHelper.filterPlayers(world.getPlayers(), loc, this.view);
            Particle effect = this.particle.type;
            int count = this.particle.amount;
            double dx = this.particle.dx;
            double dy = this.particle.dy;
            double dz = this.particle.dz;
            float speed = this.particle.speed;
            Object object = this.particle.object;
            for (int i = frame * this.animation.getCopies(); i < next; ++i) {
                Point3D p1 = animPoints[i];
                double animSize = this.animSize.compute(t, p, cs.x, cs.y, p1.x, p1.y, p1.z, level);
                for (Point3D p2 : shapePoints) {
                    double size = this.size.compute(t, p, cs.x, cs.y, p2.x, p2.y, p2.z, level);
                    if (this.initialRotation != 0.0) {
                        p2 = flatRot.rotateAboutY(p2, this.rotMatrix);
                    }
                    if (this.withRotation) {
                        double yaw = Math.toRadians(-loc.getYaw());
                        p2 = flatRot.rotateAboutY(p2, yaw);
                    }
                    double x = p1.x * animSize + this.animDir.rotateX(p2, trig[j]) * size + loc.getX();
                    double y = p1.y * animSize + this.animDir.rotateY(p2, trig[j]) * size + loc.getY();
                    double z = p1.z * animSize + this.animDir.rotateZ(p2, trig[j]) * size + loc.getZ();
                    players.forEach(player -> player.spawnParticle(effect, x, y, z, count, dx, dy, dz, (double)speed, object));
                }
                ++j;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

