/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.classes;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.classes.TreeType;
import com.sucy.skill.tree.basic.BasicHorizontalTree;
import com.sucy.skill.tree.basic.BasicVerticalTree;
import com.sucy.skill.tree.basic.CustomTree;
import com.sucy.skill.tree.basic.FloodTree;
import com.sucy.skill.tree.basic.InventoryTree;
import com.sucy.skill.tree.basic.LevelHorizontalTree;
import com.sucy.skill.tree.basic.LevelVerticalTree;
import com.sucy.skill.tree.basic.RequirementTree;

public enum DefaultTreeType implements TreeType
{
    BASIC_HORIZONTAL,
    BASIC_VERTICAL,
    LEVEL_HORIZONTAL,
    LEVEL_VERTICAL,
    FLOOD,
    REQUIREMENT,
    CUSTOM;


    @Override
    public InventoryTree getTree(SkillAPI api, RPGClass parent) {
        switch (this) {
            case BASIC_HORIZONTAL: {
                return new BasicHorizontalTree(api, parent);
            }
            case BASIC_VERTICAL: {
                return new BasicVerticalTree(api, parent);
            }
            case LEVEL_HORIZONTAL: {
                return new LevelHorizontalTree(api, parent);
            }
            case LEVEL_VERTICAL: {
                return new LevelVerticalTree(api, parent);
            }
            case FLOOD: {
                return new FloodTree(api, parent);
            }
            case REQUIREMENT: {
                return new RequirementTree(api, parent);
            }
            case CUSTOM: {
                return new CustomTree(api, parent);
            }
        }
        return null;
    }

    public static DefaultTreeType getByName(String name) {
        try {
            return Enum.valueOf(DefaultTreeType.class, name.toUpperCase().replace(' ', '_'));
        }
        catch (Exception ex) {
            return REQUIREMENT;
        }
    }
}

