/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.armorstand;

import com.sucy.skill.SkillAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ArmorStandInstance {
    private static final Vector UP = new Vector(0, 1, 0);
    private final ArmorStand armorStand;
    private final LivingEntity target;
    private final boolean follow;
    private double forward;
    private double upward;
    private double right;

    public ArmorStandInstance(ArmorStand armorStand, LivingEntity target) {
        this.armorStand = armorStand;
        this.target = target;
        this.follow = false;
    }

    public ArmorStandInstance(ArmorStand armorStand, LivingEntity target, double forward, double upward, double right) {
        this.armorStand = armorStand;
        this.target = target;
        this.forward = forward;
        this.upward = upward;
        this.right = right;
        this.follow = true;
    }

    public boolean isValid() {
        return this.target.isValid() && this.armorStand.isValid();
    }

    public void remove() {
        Bukkit.getScheduler().runTask((Plugin)SkillAPI.inst(), () -> this.armorStand.remove());
    }

    public void tick() {
        if (this.follow) {
            Bukkit.getScheduler().runTask((Plugin)SkillAPI.inst(), () -> {
                Location loc = this.target.getLocation().clone();
                Vector dir = loc.getDirection().setY(0).normalize();
                Vector side = dir.clone().crossProduct(UP);
                loc.add(dir.multiply(this.forward)).add(0.0, this.upward, 0.0).add(side.multiply(this.right));
                this.armorStand.teleport(loc);
            });
        }
    }
}

