/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.CombatProtection;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.hook.NoCheatHook;
import com.sucy.skill.hook.PluginChecker;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;

public class DefaultCombatProtection
implements CombatProtection {
    @Override
    public boolean canAttack(LivingEntity attacker, LivingEntity defender, EntityDamageEvent.DamageCause cause) {
        boolean canAttack;
        if (attacker instanceof Player && defender instanceof Player) {
            PlayerClass attackerClass = SkillAPI.getPlayerData((OfflinePlayer)((Player)attacker)).getMainClass();
            PlayerClass defenderClass = SkillAPI.getPlayerData((OfflinePlayer)((Player)defender)).getMainClass();
            int attackerLevel = attackerClass == null ? 0 : attackerClass.getLevel();
            int defenderLevel = defenderClass == null ? 0 : defenderClass.getLevel();
            int minLevel = SkillAPI.getSettings().getPvpMinLevel();
            if (attackerLevel < minLevel || defenderLevel < minLevel) {
                return false;
            }
            int levelRange = SkillAPI.getSettings().getPvpLevelRange();
            if (levelRange > -1 && Math.abs(attackerLevel - defenderLevel) > levelRange) {
                return false;
            }
        }
        if (PluginChecker.isNoCheatActive() && attacker instanceof Player) {
            Player player = (Player)attacker;
            NoCheatHook.exempt(player);
            canAttack = CombatProtection.canAttack(attacker, defender);
            NoCheatHook.unexempt(player);
        } else {
            canAttack = CombatProtection.canAttack(attacker, defender, false, cause);
        }
        return canAttack;
    }

    public static class FakeEntityDamageByEntityEvent
    extends EntityDamageByEntityEvent {
        public boolean externallyCancelled = false;

        public FakeEntityDamageByEntityEvent(@NotNull Entity damager, @NotNull Entity damagee, @NotNull EntityDamageEvent.DamageCause cause, double damage) {
            super(damager, damagee, cause, damage);
        }

        public boolean isExternallyCancelled() {
            return this.externallyCancelled;
        }

        public void setExternallyCancelled(boolean externallyCancelled) {
            this.externallyCancelled = externallyCancelled;
        }
    }
}

