/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.helpmenu;

import com.plotsquared.core.command.Argument;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.configuration.caption.Templates;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.StringMan;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.Template;

public class HelpObject {
    static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private final String rendered;

    public HelpObject(Command command, String label, PlotPlayer<?> audience) {
        this.rendered = (String)MINI_MESSAGE.serialize(MINI_MESSAGE.parse(TranslatableCaption.of("help.help_item").getComponent(audience), new Template[]{Template.of((String)"usage", (String)command.getUsage().replace("{label}", label)), Template.of((String)"alias", (String)(command.getAliases().isEmpty() ? "" : StringMan.join(command.getAliases(), " | "))), Templates.of(audience, "desc", command.getDescription(), new Template[0]), Template.of((String)"arguments", (String)this.buildArgumentList(command.getRequiredArguments())), Template.of((String)"label", (String)label)}));
    }

    public String toString() {
        return this.rendered;
    }

    private String buildArgumentList(Argument<?>[] arguments) {
        if (arguments == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Argument<?> argument : arguments) {
            builder.append("[").append(argument.getName()).append(" (").append(argument.getExample()).append(")],");
        }
        return arguments.length > 0 ? builder.substring(0, builder.length() - 1) : "";
    }
}

