/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.plotsquared.core.configuration.caption.CaptionUtility;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.util.AnnotationHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FlagContainer {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + FlagContainer.class.getSimpleName()));
    private final Map<String, String> unknownFlags = new HashMap<String, String>();
    private final Map<Class<?>, PlotFlag<?, ?>> flagMap = new HashMap();
    private final PlotFlagUpdateHandler plotFlagUpdateHandler;
    private final Collection<PlotFlagUpdateHandler> updateSubscribers = new HashSet<PlotFlagUpdateHandler>();
    private final PlotFlagUpdateHandler unknownsRef;
    private FlagContainer parentContainer;

    public FlagContainer(@Nullable FlagContainer parentContainer, @Nullable PlotFlagUpdateHandler plotFlagUpdateHandler) {
        this.parentContainer = parentContainer;
        this.plotFlagUpdateHandler = plotFlagUpdateHandler;
        if (!(this instanceof GlobalFlagContainer)) {
            this.unknownsRef = this::handleUnknowns;
            GlobalFlagContainer.getInstance().subscribe(this.unknownsRef);
        } else {
            this.unknownsRef = null;
        }
    }

    public FlagContainer(@Nullable FlagContainer parentContainer) {
        this(parentContainer, null);
    }

    public static <V, T extends PlotFlag<V, ?>> T castUnsafe(PlotFlag<?, ?> flag) {
        return (T)flag;
    }

    public @Nullable FlagContainer getParentContainer() {
        return this.parentContainer;
    }

    public void setParentContainer(FlagContainer parentContainer) {
        this.parentContainer = parentContainer;
    }

    protected Map<Class<?>, PlotFlag<?, ?>> getInternalPlotFlagMap() {
        return this.flagMap;
    }

    public Map<Class<?>, PlotFlag<?, ?>> getFlagMap() {
        return ImmutableMap.builder().putAll(this.flagMap).build();
    }

    public <V, T extends PlotFlag<V, ?>> void addFlag(T flag) {
        try {
            Preconditions.checkState((flag.getName().length() <= 64 ? 1 : 0) != 0, (Object)("flag name may not be more than 64 characters. Check: " + flag.getName()));
            PlotFlag<?, ?> oldInstance = this.flagMap.put(flag.getClass(), flag);
            PlotFlagUpdateType plotFlagUpdateType = oldInstance != null ? PlotFlagUpdateType.FLAG_UPDATED : PlotFlagUpdateType.FLAG_ADDED;
            if (this.plotFlagUpdateHandler != null) {
                this.plotFlagUpdateHandler.handle(flag, plotFlagUpdateType);
            }
            this.updateSubscribers.forEach(subscriber -> subscriber.handle(flag, plotFlagUpdateType));
        }
        catch (IllegalStateException e) {
            LOGGER.info("Flag {} (class '{}') could not be added to the container because the flag name exceeded the allowed limit of 64 characters. Please tell the developer of the flag to fix this.", (Object)flag.getName(), (Object)flag.getClass().getName());
            e.printStackTrace();
        }
    }

    public <V, T extends PlotFlag<V, ?>> V removeFlag(T flag) {
        PlotFlag<?, ?> value = this.flagMap.remove(flag.getClass());
        if (this.plotFlagUpdateHandler != null) {
            this.plotFlagUpdateHandler.handle(flag, PlotFlagUpdateType.FLAG_REMOVED);
        }
        this.updateSubscribers.forEach(subscriber -> subscriber.handle(flag, PlotFlagUpdateType.FLAG_REMOVED));
        if (value == null) {
            return null;
        }
        return (V)value;
    }

    public void addAll(Collection<PlotFlag<?, ?>> flags) {
        for (PlotFlag<?, ?> flag : flags) {
            this.addFlag(flag);
        }
    }

    public void addAll(FlagContainer container) {
        this.addAll(container.flagMap.values());
    }

    public void clearLocal() {
        this.flagMap.clear();
    }

    public Collection<PlotFlag<?, ?>> getRecognizedPlotFlags() {
        return this.getHighestClassContainer().getFlagMap().values();
    }

    public final FlagContainer getHighestClassContainer() {
        if (this.getParentContainer() != null) {
            return this.getParentContainer();
        }
        return this;
    }

    public PlotFlag<?, ?> getFlagErased(Class<?> flagClass) {
        PlotFlag<?, ?> flag = this.flagMap.get(flagClass);
        if (flag != null) {
            return flag;
        }
        if (this.getParentContainer() != null) {
            return this.getParentContainer().getFlagErased(flagClass);
        }
        return null;
    }

    public <V, T extends PlotFlag<V, ?>> T getFlag(Class<? extends T> flagClass) {
        PlotFlag<?, ?> flag = this.flagMap.get(flagClass);
        if (flag != null) {
            return FlagContainer.castUnsafe(flag);
        }
        if (this.getParentContainer() != null) {
            return this.getParentContainer().getFlag(flagClass);
        }
        return null;
    }

    public <V, T extends PlotFlag<V, ?>> @Nullable T queryLocal(Class<?> flagClass) {
        PlotFlag<?, ?> localFlag = this.flagMap.get(flagClass);
        if (localFlag == null) {
            return null;
        }
        return FlagContainer.castUnsafe(localFlag);
    }

    public void subscribe(@NonNull PlotFlagUpdateHandler plotFlagUpdateHandler) {
        this.updateSubscribers.add(plotFlagUpdateHandler);
    }

    private void handleUnknowns(PlotFlag<?, ?> flag, PlotFlagUpdateType plotFlagUpdateType) {
        String value;
        if (plotFlagUpdateType != PlotFlagUpdateType.FLAG_REMOVED && this.unknownFlags.containsKey(flag.getName()) && (value = this.unknownFlags.remove(flag.getName())) != null) {
            value = CaptionUtility.stripClickEvents(flag, value);
            try {
                this.addFlag((PlotFlag)flag.parse(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addUnknownFlag(String flagName, String value) {
        this.unknownFlags.put(flagName.toLowerCase(Locale.ENGLISH), value);
    }

    @AnnotationHelper.ApiDescription(info="This method should not be considered as public or API.")
    public Runnable createCleanupHook() {
        return () -> GlobalFlagContainer.getInstance().unsubscribe(this.unknownsRef);
    }

    void unsubscribe(@Nullable PlotFlagUpdateHandler updateHandler) {
        if (updateHandler != null) {
            this.updateSubscribers.remove(updateHandler);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagContainer that = (FlagContainer)o;
        return this.flagMap.equals(that.flagMap);
    }

    public int hashCode() {
        return this.flagMap.hashCode();
    }

    @Deprecated(forRemoval=true, since="6.6.0")
    protected boolean canEqual(Object other) {
        return other instanceof FlagContainer;
    }

    @FunctionalInterface
    public static interface PlotFlagUpdateHandler {
        public void handle(PlotFlag<?, ?> var1, PlotFlagUpdateType var2);
    }

    public static enum PlotFlagUpdateType {
        FLAG_ADDED,
        FLAG_REMOVED,
        FLAG_UPDATED;

    }
}

