/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.google.inject.Inject;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.queue.ScopedQueueCoordinator;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SingleWorldGenerator
extends IndependentPlotGenerator {
    private static final Location bedrock1 = Location.at("", 0, 0, 0);
    private static final Location bedrock2 = Location.at("", 15, 0, 15);
    private static final Location dirt1 = Location.at("", 0, 1, 0);
    private static final Location dirt2 = Location.at("", 15, 2, 15);
    private static final Location grass1 = Location.at("", 0, 3, 0);
    private static final Location grass2 = Location.at("", 15, 3, 15);
    private final PlotAreaManager plotAreaManager;

    @Inject
    public SingleWorldGenerator(@NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
    }

    @Override
    public String getName() {
        return "PlotSquared:single";
    }

    @Override
    public void generateChunk(ScopedQueueCoordinator result, PlotArea settings) {
        SinglePlotArea area = (SinglePlotArea)settings;
        if (area.VOID) {
            Location min = result.getMin();
            if (min.getX() == 0 && min.getZ() == 0) {
                result.setBlock(0, 0, 0, BlockTypes.BEDROCK.getDefaultState());
            }
        } else {
            result.setCuboid(bedrock1, bedrock2, BlockTypes.BEDROCK.getDefaultState());
            result.setCuboid(dirt1, dirt2, BlockTypes.DIRT.getDefaultState());
            result.setCuboid(grass1, grass2, BlockTypes.GRASS_BLOCK.getDefaultState());
        }
        result.fillBiome(BiomeTypes.PLAINS);
    }

    @Override
    public PlotArea getNewPlotArea(String world, String id, PlotId min, PlotId max) {
        return ((SinglePlotAreaManager)this.plotAreaManager).getArea();
    }

    @Override
    public void initialize(PlotArea area) {
    }
}

