/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.CaptionHolder;
import com.plotsquared.core.configuration.caption.Templates;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.expiration.ExpireManager;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.PriceFlag;
import com.plotsquared.core.plot.flag.implementations.ServerPlotFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.StringComparison;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.query.SortingStrategy;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.core.uuid.UUIDMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="list", aliases={"l", "find", "search"}, permission="plots.list", category=CommandCategory.INFO, usage="/plot list <forsale | mine | shared | world | top | all | unowned | player | world | done | fuzzy <search...>> [#]")
public class ListCmd
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final EconHandler econHandler;

    @Inject
    public ListCmd(@NonNull PlotAreaManager plotAreaManager, @NonNull EconHandler econHandler) {
        this.plotAreaManager = plotAreaManager;
        this.econHandler = econHandler;
    }

    private String[] getArgumentList(PlotPlayer<?> player) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.econHandler != null && Permissions.hasPermission(player, Permission.PERMISSION_LIST_FOR_SALE)) {
            args.add("forsale");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_MINE)) {
            args.add("mine");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_SHARED)) {
            args.add("shared");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_WORLD)) {
            args.add("world");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_TOP)) {
            args.add("top");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_ALL)) {
            args.add("all");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_UNOWNED)) {
            args.add("unowned");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_PLAYER)) {
            args.add("<player>");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_WORLD)) {
            args.add("<world>");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_DONE)) {
            args.add("done");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_EXPIRED)) {
            args.add("expired");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_FUZZY)) {
            args.add("fuzzy <search...>");
        }
        return args.toArray(new String[args.size()]);
    }

    public void noArgs(PlotPlayer<?> player) {
        player.sendMessage(TranslatableCaption.of("commandconfig.subcommand_set_options_header"), Templates.of("values", Arrays.toString(this.getArgumentList(player))));
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        int page;
        if (args.length < 1) {
            this.noArgs(player);
            return false;
        }
        if (args.length > 1) {
            int tempPage = -1;
            try {
                tempPage = Integer.parseInt(args[args.length - 1]);
                if (--tempPage < 0) {
                    tempPage = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            page = tempPage;
        } else {
            page = 0;
        }
        String world = player.getLocation().getWorldName();
        PlotArea area = player.getApplicablePlotArea();
        String arg = args[0].toLowerCase();
        boolean[] sort = new boolean[]{true};
        Consumer<PlotQuery> plotConsumer = query -> {
            List<Plot> plots;
            if (query == null) {
                player.sendMessage(TranslatableCaption.of("commandconfig.did_you_mean"), Template.of((String)"value", (String)new StringComparison<String>(args[0], new String[]{"mine", "shared", "world", "all"}).getBestMatch()));
                return;
            }
            if (area != null) {
                query.relativeToArea(area);
            }
            if (sort[0]) {
                query.withSortingStrategy(SortingStrategy.SORT_BY_CREATION);
            }
            if ((plots = query.asList()).isEmpty()) {
                player.sendMessage(TranslatableCaption.of("invalid.found_no_plots"), new Template[0]);
                return;
            }
            this.displayPlots(player, plots, 12, page, args);
        };
        switch (arg) {
            case "mine": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_LIST_MINE)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.mine"));
                    return false;
                }
                sort[0] = false;
                plotConsumer.accept(PlotQuery.newQuery().ownersInclude(player).whereBasePlot().withSortingStrategy(SortingStrategy.SORT_BY_TEMP));
                break;
            }
            case "shared": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_LIST_SHARED)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.shared"));
                    return false;
                }
                plotConsumer.accept(PlotQuery.newQuery().withMember(player.getUUID()).thatPasses(plot -> !plot.isOwnerAbs(player.getUUID())));
                break;
            }
            case "world": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_LIST_WORLD)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.world"));
                    return false;
                }
                if (!Permissions.hasPermission(player, "plots.list.world." + world)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.world." + world));
                    return false;
                }
                plotConsumer.accept(PlotQuery.newQuery().inWorld(world));
                break;
            }
            case "expired": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_LIST_EXPIRED)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.expired"));
                    return false;
                }
                if (ExpireManager.IMP == null) {
                    plotConsumer.accept(PlotQuery.newQuery().noPlots());
                    break;
                }
                plotConsumer.accept(PlotQuery.newQuery().expiredPlots());
                break;
            }
            case "area": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_LIST_AREA)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.area"));
                    return false;
                }
                if (!Permissions.hasPermission(player, "plots.list.world." + world)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.world." + world));
                    return false;
                }
                if (area == null) {
                    plotConsumer.accept(PlotQuery.newQuery().noPlots());
                    break;
                }
                plotConsumer.accept(PlotQuery.newQuery().inArea(area));
                break;
            }
            case "all": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_LIST_ALL)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.all"));
                    return false;
                }
                plotConsumer.accept(PlotQuery.newQuery().allPlots());
                break;
            }
            case "done": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_LIST_DONE)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.done"));
                    return false;
                }
                sort[0] = false;
                plotConsumer.accept(PlotQuery.newQuery().allPlots().thatPasses(DoneFlag::isDone).withSortingStrategy(SortingStrategy.SORT_BY_DONE));
                break;
            }
            case "top": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_LIST_TOP)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.top"));
                    return false;
                }
                sort[0] = false;
                plotConsumer.accept(PlotQuery.newQuery().allPlots().withSortingStrategy(SortingStrategy.SORT_BY_RATING));
                break;
            }
            case "forsale": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_LIST_FOR_SALE)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.forsale"));
                    return false;
                }
                if (this.econHandler.isSupported()) break;
                plotConsumer.accept(PlotQuery.newQuery().allPlots().thatPasses(plot -> (Double)plot.getFlag(PriceFlag.class) > 0.0));
                break;
            }
            case "unowned": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_LIST_UNOWNED)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.unowned"));
                    return false;
                }
                plotConsumer.accept(PlotQuery.newQuery().allPlots().thatPasses(plot -> plot.getOwner() == null));
                break;
            }
            case "fuzzy": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_LIST_FUZZY)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.fuzzy"));
                    return false;
                }
                if (args.length < (page == -1 ? 2 : 3)) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Templates.of("value", "/plot list fuzzy <search...> [#]"));
                    return false;
                }
                String term = MathMan.isInteger(args[args.length - 1]) ? StringMan.join(Arrays.copyOfRange(args, 1, args.length - 1), " ") : StringMan.join(Arrays.copyOfRange(args, 1, args.length), " ");
                sort[0] = false;
                plotConsumer.accept(PlotQuery.newQuery().plotsBySearch(term));
                break;
            }
            default: {
                if (this.plotAreaManager.hasPlotArea(args[0])) {
                    if (!Permissions.hasPermission(player, Permission.PERMISSION_LIST_WORLD)) {
                        player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.world"));
                        return false;
                    }
                    if (!Permissions.hasPermission(player, "plots.list.world." + args[0])) {
                        player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.world." + args[0]));
                        return false;
                    }
                    plotConsumer.accept(PlotQuery.newQuery().inWorld(args[0]));
                    break;
                }
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(args[0], (uuid, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new Template[0]);
                    } else if (throwable != null && uuid == null) {
                        try {
                            uuid = UUID.fromString(args[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (uuid == null) {
                        player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Templates.of("value", args[0]));
                    } else if (!Permissions.hasPermission((PermissionHolder)player, Permission.PERMISSION_LIST_PLAYER)) {
                        player.sendMessage(TranslatableCaption.of("permission.no_permission"), Templates.of("node", "plots.list.player"));
                    } else {
                        sort[0] = false;
                        plotConsumer.accept(PlotQuery.newQuery().ownersInclude((UUID)uuid).whereBasePlot().withSortingStrategy(SortingStrategy.SORT_BY_TEMP));
                    }
                });
            }
        }
        return true;
    }

    public void displayPlots(final PlotPlayer<?> player, List<Plot> plots, int pageSize, int page, String[] args) {
        plots.removeIf(plot -> !plot.isBasePlot());
        this.paginate(player, plots, pageSize, page, new RunnableVal3<Integer, Plot, CaptionHolder>(){

            @Override
            public void run(Integer i, Plot plot, CaptionHolder caption) {
                TranslatableCaption color = plot.getOwner() == null ? TranslatableCaption.of("info.plot_list_no_owner") : (plot.isOwner(player.getUUID()) || plot.getOwner().equals(DBFunc.EVERYONE) ? TranslatableCaption.of("info.plot_list_owned_by") : (plot.isAdded(player.getUUID()) ? TranslatableCaption.of("info.plot_list_added_to") : (plot.isDenied(player.getUUID()) ? TranslatableCaption.of("info.plot_list_denied_on") : TranslatableCaption.of("info.plot_list_default"))));
                Component trusted = Command.MINI_MESSAGE.parse(TranslatableCaption.of("info.plot_info_trusted").getComponent(player), new Template[]{Template.of((String)"trusted", (Component)PlayerManager.getPlayerList(plot.getTrusted(), player))});
                Component members = Command.MINI_MESSAGE.parse(TranslatableCaption.of("info.plot_info_members").getComponent(player), new Template[]{Template.of((String)"members", (Component)PlayerManager.getPlayerList(plot.getMembers(), player))});
                Template command_tp = Template.of((String)"command_tp", (String)("/plot visit " + plot.getArea() + ";" + plot.getId()));
                Template command_info = Template.of((String)"command_info", (String)("/plot info " + plot.getArea() + ";" + plot.getId()));
                Template hover_info = Template.of((String)"hover_info", (String)((String)Command.MINI_MESSAGE.serialize(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(trusted)).append((Component)Component.newline())).append(members)).asComponent())));
                Template numberTemplate = Template.of((String)"number", (String)String.valueOf(i));
                Template plotTemplate = Template.of((String)"plot", (Component)Command.MINI_MESSAGE.parse(color.getComponent(player), new Template[]{Template.of((String)"plot", (String)plot.toString())}));
                String prefix = "";
                String online = TranslatableCaption.of("info.plot_list_player_online").getComponent(player);
                String offline = TranslatableCaption.of("info.plot_list_player_offline").getComponent(player);
                String unknown = TranslatableCaption.of("info.plot_list_player_unknown").getComponent(player);
                String server = TranslatableCaption.of("info.plot_list_player_server").getComponent(player);
                String everyone = TranslatableCaption.of("info.plot_list_player_everyone").getComponent(player);
                TextComponent.Builder builder = Component.text();
                if (((Boolean)plot.getFlag(ServerPlotFlag.class)).booleanValue()) {
                    Template serverTemplate = Template.of((String)"info.server", (String)TranslatableCaption.of("info.server").getComponent(player));
                    builder.append(Command.MINI_MESSAGE.parse(server, new Template[]{serverTemplate}));
                } else {
                    try {
                        List<UUIDMapping> names = PlotSquared.get().getImpromptuUUIDPipeline().getNames(plot.getOwners()).get(Settings.UUID.BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS);
                        for (UUIDMapping uuidMapping : names) {
                            PlotPlayer<?> pp = PlotSquared.platform().playerManager().getPlayerIfExists(uuidMapping.getUuid());
                            Template prefixTemplate = Template.of((String)"prefix", (String)prefix);
                            Template playerTemplate = Template.of((String)"player", (String)uuidMapping.getUsername());
                            if (pp != null) {
                                builder.append(Command.MINI_MESSAGE.parse(online, new Template[]{prefixTemplate, playerTemplate}));
                            } else if (uuidMapping.getUsername().equalsIgnoreCase("unknown")) {
                                Template unknownTemplate = Template.of((String)"info.unknown", (String)TranslatableCaption.of("info.unknown").getComponent(player));
                                builder.append(Command.MINI_MESSAGE.parse(unknown, new Template[]{unknownTemplate}));
                            } else if (uuidMapping.getUuid().equals(DBFunc.EVERYONE)) {
                                Template everyoneTemplate = Template.of((String)"info.everyone", (String)TranslatableCaption.of("info.everyone").getComponent(player));
                                builder.append(Command.MINI_MESSAGE.parse(everyone, new Template[]{everyoneTemplate}));
                            } else {
                                builder.append(Command.MINI_MESSAGE.parse(offline, new Template[]{prefixTemplate, playerTemplate}));
                            }
                            prefix = ", ";
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        StringBuilder playerBuilder = new StringBuilder();
                        Iterator<UUID> uuidIterator = plot.getOwners().iterator();
                        while (uuidIterator.hasNext()) {
                            UUID uuid = uuidIterator.next();
                            playerBuilder.append(uuid);
                            if (!uuidIterator.hasNext()) continue;
                            playerBuilder.append(", ");
                        }
                        player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Templates.of("value", playerBuilder.toString()));
                    }
                    catch (TimeoutException e) {
                        player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new Template[0]);
                    }
                }
                Template players = Template.of((String)"players", (Component)builder.asComponent());
                caption.set(TranslatableCaption.of("info.plot_list_item"));
                caption.setTemplates(command_tp, command_info, hover_info, numberTemplate, plotTemplate, players);
            }
        }, "/plot list " + args[0], TranslatableCaption.of("list.plot_list_header_paged"));
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        LinkedList<String> completions = new LinkedList<String>();
        if (this.econHandler.isSupported() && Permissions.hasPermission(player, Permission.PERMISSION_LIST_FOR_SALE)) {
            completions.add("forsale");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_MINE)) {
            completions.add("mine");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_SHARED)) {
            completions.add("shared");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_WORLD)) {
            completions.addAll(PlotSquared.platform().worldManager().getWorlds());
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_TOP)) {
            completions.add("top");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_ALL)) {
            completions.add("all");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_UNOWNED)) {
            completions.add("unowned");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_DONE)) {
            completions.add("done");
        }
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_EXPIRED)) {
            completions.add("expired");
        }
        List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.NONE, CommandCategory.TELEPORT){}).collect(Collectors.toCollection(LinkedList::new));
        if (Permissions.hasPermission(player, Permission.PERMISSION_LIST_PLAYER) && args[0].length() > 0) {
            commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
        }
        return commands;
    }
}

