/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.query;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.util.query.PlotProvider;
import com.plotsquared.core.util.query.PlotQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.NonNull;

class SearchPlotProvider
implements PlotProvider {
    private final String searchTerm;

    SearchPlotProvider(@NonNull String searchTerm) {
        this.searchTerm = searchTerm;
    }

    private static @NonNull List<Plot> getPlotsBySearch(@NonNull String search) {
        String[] split = search.split(" ");
        int size = split.length * 2;
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        PlotId id = null;
        for (String term : split) {
            try {
                UUID uuid = PlotSquared.get().getImpromptuUUIDPipeline().getSingle(term, Settings.UUID.BLOCKING_TIMEOUT);
                if (uuid == null) {
                    uuid = UUID.fromString(term);
                }
                uuids.add(uuid);
            }
            catch (Exception ignored) {
                id = PlotId.fromString(term);
            }
        }
        ArrayList plotList = IntStream.range(0, size).mapToObj(i -> new ArrayList()).collect(Collectors.toCollection(() -> new ArrayList(size)));
        Object area = null;
        String alias = null;
        for (Plot plot : PlotQuery.newQuery().allPlots()) {
            int count = 0;
            if (!uuids.isEmpty()) {
                for (UUID uuid : uuids) {
                    if (plot.isOwner(uuid)) {
                        count += 2;
                        continue;
                    }
                    if (!plot.isAdded(uuid)) continue;
                    ++count;
                }
            }
            if (id != null && plot.getId().equals(id)) {
                ++count;
            }
            if (area != null && plot.getArea().equals(area)) {
                ++count;
            }
            if (alias != null && alias.equals(plot.getAlias())) {
                count += 2;
            }
            if (count == 0) continue;
            ((ArrayList)plotList.get(count - 1)).add(plot);
        }
        ArrayList<Plot> plots = new ArrayList<Plot>();
        for (int i2 = plotList.size() - 1; i2 >= 0; --i2) {
            if (((ArrayList)plotList.get(i2)).isEmpty()) continue;
            plots.addAll((Collection)plotList.get(i2));
        }
        return plots;
    }

    @Override
    public Collection<Plot> getPlots() {
        return SearchPlotProvider.getPlotsBySearch(this.searchTerm);
    }
}

