/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.location.Location;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.NonNull;

public class RegionUtil {
    public static @NonNull Location[] getCorners(@NonNull String world, @NonNull CuboidRegion region) {
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 max = region.getMaximumPoint();
        return new Location[]{Location.at(world, min), Location.at(world, max)};
    }

    public static @NonNull Location[] getCorners(String world, Collection<CuboidRegion> regions) {
        CuboidRegion aabb = RegionUtil.getAxisAlignedBoundingBox(regions);
        return RegionUtil.getCorners(world, aabb);
    }

    public static @NonNull CuboidRegion getAxisAlignedBoundingBox(Iterable<CuboidRegion> regions) {
        Iterator<CuboidRegion> iterator = regions.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("No regions given");
        }
        CuboidRegion next = iterator.next();
        BlockVector3 min = next.getMinimumPoint();
        BlockVector3 max = next.getMaximumPoint();
        while (iterator.hasNext()) {
            next = iterator.next();
            min = min.getMinimum(next.getMinimumPoint());
            max = max.getMaximum(next.getMaximumPoint());
        }
        return new CuboidRegion(min, max);
    }

    @Deprecated(forRemoval=true, since="6.6.0")
    public static CuboidRegion createRegion(int pos1x, int pos2x, int pos1z, int pos2z) {
        return RegionUtil.createRegion(pos1x, pos2x, 0, 255, pos1z, pos2z);
    }

    public static CuboidRegion createRegion(int pos1x, int pos2x, int pos1y, int pos2y, int pos1z, int pos2z) {
        BlockVector3 pos1 = BlockVector3.at((int)pos1x, (int)pos1y, (int)pos1z);
        BlockVector3 pos2 = BlockVector3.at((int)pos2x, (int)pos2y, (int)pos2z);
        return new CuboidRegion(pos1, pos2);
    }

    public static boolean contains(CuboidRegion region, int x, int z) {
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 max = region.getMaximumPoint();
        return x >= min.getX() && x <= max.getX() && z >= min.getZ() && z <= max.getZ();
    }

    public static boolean contains(CuboidRegion region, int x, int y, int z) {
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 max = region.getMaximumPoint();
        return x >= min.getX() && x <= max.getX() && z >= min.getZ() && z <= max.getZ() && y >= min.getY() && y <= max.getY();
    }

    public static @NonNull Rectangle2D toRectangle(@NonNull CuboidRegion region) {
        BlockVector2 min = region.getMinimumPoint().toBlockVector2();
        BlockVector2 max = region.getMaximumPoint().toBlockVector2();
        return new Rectangle2D.Double(min.getX(), min.getZ(), max.getX(), max.getZ());
    }

    public static boolean intersects(CuboidRegion region, CuboidRegion other) {
        BlockVector3 regionMin = region.getMinimumPoint();
        BlockVector3 regionMax = region.getMaximumPoint();
        BlockVector3 otherMin = other.getMinimumPoint();
        BlockVector3 otherMax = other.getMaximumPoint();
        return otherMin.getX() <= regionMax.getX() && otherMax.getX() >= regionMin.getX() && otherMin.getZ() <= regionMax.getZ() && otherMax.getZ() >= regionMin.getZ();
    }
}

