/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.PlotFlag;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FlyFlag
extends PlotFlag<FlyStatus, FlyFlag> {
    public static final FlyFlag FLIGHT_FLAG_DISABLED = new FlyFlag(FlyStatus.DISABLED);
    public static final FlyFlag FLIGHT_FLAG_ENABLED = new FlyFlag(FlyStatus.ENABLED);
    public static final FlyFlag FLIGHT_FLAG_DEFAULT = new FlyFlag(FlyStatus.DEFAULT);

    protected FlyFlag(FlyStatus value) {
        super(value, TranslatableCaption.of("flags.flag_category_boolean"), TranslatableCaption.of("flags.flag_description_flight"));
    }

    @Override
    public FlyFlag parse(@NonNull String input) {
        return switch (input.toLowerCase()) {
            case "true", "enabled", "allow" -> FLIGHT_FLAG_ENABLED;
            case "false", "disabled", "disallow" -> FLIGHT_FLAG_DISABLED;
            default -> FLIGHT_FLAG_DEFAULT;
        };
    }

    @Override
    public FlyFlag merge(@NonNull FlyStatus newValue) {
        if (newValue == FlyStatus.ENABLED || this.getValue() == FlyStatus.ENABLED) {
            return FLIGHT_FLAG_ENABLED;
        }
        return this.flagOf(newValue);
    }

    @Override
    public String toString() {
        return ((FlyStatus)((Object)this.getValue())).name().toLowerCase();
    }

    @Override
    public String getExample() {
        return "true";
    }

    @Override
    protected FlyFlag flagOf(@NonNull FlyStatus value) {
        switch (value) {
            case ENABLED: {
                return FLIGHT_FLAG_ENABLED;
            }
            case DISABLED: {
                return FLIGHT_FLAG_DISABLED;
            }
        }
        return FLIGHT_FLAG_DEFAULT;
    }

    @Override
    public Collection<String> getTabCompletions() {
        return Arrays.asList("true", "false", "default");
    }

    public static enum FlyStatus {
        ENABLED,
        DISABLED,
        DEFAULT;

    }
}

