/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.plotsquared.core.location.Direction;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PlotId {
    private final int x;
    private final int y;
    private final int hash;

    private PlotId(int x, int y) {
        this.x = x;
        this.y = y;
        this.hash = this.getX() << 16 | this.getY() & 0xFFFF;
    }

    public static @NonNull PlotId of(int x, int y) {
        return new PlotId(x, y);
    }

    public static @NonNull PlotId fromString(@NonNull String string) {
        PlotId plot = PlotId.fromStringOrNull(string);
        if (plot == null) {
            throw new IllegalArgumentException("Cannot create PlotID. String invalid.");
        }
        return plot;
    }

    public static @Nullable PlotId fromStringOrNull(@NonNull String string) {
        int y;
        int x;
        String[] parts = string.split("[;_,.]");
        if (parts.length < 2) {
            return null;
        }
        try {
            x = Integer.parseInt(parts[0]);
            y = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        return PlotId.of(x, y);
    }

    public static @NonNull PlotId unpair(int hash) {
        return PlotId.of(hash >> 16, hash & 0xFFFF);
    }

    public @NonNull PlotId copy() {
        return PlotId.of(this.getX(), this.getY());
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public @NonNull PlotId getNextId() {
        int absY;
        int absX = Math.abs(this.x);
        if (absX > (absY = Math.abs(this.y))) {
            if (this.x > 0) {
                return PlotId.of(this.x, this.y + 1);
            }
            return PlotId.of(this.x, this.y - 1);
        }
        if (absY > absX) {
            if (this.y > 0) {
                return PlotId.of(this.x - 1, this.y);
            }
            return PlotId.of(this.x + 1, this.y);
        }
        if (this.x == this.y && this.x > 0) {
            return PlotId.of(this.x, this.y + 1);
        }
        if (this.x == absX) {
            return PlotId.of(this.x, this.y + 1);
        }
        if (this.y == absY) {
            return PlotId.of(this.x, this.y - 1);
        }
        return PlotId.of(this.x + 1, this.y);
    }

    public @NonNull PlotId getRelative(@NonNull Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> PlotId.of(this.getX(), this.getY() - 1);
            case Direction.EAST -> PlotId.of(this.getX() + 1, this.getY());
            case Direction.SOUTH -> PlotId.of(this.getX(), this.getY() + 1);
            case Direction.WEST -> PlotId.of(this.getX() - 1, this.getY());
            default -> this;
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlotId other = (PlotId)obj;
        return this.getX() == other.getX() && this.getY() == other.getY();
    }

    public @NonNull String toString() {
        return this.getX() + ";" + this.getY();
    }

    public @NonNull String toSeparatedString(String separator) {
        return this.getX() + separator + this.getY();
    }

    public @NonNull String toCommaSeparatedString() {
        return this.getX() + "," + this.getY();
    }

    public @NonNull String toUnderscoreSeparatedString() {
        return this.getX() + "_" + this.getY();
    }

    public @NonNull String toDashSeparatedString() {
        return this.getX() + "-" + this.getY();
    }

    public int hashCode() {
        return this.hash;
    }

    public static final class PlotRangeIterator
    implements Iterator<PlotId>,
    Iterable<PlotId> {
        private final PlotId start;
        private final PlotId end;
        private int x;
        private int y;

        private PlotRangeIterator(@NonNull PlotId start, @NonNull PlotId end) {
            this.start = start;
            this.end = end;
            this.x = this.start.getX();
            this.y = this.start.getY();
        }

        public static PlotRangeIterator range(@NonNull PlotId start, @NonNull PlotId end) {
            return new PlotRangeIterator(start, end);
        }

        @Override
        public boolean hasNext() {
            return this.x <= this.end.getX() && this.y <= this.end.getY();
        }

        @Override
        public PlotId next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("The iterator has no more entries");
            }
            PlotId result = PlotId.of(this.x, this.y);
            if (this.y == this.end.getY()) {
                ++this.x;
                this.y = this.start.getY();
            } else {
                ++this.y;
            }
            return result;
        }

        @Override
        public @NonNull Iterator<PlotId> iterator() {
            return this;
        }
    }
}

