/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.components;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.components.ComponentCommand;
import com.plotsquared.core.components.ComponentPreset;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.configuration.serialization.ConfigurationSerialization;
import com.plotsquared.core.generator.ClassicPlotManagerComponent;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotInventory;
import com.plotsquared.core.plot.PlotItemStack;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.InventoryUtil;
import com.plotsquared.core.util.PatternUtil;
import com.plotsquared.core.util.Permissions;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.Template;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ComponentPresetManager {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + ComponentPresetManager.class.getSimpleName()));
    private final List<ComponentPreset> presets;
    private final EconHandler econHandler;
    private final InventoryUtil inventoryUtil;
    private File componentsFile;

    @Inject
    public ComponentPresetManager(@NonNull EconHandler econHandler, @NonNull InventoryUtil inventoryUtil) throws IOException {
        this.econHandler = econHandler;
        this.inventoryUtil = inventoryUtil;
        File oldLocation = new File(Objects.requireNonNull(PlotSquared.platform()).getDirectory(), "components.yml");
        File folder = new File(Objects.requireNonNull(PlotSquared.platform()).getDirectory(), "config");
        if (!folder.exists() && !folder.mkdirs()) {
            LOGGER.error("Failed to create the /plugins/PlotSquared/config folder. Please create it manually");
        }
        if (oldLocation.exists()) {
            Path oldLoc = Paths.get(PlotSquared.platform().getDirectory() + "/components.yml", new String[0]);
            Path newLoc = Paths.get(PlotSquared.platform().getDirectory() + "/config/components.yml", new String[0]);
            Files.move(oldLoc, newLoc, new CopyOption[0]);
        }
        try {
            this.componentsFile = new File(folder, "components.yml");
            if (!this.componentsFile.exists() && !this.componentsFile.createNewFile()) {
                LOGGER.error("Could not create the components.yml file. Please create 'components.yml' manually.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ConfigurationSerialization.registerClass(ComponentPreset.class, "ComponentPreset");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration(this.componentsFile);
        if (yamlConfiguration.contains("title")) {
            yamlConfiguration.set("title", "#Now in /lang/messages_%.json, preset.title");
            try {
                yamlConfiguration.save(this.componentsFile);
            }
            catch (IOException e) {
                LOGGER.error("Failed to save default values to components.yml", (Throwable)e);
            }
        }
        if (yamlConfiguration.contains("presets")) {
            this.presets = yamlConfiguration.getMapList("presets").stream().map(o -> o).map(ComponentPreset::deserialize).collect(Collectors.toList());
        } else {
            List<ComponentPreset> defaultPreset = Collections.singletonList(new ComponentPreset(ClassicPlotManagerComponent.FLOOR, "##wool", 0.0, "", "<rainbow:2>Disco Floor</rainbow>", List.of("<gold>Spice up your plot floor</gold>"), ItemTypes.YELLOW_WOOL));
            yamlConfiguration.set("presets", defaultPreset.stream().map(ComponentPreset::serialize).collect(Collectors.toList()));
            try {
                yamlConfiguration.save(this.componentsFile);
            }
            catch (IOException e) {
                LOGGER.error("Failed to save default values to components.yml", (Throwable)e);
            }
            this.presets = defaultPreset;
        }
        MainCommand.getInstance().register(new ComponentCommand(this));
    }

    public @Nullable PlotInventory buildInventory(final PlotPlayer<?> player) {
        final Plot plot = player.getCurrentPlot();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return null;
        }
        if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("info.plot_unowned"), new Template[0]);
            return null;
        }
        if (!(plot.isOwner(player.getUUID()) || plot.getTrusted().contains(player.getUUID()) || Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_COMPONENTS_OTHER))) {
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
            return null;
        }
        if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new Template[0]);
            return null;
        }
        final ArrayList<ComponentPreset> allowedPresets = new ArrayList<ComponentPreset>(this.presets.size());
        for (ComponentPreset componentPreset : this.presets) {
            if (!componentPreset.getPermission().isEmpty() && !Permissions.hasPermission(player, componentPreset.getPermission())) continue;
            allowedPresets.add(componentPreset);
        }
        if (allowedPresets.isEmpty()) {
            player.sendMessage(TranslatableCaption.of("preset.empty"), new Template[0]);
            return null;
        }
        int size = (int)Math.ceil((double)allowedPresets.size() / 9.0);
        PlotInventory plotInventory = new PlotInventory(this.inventoryUtil, player, size, TranslatableCaption.of("preset.title").getComponent(player)){

            @Override
            public boolean onClick(int index) {
                if (!this.getPlayer().getCurrentPlot().equals(plot)) {
                    return false;
                }
                if (index < 0 || index >= allowedPresets.size()) {
                    return false;
                }
                ComponentPreset componentPreset = (ComponentPreset)allowedPresets.get(index);
                if (componentPreset == null) {
                    return false;
                }
                if (plot.getRunning() > 0) {
                    this.getPlayer().sendMessage(TranslatableCaption.of("errors.wait_for_timer"), new Template[0]);
                    return false;
                }
                Pattern pattern = PatternUtil.parse(null, componentPreset.getPattern(), false);
                if (pattern == null) {
                    this.getPlayer().sendMessage(TranslatableCaption.of("preset.preset_invalid"), new Template[0]);
                    return false;
                }
                if (componentPreset.getCost() > 0.0) {
                    if (!ComponentPresetManager.this.econHandler.isEnabled(plot.getArea())) {
                        this.getPlayer().sendMessage(TranslatableCaption.of("preset.economy_disabled"), Template.of((String)"preset", (String)componentPreset.getDisplayName()));
                        return false;
                    }
                    if (ComponentPresetManager.this.econHandler.getMoney(this.getPlayer()) < componentPreset.getCost()) {
                        this.getPlayer().sendMessage(TranslatableCaption.of("preset.preset_cannot_afford"), new Template[0]);
                        return false;
                    }
                    ComponentPresetManager.this.econHandler.withdrawMoney(this.getPlayer(), componentPreset.getCost());
                    this.getPlayer().sendMessage(TranslatableCaption.of("economy.removed_balance"), Template.of((String)"money", (String)ComponentPresetManager.this.econHandler.format(componentPreset.getCost())));
                }
                BackupManager.backup(this.getPlayer(), plot, () -> {
                    plot.addRunning();
                    QueueCoordinator queue = plot.getArea().getQueue();
                    queue.setCompleteTask(plot::removeRunning);
                    for (Plot current : plot.getConnectedPlots()) {
                        current.getPlotModificationManager().setComponent(componentPreset.getComponent().name(), pattern, player, queue);
                    }
                    queue.enqueue();
                    this.getPlayer().sendMessage(TranslatableCaption.of("working.generating_component"), new Template[0]);
                });
                return false;
            }
        };
        for (int i = 0; i < allowedPresets.size(); ++i) {
            ComponentPreset preset = (ComponentPreset)allowedPresets.get(i);
            ArrayList<String> lore = new ArrayList<String>();
            if (preset.getCost() > 0.0) {
                if (!this.econHandler.isEnabled(plot.getArea())) {
                    lore.add((String)MINI_MESSAGE.serialize(MINI_MESSAGE.parse(TranslatableCaption.of("preset.preset_lore_economy_disabled").getComponent(player))));
                } else {
                    lore.add((String)MINI_MESSAGE.serialize(MINI_MESSAGE.parse(TranslatableCaption.of("preset.preset_lore_cost").getComponent(player), new Template[]{Template.of((String)"cost", (String)String.format("%.2f", preset.getCost()))})));
                }
            }
            lore.add((String)MINI_MESSAGE.serialize(MINI_MESSAGE.parse(TranslatableCaption.of("preset.preset_lore_component").getComponent(player), new Template[]{Template.of((String)"component", (String)preset.getComponent().name().toLowerCase()), Template.of((String)"prefix", (String)TranslatableCaption.of("core.prefix").getComponent(player))})));
            lore.removeIf(String::isEmpty);
            lore.addAll(preset.getDescription());
            plotInventory.setItem(i, new PlotItemStack(preset.getIcon().getId().replace("minecraft:", ""), 1, preset.getDisplayName(), lore.toArray(new String[0])));
        }
        return plotInventory;
    }
}

