/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.PlotTitle;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PlotTitleFlag
extends PlotFlag<PlotTitle, PlotTitleFlag> {
    public static final PlotTitleFlag TITLE_FLAG_DEFAULT = new PlotTitleFlag(PlotTitle.CONFIGURED);

    protected PlotTitleFlag(PlotTitle value) {
        super(value, TranslatableCaption.of("flags.flag_category_string"), TranslatableCaption.of("flags.flag_description_title"));
    }

    @Override
    public PlotTitleFlag parse(@NonNull String input) throws FlagParseException {
        PlotTitle value;
        if (input.equals("CONFIGURED")) {
            return TITLE_FLAG_DEFAULT;
        }
        if (!input.contains("\"")) {
            return new PlotTitleFlag(new PlotTitle(input, ""));
        }
        input = input.substring(input.indexOf("\""));
        String[] inputs = (input = input.substring(0, input.lastIndexOf("\"") + 1)).split("\"");
        if (inputs.length == 2) {
            value = new PlotTitle(inputs[1], "");
        } else if (inputs.length > 3) {
            value = new PlotTitle(inputs[1], inputs[3]);
        } else {
            throw new FlagParseException(this, input, TranslatableCaption.of("flags.flag_error_title"), new Template[0]);
        }
        return new PlotTitleFlag(value);
    }

    @Override
    public PlotTitleFlag merge(@NonNull PlotTitle newValue) {
        if (((PlotTitle)this.getValue()).title().isEmpty() && ((PlotTitle)this.getValue()).subtitle().isEmpty()) {
            return new PlotTitleFlag(newValue);
        }
        if (((PlotTitle)this.getValue()).subtitle().isEmpty()) {
            return new PlotTitleFlag(new PlotTitle(((PlotTitle)this.getValue()).title(), newValue.subtitle()));
        }
        if (((PlotTitle)this.getValue()).title().isEmpty()) {
            return new PlotTitleFlag(new PlotTitle(newValue.title(), ((PlotTitle)this.getValue()).subtitle()));
        }
        return this;
    }

    @Override
    public String toString() {
        if (this.getValue() == PlotTitle.CONFIGURED) {
            return "CONFIGURED";
        }
        return "\"" + ((PlotTitle)this.getValue()).title() + "\" \"" + ((PlotTitle)this.getValue()).subtitle() + "\"";
    }

    @Override
    public boolean isValuedPermission() {
        return false;
    }

    @Override
    public String getExample() {
        return "\"A Title\" \"The subtitle\"";
    }

    @Override
    protected PlotTitleFlag flagOf(@NonNull PlotTitle value) {
        return new PlotTitleFlag(value);
    }
}

