/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.caption.load;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.plotsquared.core.configuration.caption.CaptionMap;
import com.plotsquared.core.configuration.caption.LocalizedCaptionMap;
import com.plotsquared.core.configuration.caption.PerUserLocaleCaptionMap;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.caption.load.DefaultCaptionProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CaptionLoader {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + CaptionLoader.class.getSimpleName()));
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> defaultMessages;
    private final Locale defaultLocale;
    private final Function<Path, Locale> localeExtractor;
    private final DefaultCaptionProvider captionProvider;
    private final String namespace;

    private CaptionLoader(@NonNull Locale internalLocale, @NonNull Function<@NonNull Path, @NonNull Locale> localeExtractor, @NonNull DefaultCaptionProvider captionProvider, @NonNull String namespace) {
        Map<String, String> temp;
        this.defaultLocale = internalLocale;
        this.localeExtractor = localeExtractor;
        this.captionProvider = captionProvider;
        this.namespace = namespace;
        try {
            temp = this.captionProvider.loadDefaults(internalLocale);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load default messages", (Throwable)e);
            temp = Collections.emptyMap();
        }
        this.defaultMessages = temp;
    }

    public static @NonNull CaptionLoader of(@NonNull Locale internalLocale, @NonNull Function<@NonNull Path, @NonNull Locale> localeExtractor, @NonNull DefaultCaptionProvider captionProvider, @NonNull String namespace) {
        return new CaptionLoader(internalLocale, localeExtractor, captionProvider, namespace);
    }

    public static @NonNull Function<@NonNull Path, @NonNull Locale> patternExtractor(@NonNull Pattern pattern) {
        return path -> {
            String fileName = path.getFileName().toString();
            Matcher matcher = pattern.matcher(fileName);
            if (matcher.matches()) {
                return Locale.forLanguageTag(matcher.group(1));
            }
            throw new IllegalArgumentException(fileName + " is an invalid message file (cannot extract locale)");
        };
    }

    static @NonNull Map<@NonNull String, @NonNull String> loadFromReader(@NonNull Reader reader) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        return new LinkedHashMap<String, String>((Map)GSON.fromJson(reader, type));
    }

    private static void save(Path file, Map<String, String> content) {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson(content, (Appendable)writer);
            LOGGER.info("Saved {} with new content", (Object)file.getFileName());
        }
        catch (IOException e) {
            LOGGER.error("Failed to save caption file '{}'", (Object)file.getFileName().toString(), (Object)e);
        }
    }

    public @NonNull CaptionMap loadAll(@NonNull Path directory) throws IOException {
        HashMap<Locale, CaptionMap> localeMaps = new HashMap<Locale, CaptionMap>();
        try (Stream<Path> files = Files.list(directory);){
            List captionFiles = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
            for (Path file : captionFiles) {
                try {
                    CaptionMap localeMap = this.loadSingle(file);
                    localeMaps.put(localeMap.getLocale(), localeMap);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load language file '{}'", (Object)file.getFileName().toString(), (Object)e);
                }
            }
            LOGGER.info("Loaded {} message files. Loaded Languages: {}", (Object)localeMaps.size(), localeMaps.keySet());
            PerUserLocaleCaptionMap perUserLocaleCaptionMap = new PerUserLocaleCaptionMap(localeMaps);
            return perUserLocaleCaptionMap;
        }
    }

    public @NonNull CaptionMap loadSingle(@NonNull Path file) throws IOException {
        Locale locale = this.localeExtractor.apply(file);
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            Map<String, String> map = CaptionLoader.loadFromReader(reader);
            if (this.patch(map, locale)) {
                CaptionLoader.save(file, map);
            }
            LocalizedCaptionMap localizedCaptionMap = new LocalizedCaptionMap(locale, map.entrySet().stream().collect(Collectors.toMap(entry -> TranslatableCaption.of(this.namespace, (String)entry.getKey()), Map.Entry::getValue)));
            return localizedCaptionMap;
        }
    }

    private boolean patch(Map<String, String> map, Locale locale) {
        Map<String, String> languageSpecific;
        boolean modified = false;
        if (locale.equals(this.defaultLocale)) {
            languageSpecific = this.defaultMessages;
        } else {
            languageSpecific = this.captionProvider.loadDefaults(locale);
            if (languageSpecific == null) {
                languageSpecific = this.defaultMessages;
            }
        }
        for (Map.Entry<String, String> entry : this.defaultMessages.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            String value = languageSpecific.getOrDefault(entry.getKey(), entry.getValue());
            map.put(entry.getKey(), value);
            modified = true;
        }
        return modified;
    }
}

