/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.sk89q.jnbt.CompoundTag;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@Deprecated(forRemoval=true)
@CommandDeclaration(command="save", category=CommandCategory.SCHEMATIC, requiredType=RequiredType.NONE, permission="plots.save")
public class Save
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final SchematicHandler schematicHandler;

    @Inject
    public Save(@NonNull PlotAreaManager plotAreaManager, @NonNull SchematicHandler schematicHandler) {
        this.plotAreaManager = plotAreaManager;
        this.schematicHandler = schematicHandler;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> player, String[] args) {
        String world = player.getLocation().getWorldName();
        if (!this.plotAreaManager.hasPlotArea(world)) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
            return false;
        }
        final Plot plot = player.getCurrentPlot();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("info.plot_unowned"), new Template[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new Template[0]);
            return false;
        }
        if (!plot.isOwner(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_COMMAND_SAVE)) {
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
            return false;
        }
        if (plot.getRunning() > 0) {
            player.sendMessage(TranslatableCaption.of("errors.wait_for_timer"), new Template[0]);
            return false;
        }
        plot.addRunning();
        this.schematicHandler.getCompoundTag(plot).whenComplete((compoundTag, throwable) -> TaskManager.runTaskAsync(() -> {
            String time = "" + System.currentTimeMillis() / 1000L;
            Location[] corners = plot.getCorners();
            corners[0] = corners[0].withY(0);
            corners[1] = corners[1].withY(255);
            int size = corners[1].getX() - corners[0].getX() + 1;
            PlotId id = plot.getId();
            String world1 = plot.getArea().toString().replaceAll(";", "-").replaceAll("[^A-Za-z0-9]", "");
            final String file = time + "_" + world1 + "_" + id.getX() + "_" + id.getY() + "_" + size;
            UUID uuid = player.getUUID();
            this.schematicHandler.upload((CompoundTag)compoundTag, uuid, file, new RunnableVal<URL>(){

                @Override
                public void run(URL url) {
                    plot.removeRunning();
                    if (url == null) {
                        player.sendMessage(TranslatableCaption.of("backups.backup_save_failed"), new Template[0]);
                        return;
                    }
                    player.sendMessage(TranslatableCaption.of("web.save_success"), new Template[0]);
                    player.sendMessage(TranslatableCaption.of("errors.deprecated_commands"), Template.of((String)"replacement", (String)"/plot download"));
                    try (MetaDataAccess<List<String>> schematicAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SCHEMATICS);){
                        schematicAccess.get().ifPresent(schematics -> schematics.add(file + ".schem"));
                    }
                }
            });
        }));
        return true;
    }
}

