/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.common.primitives.Ints;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.core.uuid.UUIDMapping;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.Template;

@CommandDeclaration(command="grant", category=CommandCategory.CLAIMING, usage="/plot grant <check | add> [player]", permission="plots.grant", requiredType=RequiredType.NONE)
public class Grant
extends Command {
    public Grant() {
        super(MainCommand.getInstance(), true);
    }

    @Override
    public CompletableFuture<Boolean> execute(final PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) throws Command.CommandException {
        String arg0;
        this.checkTrue(args.length >= 1 && args.length <= 2, TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot grant <check | add> [player]"));
        switch (arg0 = args[0].toLowerCase()) {
            case "add": 
            case "check": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_GRANT.format(arg0))) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)Permission.PERMISSION_GRANT.format(arg0)));
                    return CompletableFuture.completedFuture(false);
                }
                if (args.length != 2) break;
                PlayerManager.getUUIDsFromString(args[1], (uuids, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new Template[0]);
                    } else if (throwable != null || uuids.size() != 1) {
                        player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.of((String)"value", (String)String.valueOf(uuids)));
                    } else {
                        final UUIDMapping uuid = uuids.toArray(new UUIDMapping[0])[0];
                        PlotPlayer<?> pp = PlotSquared.platform().playerManager().getPlayerIfExists(uuid.getUuid());
                        if (pp != null) {
                            try (MetaDataAccess<Integer> access = pp.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_GRANTED_PLOTS);){
                                if (args[0].equalsIgnoreCase("check")) {
                                    player.sendMessage(TranslatableCaption.of("grants.granted_plots"), Template.of((String)"amount", (String)String.valueOf(access.get().orElse(0))));
                                }
                                access.set(access.get().orElse(0) + 1);
                            }
                        } else {
                            DBFunc.getPersistentMeta(uuid.getUuid(), new RunnableVal<Map<String, byte[]>>(){

                                @Override
                                public void run(Map<String, byte[]> value) {
                                    byte[] array = value.get("grantedPlots");
                                    if (arg0.equals("check")) {
                                        int granted = array == null ? 0 : Ints.fromByteArray((byte[])array);
                                        player.sendMessage(TranslatableCaption.of("grants.granted_plots"), Template.of((String)"amount", (String)String.valueOf(granted)));
                                    } else {
                                        int amount = array == null ? 1 : 1 + Ints.fromByteArray((byte[])array);
                                        boolean replace = array != null;
                                        String key = "grantedPlots";
                                        byte[] rawData = Ints.toByteArray((int)amount);
                                        DBFunc.addPersistentMeta(uuid.getUuid(), key, rawData, replace);
                                        player.sendMessage(TranslatableCaption.of("grants.added"), Template.of((String)"grants", (String)String.valueOf(amount)));
                                    }
                                }
                            });
                        }
                    }
                });
                return CompletableFuture.completedFuture(true);
            }
        }
        this.sendUsage(player);
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        if (args.length == 1) {
            LinkedList<String> completions = new LinkedList<String>();
            if (Permissions.hasPermission(player, Permission.PERMISSION_GRANT_ADD)) {
                completions.add("add");
            }
            if (Permissions.hasPermission(player, Permission.PERMISSION_GRANT_CHECK)) {
                completions.add("check");
            }
            List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.NONE, CommandCategory.ADMINISTRATION){}).collect(Collectors.toCollection(LinkedList::new));
            if (Permissions.hasPermission(player, Permission.PERMISSION_GRANT_SINGLE) && args[0].length() > 0) {
                commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
            }
            return commands;
        }
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }
}

