/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.common.base.Charsets;
import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="debugimportworlds", permission="plots.admin", requiredType=RequiredType.CONSOLE, category=CommandCategory.TELEPORT)
public class DebugImportWorlds
extends Command {
    private final PlotAreaManager plotAreaManager;
    private final WorldUtil worldUtil;

    @Inject
    public DebugImportWorlds(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldUtil worldUtil) {
        super(MainCommand.getInstance(), true);
        this.plotAreaManager = plotAreaManager;
        this.worldUtil = worldUtil;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) throws Command.CommandException {
        if (!(this.plotAreaManager instanceof SinglePlotAreaManager)) {
            player.sendMessage(TranslatableCaption.of("debugimportworlds.single_plot_area"), new Template[0]);
            return CompletableFuture.completedFuture(false);
        }
        SinglePlotArea area = ((SinglePlotAreaManager)this.plotAreaManager).getArea();
        PlotId id = PlotId.of(0, 0);
        File container = PlotSquared.platform().worldContainer();
        if (container.equals(new File("."))) {
            player.sendMessage(TranslatableCaption.of("debugimportworlds.world_container"), new Template[0]);
            return CompletableFuture.completedFuture(false);
        }
        for (File folder : container.listFiles()) {
            UUID uuid;
            String name = folder.getName();
            if (this.worldUtil.isWorld(name) || PlotId.fromStringOrNull(name) != null) continue;
            if (name.length() > 16) {
                uuid = UUID.fromString(name);
            } else {
                player.sendMessage(TranslatableCaption.of("players.fetching_player"), new Template[0]);
                uuid = PlotSquared.get().getImpromptuUUIDPipeline().getSingle(name, 60000L);
            }
            if (uuid == null) {
                uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8));
            }
            while (new File(container, id.toCommaSeparatedString()).exists()) {
                id = id.getNextId();
            }
            File newDir = new File(container, id.toCommaSeparatedString());
            if (!folder.renameTo(newDir)) continue;
            area.getPlot(id).setOwner(uuid);
        }
        player.sendMessage(TranslatableCaption.of("players.done"), new Template[0]);
        return CompletableFuture.completedFuture(true);
    }
}

