/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.uuid.UUIDMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.Template;
import net.kyori.adventure.text.minimessage.template.TemplateResolver;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PlayerManager<P extends PlotPlayer<? extends T>, T> {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private final Map<UUID, P> playerMap = new HashMap<UUID, P>();
    private final Object playerLock = new Object();

    public static void getUUIDsFromString(@NonNull String list, @NonNull BiConsumer<Collection<UUID>, Throwable> consumer) {
        String[] split = list.split(",");
        HashSet<UUID> result = new HashSet<UUID>();
        LinkedList<String> request = new LinkedList<String>();
        for (String name : split) {
            if (name.isEmpty()) {
                consumer.accept(Collections.emptySet(), null);
                return;
            }
            if ("*".equals(name)) {
                result.add(DBFunc.EVERYONE);
                continue;
            }
            if (name.length() > 16) {
                try {
                    result.add(UUID.fromString(name));
                    continue;
                }
                catch (IllegalArgumentException ignored) {
                    consumer.accept(Collections.emptySet(), null);
                    return;
                }
            }
            request.add(name);
        }
        if (request.isEmpty()) {
            consumer.accept(result, null);
        } else {
            PlotSquared.get().getImpromptuUUIDPipeline().getUUIDs(request, Settings.UUID.NON_BLOCKING_TIMEOUT).whenComplete((uuids, throwable) -> {
                if (throwable != null) {
                    consumer.accept((Collection<UUID>)null, (Throwable)throwable);
                } else {
                    for (UUIDMapping uuid : uuids) {
                        result.add(uuid.getUuid());
                    }
                    consumer.accept(result, null);
                }
            });
        }
    }

    public static @NonNull Component getPlayerList(@NonNull Collection<UUID> uuids, LocaleHolder localeHolder) {
        if (uuids.isEmpty()) {
            return MINI_MESSAGE.parse(TranslatableCaption.of("info.none").getComponent(localeHolder));
        }
        LinkedList<UUID> players = new LinkedList<UUID>();
        LinkedList<String> users = new LinkedList<String>();
        for (UUID uuid : uuids) {
            if (uuid == null) {
                users.add(MINI_MESSAGE.stripTokens(TranslatableCaption.of("info.none").getComponent(localeHolder)));
                continue;
            }
            if (DBFunc.EVERYONE.equals(uuid)) {
                users.add(MINI_MESSAGE.stripTokens(TranslatableCaption.of("info.everyone").getComponent(localeHolder)));
                continue;
            }
            if (DBFunc.SERVER.equals(uuid)) {
                users.add(MINI_MESSAGE.stripTokens(TranslatableCaption.of("info.console").getComponent(localeHolder)));
                continue;
            }
            players.add(uuid);
        }
        try {
            for (UUIDMapping mapping : PlotSquared.get().getImpromptuUUIDPipeline().getNames(players).get(Settings.UUID.BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS)) {
                users.add(mapping.getUsername());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String c = TranslatableCaption.of("info.plot_user_list").getComponent(ConsolePlayer.getConsole());
        TextComponent.Builder list = Component.text();
        for (int x = 0; x < users.size(); ++x) {
            if (x + 1 == uuids.size()) {
                list.append(MINI_MESSAGE.deserialize(c, TemplateResolver.templates((Template[])new Template[]{Template.template((String)"user", (String)((String)users.get(x)))})));
                continue;
            }
            list.append(MINI_MESSAGE.deserialize(c + ", ", TemplateResolver.templates((Template[])new Template[]{Template.template((String)"user", (String)((String)users.get(x)))})));
        }
        return list.asComponent();
    }

    public static @NonNull String getName(@Nullable UUID owner) {
        return PlayerManager.getName(owner, true);
    }

    public static @NonNull String getName(@Nullable UUID owner, boolean blocking) {
        UUIDMapping uuidMapping;
        String name;
        if (owner == null) {
            TranslatableCaption.of("info.none");
        }
        if (owner.equals(DBFunc.EVERYONE)) {
            TranslatableCaption.of("info.everyone");
        }
        if (owner.equals(DBFunc.SERVER)) {
            TranslatableCaption.of("info.server");
        }
        if ((name = blocking ? PlotSquared.get().getImpromptuUUIDPipeline().getSingle(owner, Settings.UUID.BLOCKING_TIMEOUT) : ((uuidMapping = PlotSquared.get().getImpromptuUUIDPipeline().getImmediately(owner)) != null ? uuidMapping.getUsername() : null)) == null) {
            TranslatableCaption.of("info.unknown");
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(@NonNull PlotPlayer<?> plotPlayer) {
        Object object = this.playerLock;
        synchronized (object) {
            this.playerMap.remove(plotPlayer.getUUID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(@NonNull UUID uuid) {
        Object object = this.playerLock;
        synchronized (object) {
            this.playerMap.remove(uuid);
        }
    }

    public @Nullable P getPlayerIfExists(@Nullable UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return (P)((PlotPlayer)this.playerMap.get(uuid));
    }

    public @Nullable P getPlayerIfExists(@Nullable String name) {
        for (PlotPlayer plotPlayer : this.playerMap.values()) {
            if (!plotPlayer.getName().equalsIgnoreCase(name)) continue;
            return (P)plotPlayer;
        }
        return null;
    }

    public abstract @NonNull P getPlayer(@NonNull T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull P getPlayer(@NonNull UUID uuid) {
        Object object = this.playerLock;
        synchronized (object) {
            PlotPlayer player = (PlotPlayer)this.playerMap.get(uuid);
            if (player == null) {
                player = this.createPlayer(uuid);
                this.playerMap.put(uuid, player);
            }
            return (P)player;
        }
    }

    public abstract @NonNull P createPlayer(@NonNull UUID var1);

    public abstract @Nullable OfflinePlotPlayer getOfflinePlayer(@Nullable UUID var1);

    public abstract @Nullable OfflinePlotPlayer getOfflinePlayer(@NonNull String var1);

    public Collection<P> getPlayers() {
        return Collections.unmodifiableCollection(new ArrayList<P>(this.playerMap.values()));
    }

    public static final class NoSuchPlayerException
    extends IllegalArgumentException {
        public NoSuchPlayerException(@NonNull UUID uuid) {
            super(String.format("There is no online player with UUID '%s'", uuid));
        }
    }
}

