/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.player.PlotPlayer;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Permissions {
    public static boolean hasPermission(PlotPlayer<?> player, Permission permission, boolean notify) {
        return Permissions.hasPermission(player, permission.toString(), notify);
    }

    public static boolean hasPermission(@NonNull PermissionHolder caller, @NonNull Permission permission) {
        return caller.hasPermission(permission.toString());
    }

    public static boolean hasPermission(@NonNull PermissionHolder caller, @NonNull String permission) {
        return caller.hasPermission(permission);
    }

    public static boolean hasKeyedPermission(@NonNull PermissionHolder caller, @NonNull String permission, @NonNull String key) {
        return caller.hasKeyedPermission(permission, key);
    }

    public static boolean hasPermission(PlotPlayer<?> player, String permission, boolean notify) {
        if (!Permissions.hasPermission(player, permission)) {
            if (notify) {
                player.sendMessage(TranslatableCaption.of("permission.no_permission_event"), Template.template((String)"node", (String)permission));
            }
            return false;
        }
        return true;
    }

    public static int hasPermissionRange(PlotPlayer<?> player, Permission Permission2, int range) {
        return Permissions.hasPermissionRange(player, Permission2.toString(), range);
    }

    public static int hasPermissionRange(PlotPlayer<?> player, String stub, int range) {
        return player.hasPermissionRange(stub, range);
    }
}

