/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.queue.LightingMode;
import com.plotsquared.core.queue.LocalChunk;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.queue.subscriber.ProgressSubscriber;
import com.plotsquared.core.util.PatternUtil;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BasicQueueCoordinator
extends QueueCoordinator {
    private final World world;
    private final ConcurrentHashMap<BlockVector2, LocalChunk> blockChunks = new ConcurrentHashMap();
    private final List<BlockVector2> readRegion = new ArrayList<BlockVector2>();
    private final List<ProgressSubscriber> progressSubscribers = new ArrayList<ProgressSubscriber>();
    private long modified;
    private LocalChunk lastWrappedChunk;
    private int lastX = Integer.MIN_VALUE;
    private int lastZ = Integer.MIN_VALUE;
    private boolean settingBiomes = false;
    private boolean settingTiles = false;
    private boolean regen = false;
    private int[] regenStart;
    private int[] regenEnd;
    private CuboidRegion regenRegion = null;
    private Consumer<BlockVector2> consumer = null;
    private boolean unloadAfter = true;
    private Runnable whenDone;
    private @Nullable LightingMode lightingMode = LightingMode.valueOf(Settings.QUEUE.LIGHTING_MODE);

    public BasicQueueCoordinator(@NonNull World world) {
        super(world);
        this.world = world;
        this.modified = System.currentTimeMillis();
    }

    @Override
    public abstract BlockState getBlock(int var1, int var2, int var3);

    @Override
    public final @NonNull World getWorld() {
        return this.world;
    }

    @Override
    public final int size() {
        return this.blockChunks.size() + this.readRegion.size();
    }

    @Override
    public final void setModified(long modified) {
        this.modified = modified;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull Pattern pattern) {
        return this.setBlock(x, y, z, PatternUtil.apply(pattern, x, y, z));
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BaseBlock id) {
        if (y > 255 || y < 0) {
            return false;
        }
        LocalChunk chunk = this.getChunk(x >> 4, z >> 4);
        chunk.setBlock(x & 0xF, y, z & 0xF, id);
        return true;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BlockState id) {
        return this.setBlock(x, y, z, id.toBaseBlock());
    }

    @Override
    public boolean setBiome(int x, int z, @NonNull BiomeType biomeType) {
        LocalChunk chunk = this.getChunk(x >> 4, z >> 4);
        for (int y = 0; y < 256; ++y) {
            chunk.setBiome(x & 0xF, y, z & 0xF, biomeType);
        }
        this.settingBiomes = true;
        return true;
    }

    @Override
    public final boolean setBiome(int x, int y, int z, @NonNull BiomeType biomeType) {
        LocalChunk chunk = this.getChunk(x >> 4, z >> 4);
        chunk.setBiome(x & 0xF, y, z & 0xF, biomeType);
        this.settingBiomes = true;
        return true;
    }

    @Override
    public boolean isSettingBiomes() {
        return this.settingBiomes;
    }

    @Override
    public boolean setTile(int x, int y, int z, @NonNull CompoundTag tag) {
        LocalChunk chunk = this.getChunk(x >> 4, z >> 4);
        chunk.setTile(x, y, z, tag);
        this.settingTiles = true;
        return true;
    }

    @Override
    public boolean isSettingTiles() {
        return this.settingTiles;
    }

    @Override
    public boolean setEntity(@NonNull Entity entity) {
        if (entity.getState() == null || entity.getState().getType() == EntityTypes.PLAYER) {
            return false;
        }
        Location location = entity.getLocation();
        LocalChunk chunk = this.getChunk(location.getBlockX() >> 4, location.getBlockZ() >> 4);
        chunk.setEntity(location, entity.getState());
        return true;
    }

    @Override
    public @NonNull List<BlockVector2> getReadChunks() {
        return this.readRegion;
    }

    @Override
    public void addReadChunk(@NonNull BlockVector2 chunk) {
        this.readRegion.add(chunk);
    }

    @Override
    public void addReadChunks(@NonNull Set<BlockVector2> readRegion) {
        this.readRegion.addAll(readRegion);
    }

    @Override
    public CuboidRegion getRegenRegion() {
        return this.regenRegion != null ? this.regenRegion.clone() : null;
    }

    @Override
    public void setRegenRegion(@NonNull CuboidRegion regenRegion) {
        this.regenRegion = regenRegion;
    }

    @Override
    public void regenChunk(int x, int z) {
        this.regen = true;
        if (this.regenStart == null) {
            this.regenStart = new int[]{x, z};
            this.regenEnd = new int[]{x, z};
            return;
        }
        if (x < this.regenStart[0]) {
            this.regenStart[0] = x;
        }
        if (z < this.regenStart[1]) {
            this.regenStart[1] = z;
        }
        if (x > this.regenEnd[0]) {
            this.regenEnd[0] = x;
        }
        if (z > this.regenEnd[1]) {
            this.regenEnd[1] = z;
        }
    }

    @Override
    public boolean isUnloadAfter() {
        return this.unloadAfter;
    }

    @Override
    public void setUnloadAfter(boolean unloadAfter) {
        this.unloadAfter = unloadAfter;
    }

    public int[] getRegenStart() {
        return this.regenStart;
    }

    public int[] getRegenEnd() {
        return this.regenEnd;
    }

    public boolean isRegen() {
        return this.regen;
    }

    public @NonNull ConcurrentHashMap<BlockVector2, LocalChunk> getBlockChunks() {
        return this.blockChunks;
    }

    public final void setChunk(@NonNull LocalChunk chunk) {
        this.blockChunks.put(BlockVector2.at((int)chunk.getX(), (int)chunk.getZ()), chunk);
    }

    @Override
    public final @Nullable Consumer<BlockVector2> getChunkConsumer() {
        return this.consumer;
    }

    @Override
    public final void setChunkConsumer(@NonNull Consumer<BlockVector2> consumer) {
        this.consumer = consumer;
    }

    public final List<ProgressSubscriber> getProgressSubscribers() {
        return this.progressSubscribers;
    }

    @Override
    public final void addProgressSubscriber(@NonNull ProgressSubscriber progressSubscriber) {
        this.progressSubscribers.add(progressSubscriber);
    }

    @Override
    public final @NonNull LightingMode getLightingMode() {
        if (this.lightingMode == null) {
            return LightingMode.valueOf(Settings.QUEUE.LIGHTING_MODE);
        }
        return this.lightingMode;
    }

    @Override
    public final void setLightingMode(@Nullable LightingMode mode) {
        this.lightingMode = mode;
    }

    @Override
    public Runnable getCompleteTask() {
        return this.whenDone;
    }

    @Override
    public void setCompleteTask(Runnable whenDone) {
        this.whenDone = whenDone;
    }

    private @NonNull LocalChunk getChunk(int chunkX, int chunkZ) {
        if (chunkX != this.lastX || chunkZ != this.lastZ) {
            this.lastX = chunkX;
            this.lastZ = chunkZ;
            BlockVector2 pair = BlockVector2.at((int)chunkX, (int)chunkZ);
            this.lastWrappedChunk = this.blockChunks.get(pair);
            if (this.lastWrappedChunk == null) {
                this.lastWrappedChunk = new LocalChunk(this, chunkX, chunkZ);
                LocalChunk previous = this.blockChunks.put(pair, this.lastWrappedChunk);
                if (previous == null) {
                    return this.lastWrappedChunk;
                }
                this.lastWrappedChunk = previous;
            }
        }
        return this.lastWrappedChunk;
    }
}

