/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.expiration;

import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.expiration.ExpireManager;
import com.plotsquared.core.plot.expiration.PlotAnalysis;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.query.PlotQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpiryTask {
    private final Settings.Auto_Clear settings;
    private final PlotAreaManager plotAreaManager;
    private long cutoffThreshold = Long.MIN_VALUE;

    public ExpiryTask(Settings.Auto_Clear settings, @NonNull PlotAreaManager plotAreaManager) {
        this.settings = settings;
        this.plotAreaManager = plotAreaManager;
    }

    public Settings.Auto_Clear getSettings() {
        return this.settings;
    }

    public boolean allowsArea(PlotArea area) {
        return this.settings.WORLDS.contains(area.toString()) || this.settings.WORLDS.contains(area.getWorldName()) || this.settings.WORLDS.contains("*");
    }

    public boolean applies(PlotArea area) {
        if (this.allowsArea(area)) {
            if (this.settings.REQUIRED_PLOTS <= 0) {
                return true;
            }
            Set<Plot> plots = null;
            if (this.cutoffThreshold != Long.MAX_VALUE && area.getPlots().size() > this.settings.REQUIRED_PLOTS || (plots = this.getPlotsToCheck()).size() > this.settings.REQUIRED_PLOTS) {
                if (this.cutoffThreshold == Long.MIN_VALUE) {
                    plots = plots != null ? plots : this.getPlotsToCheck();
                    int diff = this.settings.REQUIRED_PLOTS;
                    boolean min = true;
                    if (this.settings.REQUIRED_PLOTS - plots.size() < this.settings.REQUIRED_PLOTS) {
                        min = false;
                        diff = this.settings.REQUIRED_PLOTS - plots.size();
                    }
                    List entireList = plots.stream().map(plot -> ExpireManager.IMP.getAge((Plot)plot)).collect(Collectors.toList());
                    ArrayList<Long> top = new ArrayList<Long>(diff + 1);
                    if (diff > 1000) {
                        Collections.sort(entireList);
                        this.cutoffThreshold = (Long)entireList.get(this.settings.REQUIRED_PLOTS);
                    } else {
                        Iterator iterator = entireList.iterator();
                        block0: while (iterator.hasNext()) {
                            long num = (Long)iterator.next();
                            int size = top.size();
                            if (size == 0) {
                                top.add(num);
                                continue;
                            }
                            long end = (Long)top.get(size - 1);
                            if (min ? num < end : num > end) {
                                for (int i = 0; i < size; ++i) {
                                    long existing = (Long)top.get(i);
                                    if (!(min ? num < existing : num > existing)) continue;
                                    top.add(i, num);
                                    if (size != diff) continue block0;
                                    top.remove(size);
                                    continue block0;
                                }
                            }
                            if (size >= diff) continue;
                            top.add(num);
                        }
                        this.cutoffThreshold = (Long)top.get(top.size() - 1);
                    }
                    this.cutoffThreshold += TimeUnit.DAYS.toMillis(1L) / 2L;
                }
                return true;
            }
            this.cutoffThreshold = Long.MAX_VALUE;
        }
        return false;
    }

    public Set<Plot> getPlotsToCheck() {
        LinkedList<PlotArea> areas = new LinkedList<PlotArea>();
        for (PlotArea plotArea : this.plotAreaManager.getAllPlotAreas()) {
            if (!this.allowsArea(plotArea)) continue;
            areas.add(plotArea);
        }
        return PlotQuery.newQuery().inAreas(areas).asSet();
    }

    public boolean applies(long diff) {
        return diff > TimeUnit.DAYS.toMillis(this.settings.DAYS) && diff > this.cutoffThreshold;
    }

    public boolean appliesAccountAge(long accountAge) {
        if (this.settings.SKIP_ACCOUNT_AGE_DAYS != -1) {
            return accountAge <= TimeUnit.DAYS.toMillis(this.settings.SKIP_ACCOUNT_AGE_DAYS);
        }
        return false;
    }

    public boolean needsAnalysis() {
        return this.settings.THRESHOLD > 0;
    }

    public boolean applies(PlotAnalysis analysis) {
        return analysis.getComplexity(this.settings) <= this.settings.THRESHOLD;
    }

    public boolean requiresConfirmation() {
        return this.settings.CONFIRMATION;
    }
}

