/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.Collection;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PlotWorld {
    private final String world;

    protected PlotWorld(@NonNull String world) {
        this.world = world;
    }

    public abstract @Nullable PlotArea getArea(@NonNull Location var1);

    public abstract @NonNull Collection<PlotArea> getAreas();

    public abstract @NonNull Collection<PlotArea> getAreasInRegion(@NonNull CuboidRegion var1);

    public void addArea(@NonNull PlotArea area) {
        throw new UnsupportedOperationException("This world type does not allow adding new areas");
    }

    public void removeArea(@NonNull PlotArea area) {
        throw new UnsupportedOperationException("This world type does not allow removing areas");
    }

    public String getWorld() {
        return this.world;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        Object object = o;
        if (!(object instanceof PlotWorld)) {
            return false;
        }
        PlotWorld other = (PlotWorld)object;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$world = this.getWorld();
        String other$world = other.getWorld();
        return Objects.equals(this$world, other$world);
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlotWorld;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        return result;
    }
}

