/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.listener;

import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.listener.WEExtent;
import com.plotsquared.core.util.WEManager;
import com.plotsquared.core.util.WorldUtil;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.NullExtent;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ProcessedWEExtent
extends AbstractDelegateExtent {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + ProcessedWEExtent.class.getSimpleName()));
    private final Set<CuboidRegion> mask;
    private final String world;
    private final int max;
    private final WorldUtil worldUtil;
    private final Map<Long, Integer[]> tileEntityCount = new HashMap<Long, Integer[]>();
    int Ecount = 0;
    boolean Eblocked = false;
    private int count;
    private Extent parent;

    public ProcessedWEExtent(String world, Set<CuboidRegion> mask, int max, Extent child, Extent parent, @NonNull WorldUtil worldUtil) {
        super(child);
        this.mask = mask;
        this.world = world;
        this.worldUtil = worldUtil;
        if (max == -1) {
            max = Integer.MAX_VALUE;
        }
        this.max = max;
        this.count = 0;
        this.parent = parent;
    }

    private static long getChunkKey(BlockVector3 location) {
        return (long)(location.getBlockX() >> 4) & 0xFFFFFFFFL | ((long)(location.getBlockZ() >> 4) & 0xFFFFFFFFL) << 32;
    }

    public BlockState getBlock(BlockVector3 position) {
        if (WEManager.maskContains(this.mask, position.getX(), position.getY(), position.getZ())) {
            return super.getBlock(position);
        }
        return WEExtent.AIRSTATE;
    }

    public BaseBlock getFullBlock(BlockVector3 position) {
        if (WEManager.maskContains(this.mask, position.getX(), position.getY(), position.getZ())) {
            return super.getFullBlock(position);
        }
        return WEExtent.AIRBASE;
    }

    public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 location, T block) throws WorldEditException {
        boolean isTile = this.worldUtil.getTileEntityTypes().contains(block.getBlockType());
        if (isTile) {
            Integer[] tileEntityCount = this.tileEntityCount.computeIfAbsent(ProcessedWEExtent.getChunkKey(location), key -> new Integer[]{this.worldUtil.getTileEntityCount(this.world, BlockVector2.at((int)(location.getBlockX() >> 4), (int)(location.getBlockZ() >> 4)))});
            if (tileEntityCount[0] >= Settings.Chunk_Processor.MAX_TILES) {
                return false;
            }
            Integer n = tileEntityCount[0];
            tileEntityCount[0] = tileEntityCount[0] + 1;
        }
        if (WEManager.maskContains(this.mask, location.getX(), location.getY(), location.getZ())) {
            if (this.count++ > this.max) {
                if (this.parent != null) {
                    try {
                        Field field = AbstractDelegateExtent.class.getDeclaredField("extent");
                        field.setAccessible(true);
                        field.set(this.parent, new NullExtent());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.parent = null;
                }
                return false;
            }
            return super.setBlock(location, block);
        }
        return !isTile;
    }

    public Entity createEntity(Location location, BaseEntity entity) {
        if (this.Eblocked) {
            return null;
        }
        ++this.Ecount;
        if (this.Ecount > Settings.Chunk_Processor.MAX_ENTITIES) {
            this.Eblocked = true;
        }
        if (WEManager.maskContains(this.mask, location.getBlockX(), location.getBlockY(), location.getBlockZ())) {
            return super.createEntity(location, entity);
        }
        return null;
    }

    public boolean setBiome(BlockVector2 position, BiomeType biome) {
        return WEManager.maskContains(this.mask, position.getX(), position.getZ()) && super.setBiome(position, biome);
    }
}

