/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.listener;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotTitle;
import com.plotsquared.core.plot.PlotWeather;
import com.plotsquared.core.plot.comment.CommentManager;
import com.plotsquared.core.plot.expiration.ExpireManager;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.implementations.DenyExitFlag;
import com.plotsquared.core.plot.flag.implementations.FarewellFlag;
import com.plotsquared.core.plot.flag.implementations.FeedFlag;
import com.plotsquared.core.plot.flag.implementations.FlyFlag;
import com.plotsquared.core.plot.flag.implementations.GamemodeFlag;
import com.plotsquared.core.plot.flag.implementations.GreetingFlag;
import com.plotsquared.core.plot.flag.implementations.GuestGamemodeFlag;
import com.plotsquared.core.plot.flag.implementations.HealFlag;
import com.plotsquared.core.plot.flag.implementations.MusicFlag;
import com.plotsquared.core.plot.flag.implementations.NotifyEnterFlag;
import com.plotsquared.core.plot.flag.implementations.NotifyLeaveFlag;
import com.plotsquared.core.plot.flag.implementations.PlotTitleFlag;
import com.plotsquared.core.plot.flag.implementations.ServerPlotFlag;
import com.plotsquared.core.plot.flag.implementations.TimeFlag;
import com.plotsquared.core.plot.flag.implementations.TitlesFlag;
import com.plotsquared.core.plot.flag.implementations.WeatherFlag;
import com.plotsquared.core.plot.flag.types.TimedFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlotListener {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private final HashMap<UUID, Interval> feedRunnable = new HashMap();
    private final HashMap<UUID, Interval> healRunnable = new HashMap();
    private final EventDispatcher eventDispatcher;

    public PlotListener(@Nullable EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public void startRunnable() {
        TaskManager.runTaskRepeat(() -> {
            PlotPlayer<?> player;
            Interval value;
            Map.Entry<UUID, Interval> entry;
            Iterator<Map.Entry<UUID, Interval>> iterator;
            if (!this.healRunnable.isEmpty()) {
                iterator = this.healRunnable.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    value = entry.getValue();
                    ++value.count;
                    if (value.count != value.interval) continue;
                    value.count = 0;
                    player = PlotSquared.platform().playerManager().getPlayerIfExists(entry.getKey());
                    if (player == null) {
                        iterator.remove();
                        continue;
                    }
                    double level = PlotSquared.platform().worldUtil().getHealth(player);
                    if (level == (double)value.max) continue;
                    PlotSquared.platform().worldUtil().setHealth(player, Math.min(level + (double)value.amount, (double)value.max));
                }
            }
            if (!this.feedRunnable.isEmpty()) {
                iterator = this.feedRunnable.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    value = entry.getValue();
                    ++value.count;
                    if (value.count != value.interval) continue;
                    value.count = 0;
                    player = PlotSquared.platform().playerManager().getPlayerIfExists(entry.getKey());
                    if (player == null) {
                        iterator.remove();
                        continue;
                    }
                    int level = PlotSquared.platform().worldUtil().getFoodLevel(player);
                    if (level == value.max) continue;
                    PlotSquared.platform().worldUtil().setFoodLevel(player, Math.min(level + value.amount, value.max));
                }
            }
        }, TaskTime.seconds(1L));
    }

    public boolean plotEntry(PlotPlayer<?> player, Plot plot) {
        if (plot.isDenied(player.getUUID()) && !Permissions.hasPermission(player, "plots.admin.entry.denied")) {
            player.sendMessage(TranslatableCaption.of("deny.no_enter"), Template.template((String)"plot", (String)plot.toString()));
            return false;
        }
        try (MetaDataAccess<Plot> lastPlot = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
            Plot last = lastPlot.get().orElse(null);
            if (last != null && !last.getId().equals(plot.getId())) {
                this.plotExit(player, last);
            }
            if (ExpireManager.IMP != null) {
                ExpireManager.IMP.handleEntry(player, plot);
            }
            lastPlot.set(plot);
        }
        this.eventDispatcher.callEntry(player, plot);
        if (plot.hasOwner()) {
            TimedFlag.Timed heal;
            TimedFlag.Timed feed;
            boolean titles;
            block55: {
                long time;
                GameMode guestGameMode;
                GameMode gameMode;
                TitlesFlag.TitlesFlagValue titlesFlag = (TitlesFlag.TitlesFlagValue)((Object)plot.getFlag(TitlesFlag.class));
                titles = titlesFlag == TitlesFlag.TitlesFlagValue.NONE ? Settings.Titles.DISPLAY_TITLES : titlesFlag == TitlesFlag.TitlesFlagValue.TRUE;
                String greeting = (String)plot.getFlag(GreetingFlag.class);
                if (!greeting.isEmpty()) {
                    if (!Settings.Chat.NOTIFICATION_AS_ACTIONBAR) {
                        player.sendMessage(TranslatableCaption.of("flags.greeting_flag_format"), Template.template((String)"world", (String)plot.getWorldName()), Template.template((String)"plot_id", (String)plot.getId().toString()), Template.template((String)"alias", (String)plot.getAlias()), Template.template((String)"greeting", (String)greeting));
                    } else {
                        player.sendActionBar(TranslatableCaption.of("flags.greeting_flag_format"), Template.template((String)"world", (String)plot.getWorldName()), Template.template((String)"plot_id", (String)plot.getId().toString()), Template.template((String)"alias", (String)plot.getAlias()), Template.template((String)"greeting", (String)greeting));
                    }
                }
                if (((Boolean)plot.getFlag(NotifyEnterFlag.class)).booleanValue() && !Permissions.hasPermission(player, "plots.flag.notify-enter.bypass")) {
                    for (UUID uuid : plot.getOwners()) {
                        PlotPlayer<?> owner = PlotSquared.platform().playerManager().getPlayerIfExists(uuid);
                        if (owner == null || owner.getUUID().equals(player.getUUID()) || !owner.canSee(player)) continue;
                        TranslatableCaption caption = TranslatableCaption.of("notification.notify_enter");
                        Template playerTemplate = Template.template((String)"player", (String)player.getName());
                        Template plotTemplate = Template.template((String)"plot", (String)plot.getId().toString());
                        if (!Settings.Chat.NOTIFICATION_AS_ACTIONBAR) {
                            owner.sendMessage(caption, playerTemplate, plotTemplate);
                            continue;
                        }
                        owner.sendActionBar(caption, playerTemplate, plotTemplate);
                    }
                }
                FlyFlag.FlyStatus flyStatus = (FlyFlag.FlyStatus)((Object)plot.getFlag(FlyFlag.class));
                if (!Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_FLIGHT) && flyStatus != FlyFlag.FlyStatus.DEFAULT) {
                    GameMode gamemode;
                    boolean flight = player.getFlight();
                    if (flight != ((gamemode = player.getGameMode()) == GameModes.CREATIVE || gamemode == GameModes.SPECTATOR)) {
                        try (MetaDataAccess<Boolean> metaDataAccess = player.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_FLIGHT);){
                            metaDataAccess.set(player.getFlight());
                        }
                    }
                    player.setFlight(flyStatus == FlyFlag.FlyStatus.ENABLED);
                }
                if (!(gameMode = (GameMode)plot.getFlag(GamemodeFlag.class)).equals((Object)GamemodeFlag.DEFAULT) && player.getGameMode() != gameMode) {
                    if (!Permissions.hasPermission(player, "plots.gamemode.bypass")) {
                        player.setGameMode(gameMode);
                    } else {
                        player.sendMessage(TranslatableCaption.of("gamemode.gamemode_was_bypassed"), Template.template((String)"gamemode", (String)String.valueOf(gameMode)), Template.template((String)"plot", (String)plot.getId().toString()));
                    }
                }
                if (!(guestGameMode = (GameMode)plot.getFlag(GuestGamemodeFlag.class)).equals((Object)GamemodeFlag.DEFAULT) && player.getGameMode() != guestGameMode && !plot.isAdded(player.getUUID())) {
                    if (!Permissions.hasPermission(player, "plots.gamemode.bypass")) {
                        player.setGameMode(guestGameMode);
                    } else {
                        player.sendMessage(TranslatableCaption.of("gamemode.gamemode_was_bypassed"), Template.template((String)"gamemode", (String)String.valueOf(guestGameMode)), Template.template((String)"plot", (String)plot.getId().toString()));
                    }
                }
                if ((time = ((Long)plot.getFlag(TimeFlag.class)).longValue()) != (Long)TimeFlag.TIME_DISABLED.getValue() && !player.getAttribute("disabletime")) {
                    try {
                        player.setTime(time);
                    }
                    catch (Exception ignored) {
                        TimeFlag plotFlag = GlobalFlagContainer.getInstance().getFlag(TimeFlag.class);
                        PlotFlagRemoveEvent event = this.eventDispatcher.callFlagRemove(plotFlag, plot);
                        if (event.getEventResult() == Result.DENY) break block55;
                        plot.removeFlag(event.getFlag());
                    }
                }
            }
            player.setWeather((PlotWeather)((Object)plot.getFlag(WeatherFlag.class)));
            ItemType musicFlag = (ItemType)plot.getFlag(MusicFlag.class);
            try (MetaDataAccess<Location> musicMeta = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_MUSIC);){
                if (musicFlag != null) {
                    String rawId = musicFlag.getId();
                    if (rawId.contains("disc") || musicFlag == ItemTypes.AIR) {
                        Location location = player.getLocation();
                        Location lastLocation = musicMeta.get().orElse(null);
                        if (lastLocation != null) {
                            player.playMusic(lastLocation, musicFlag);
                            if (musicFlag == ItemTypes.AIR) {
                                musicMeta.remove();
                            }
                        }
                        if (musicFlag != ItemTypes.AIR) {
                            try {
                                musicMeta.set(location);
                                player.playMusic(location, musicFlag);
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    musicMeta.get().ifPresent(lastLoc -> {
                        musicMeta.remove();
                        player.playMusic((Location)lastLoc, ItemTypes.AIR);
                    });
                }
            }
            CommentManager.sendTitle(player, plot);
            if (titles && !player.getAttribute("disabletitles")) {
                boolean fromFlag;
                String subtitle;
                String title;
                PlotTitle titleFlag = (PlotTitle)plot.getFlag(PlotTitleFlag.class);
                if (titleFlag.title() != null && titleFlag.subtitle() != null) {
                    title = titleFlag.title();
                    subtitle = titleFlag.subtitle();
                    fromFlag = true;
                } else {
                    title = "";
                    subtitle = "";
                    fromFlag = false;
                }
                if (fromFlag || !((Boolean)plot.getFlag(ServerPlotFlag.class)).booleanValue() || Settings.Titles.DISPLAY_DEFAULT_ON_SERVER_PLOT) {
                    TaskManager.runTaskLaterAsync(() -> {
                        Plot lastPlot;
                        try (MetaDataAccess<Plot> lastPlotAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                            lastPlot = lastPlotAccess.get().orElse(null);
                        }
                        if (lastPlot != null && plot.getId().equals(lastPlot.getId()) && plot.hasOwner()) {
                            UUID plotOwner = plot.getOwnerAbs();
                            String owner = PlayerManager.getName(plotOwner, false);
                            Caption header = fromFlag ? StaticCaption.of(title) : TranslatableCaption.of("titles.title_entered_plot");
                            Caption subHeader = fromFlag ? StaticCaption.of(subtitle) : TranslatableCaption.of("titles.title_entered_plot_sub");
                            Template plotTemplate = Template.template((String)"plot", (String)lastPlot.getId().toString());
                            Template worldTemplate = Template.template((String)"world", (String)player.getLocation().getWorldName());
                            Template ownerTemplate = Template.template((String)"owner", (String)owner);
                            Template aliasTemplate = Template.template((String)"alias", (String)plot.getAlias());
                            Consumer<String> userConsumer = user -> {
                                if (Settings.Titles.TITLES_AS_ACTIONBAR) {
                                    player.sendActionBar(header, aliasTemplate, plotTemplate, worldTemplate, ownerTemplate);
                                } else {
                                    player.sendTitle(header, subHeader, aliasTemplate, plotTemplate, worldTemplate, ownerTemplate);
                                }
                            };
                            UUID uuid = plot.getOwner();
                            if (uuid == null) {
                                userConsumer.accept("Unknown");
                            } else if (uuid.equals(DBFunc.SERVER)) {
                                userConsumer.accept(MINI_MESSAGE.stripTokens(TranslatableCaption.of("info.server").getComponent(player)));
                            } else {
                                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(plot.getOwner(), (user, throwable) -> {
                                    if (throwable != null) {
                                        userConsumer.accept("Unknown");
                                    } else {
                                        userConsumer.accept((String)user);
                                    }
                                });
                            }
                        }
                    }, TaskTime.seconds(1L));
                }
            }
            if ((feed = (TimedFlag.Timed)plot.getFlag(FeedFlag.class)).getInterval() != 0 && (Integer)feed.getValue() != 0) {
                this.feedRunnable.put(player.getUUID(), new Interval(feed.getInterval(), (Integer)feed.getValue(), 20));
            }
            if ((heal = (TimedFlag.Timed)plot.getFlag(HealFlag.class)).getInterval() != 0 && (Integer)heal.getValue() != 0) {
                this.healRunnable.put(player.getUUID(), new Interval(heal.getInterval(), (Integer)heal.getValue(), 20));
            }
            return true;
        }
        return true;
    }

    public boolean plotExit(PlotPlayer<?> player, Plot plot) {
        block46: {
            try (MetaDataAccess<Plot> lastPlot = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                PlotWeather plotWeather;
                FlyFlag.FlyStatus flyStatus;
                String farewell;
                Plot previous = lastPlot.remove();
                this.eventDispatcher.callLeave(player, plot);
                if (!plot.hasOwner()) break block46;
                PlotArea pw = plot.getArea();
                if (pw == null) {
                    boolean bl = true;
                    return bl;
                }
                try (MetaDataAccess<Boolean> kickAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_KICK);){
                    if (((Boolean)plot.getFlag(DenyExitFlag.class)).booleanValue() && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_EXIT_DENIED) && !kickAccess.get().orElse(false).booleanValue()) {
                        if (previous != null) {
                            lastPlot.set(previous);
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                if (!(((GameMode)plot.getFlag(GamemodeFlag.class)).equals((Object)GamemodeFlag.DEFAULT) && ((GameMode)plot.getFlag(GuestGamemodeFlag.class)).equals((Object)GamemodeFlag.DEFAULT) || player.getGameMode() == pw.getGameMode())) {
                    if (!Permissions.hasPermission(player, "plots.gamemode.bypass")) {
                        player.setGameMode(pw.getGameMode());
                    } else {
                        player.sendMessage(TranslatableCaption.of("gamemode.gamemode_was_bypassed"), Template.template((String)"gamemode", (String)pw.getGameMode().getName().toLowerCase()), Template.template((String)"plot", (String)plot.toString()));
                    }
                }
                if (!(farewell = (String)plot.getFlag(FarewellFlag.class)).isEmpty()) {
                    if (!Settings.Chat.NOTIFICATION_AS_ACTIONBAR) {
                        player.sendMessage(TranslatableCaption.of("flags.farewell_flag_format"), Template.template((String)"world", (String)plot.getWorldName()), Template.template((String)"plot_id", (String)plot.getId().toString()), Template.template((String)"alias", (String)plot.getAlias()), Template.template((String)"farewell", (String)farewell));
                    } else {
                        player.sendActionBar(TranslatableCaption.of("flags.farewell_flag_format"), Template.template((String)"world", (String)plot.getWorldName()), Template.template((String)"plot_id", (String)plot.getId().toString()), Template.template((String)"alias", (String)plot.getAlias()), Template.template((String)"farewell", (String)farewell));
                    }
                }
                if (((Boolean)plot.getFlag(NotifyLeaveFlag.class)).booleanValue() && !Permissions.hasPermission(player, "plots.flag.notify-leave.bypass")) {
                    for (UUID uuid : plot.getOwners()) {
                        PlotPlayer<?> owner = PlotSquared.platform().playerManager().getPlayerIfExists(uuid);
                        if (owner == null || owner.getUUID().equals(player.getUUID()) || !owner.canSee(player)) continue;
                        TranslatableCaption caption = TranslatableCaption.of("notification.notify_leave");
                        Template playerTemplate = Template.template((String)"player", (String)player.getName());
                        Template plotTemplate = Template.template((String)"plot", (String)plot.getId().toString());
                        if (!Settings.Chat.NOTIFICATION_AS_ACTIONBAR) {
                            owner.sendMessage(caption, playerTemplate, plotTemplate);
                            continue;
                        }
                        owner.sendActionBar(caption, playerTemplate, plotTemplate);
                    }
                }
                if ((flyStatus = (FlyFlag.FlyStatus)((Object)plot.getFlag(FlyFlag.class))) != FlyFlag.FlyStatus.DEFAULT) {
                    try (MetaDataAccess<Boolean> metaDataAccess = player.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_FLIGHT);){
                        Optional<Boolean> value = metaDataAccess.get();
                        if (value.isPresent()) {
                            player.setFlight(value.get());
                            metaDataAccess.remove();
                        } else {
                            GameMode gameMode = player.getGameMode();
                            if (gameMode == GameModes.SURVIVAL || gameMode == GameModes.ADVENTURE) {
                                player.setFlight(false);
                            } else if (!player.getFlight()) {
                                player.setFlight(true);
                            }
                        }
                    }
                }
                if (((Long)plot.getFlag(TimeFlag.class)).longValue() != ((Long)TimeFlag.TIME_DISABLED.getValue()).longValue()) {
                    player.setTime(Long.MAX_VALUE);
                }
                if ((plotWeather = (PlotWeather)((Object)plot.getFlag(WeatherFlag.class))) != PlotWeather.OFF) {
                    player.setWeather(PlotWeather.WORLD);
                }
                try (MetaDataAccess<Location> musicAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_MUSIC);){
                    musicAccess.get().ifPresent(lastLoc -> {
                        musicAccess.remove();
                        player.playMusic((Location)lastLoc, ItemTypes.AIR);
                    });
                }
                this.feedRunnable.remove(player.getUUID());
                this.healRunnable.remove(player.getUUID());
            }
        }
        return true;
    }

    public void logout(UUID uuid) {
        this.feedRunnable.remove(uuid);
        this.healRunnable.remove(uuid);
    }

    private static class Interval {
        final int interval;
        final int amount;
        final int max;
        int count = 0;

        Interval(int interval, int amount, int max) {
            this.interval = interval;
            this.amount = amount;
            this.max = max;
        }
    }
}

