/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.google.inject.Inject;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.listener.WEExtent;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.expiration.PlotAnalysis;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.AnalysisFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.queue.ChunkQueueCoordinator;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.ChunkManager;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.RegionUtil;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public class HybridUtils {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + HybridUtils.class.getSimpleName()));
    public static HybridUtils manager;
    public static Set<BlockVector2> regions;
    public static int height;
    public static Set<BlockVector2> chunks;
    public static PlotArea area;
    public static boolean UPDATE;
    private final PlotAreaManager plotAreaManager;
    private final ChunkManager chunkManager;
    private final GlobalBlockQueue blockQueue;
    private final WorldUtil worldUtil;
    private final SchematicHandler schematicHandler;

    @Inject
    public HybridUtils(@NonNull PlotAreaManager plotAreaManager, @NonNull ChunkManager chunkManager, @NonNull GlobalBlockQueue blockQueue, @NonNull WorldUtil worldUtil, @NonNull SchematicHandler schematicHandler) {
        this.plotAreaManager = plotAreaManager;
        this.chunkManager = chunkManager;
        this.blockQueue = blockQueue;
        this.worldUtil = worldUtil;
        this.schematicHandler = schematicHandler;
    }

    public void regeneratePlotWalls(PlotArea area) {
        PlotManager plotManager = area.getPlotManager();
        plotManager.regenerateAllPlotWalls(null);
    }

    public void analyzeRegion(String world, CuboidRegion region, RunnableVal<PlotAnalysis> whenDone) {
        TaskManager.runTaskAsync(() -> {
            BlockVector3 bot = region.getMinimumPoint();
            BlockVector3 top = region.getMaximumPoint();
            int bx = bot.getX();
            int bz = bot.getZ();
            int tx = top.getX();
            int tz = top.getZ();
            int cbx = bx >> 4;
            int cbz = bz >> 4;
            int ctx = tx >> 4;
            int ctz = tz >> 4;
            int width = tx - bx + 1;
            int length = tz - bz + 1;
            PlotArea area = this.plotAreaManager.getPlotArea(world, null);
            PlotArea hpw$temp = area;
            if (!(hpw$temp instanceof HybridPlotWorld)) {
                return;
            }
            HybridPlotWorld hpw = (HybridPlotWorld)hpw$temp;
            ChunkQueueCoordinator chunk = new ChunkQueueCoordinator(bot, top, false);
            hpw.getGenerator().generateChunk(chunk, hpw);
            BlockState[][][] oldBlocks = chunk.getBlocks();
            BlockState[][][] newBlocks = new BlockState[256][width][length];
            BlockState airBlock = BlockTypes.AIR.getDefaultState();
            System.gc();
            System.gc();
            QueueCoordinator queue = area.getQueue();
            queue.addReadChunks(region.getChunks());
            queue.setChunkConsumer(blockVector2 -> {
                int X = blockVector2.getX();
                int Z = blockVector2.getZ();
                int minX = X == cbx ? bx & 0xF : 0;
                int minZ = Z == cbz ? bz & 0xF : 0;
                int maxX = X == ctx ? tx & 0xF : 16;
                int maxZ = Z == ctz ? tz & 0xF : 16;
                int chunkBlockX = X << 4;
                int chunkBlockZ = Z << 4;
                int xb = chunkBlockX - bx;
                int zb = chunkBlockZ - bz;
                for (int x = minX; x <= maxX; ++x) {
                    int xx = chunkBlockX + x;
                    for (int z = minZ; z <= maxZ; ++z) {
                        int zz = chunkBlockZ + z;
                        for (int y = 0; y < 256; ++y) {
                            BlockState block = queue.getBlock(xx, y, zz);
                            int xr = xb + x;
                            int zr = zb + z;
                            newBlocks[y][xr][zr] = block;
                        }
                    }
                }
            });
            Runnable run = () -> TaskManager.runTaskAsync(() -> {
                int size = width * length;
                int[] changes = new int[size];
                int[] faces = new int[size];
                int[] data = new int[size];
                int[] air = new int[size];
                int[] variety = new int[size];
                int i = 0;
                for (int x = 0; x < width; ++x) {
                    for (int z = 0; z < length; ++z) {
                        HashSet<BlockType> types = new HashSet<BlockType>();
                        for (int y = 0; y < 256; ++y) {
                            BlockState old = oldBlocks[y][x][z];
                            try {
                                BlockState now;
                                if (old == null) {
                                    old = airBlock;
                                }
                                if (!old.equals((Object)(now = newBlocks[y][x][z]))) {
                                    int n = i;
                                    changes[n] = changes[n] + 1;
                                }
                                if (now.getBlockType().getMaterial().isAir()) {
                                    int n = i;
                                    air[n] = air[n] + 1;
                                    continue;
                                }
                                if (x > 0 && z > 0 && y > 0 && x < width - 1 && z < length - 1 && y < 255) {
                                    if (newBlocks[y - 1][x][z].getBlockType().getMaterial().isAir()) {
                                        int n = i;
                                        faces[n] = faces[n] + 1;
                                    }
                                    if (newBlocks[y][x - 1][z].getBlockType().getMaterial().isAir()) {
                                        int n = i;
                                        faces[n] = faces[n] + 1;
                                    }
                                    if (newBlocks[y][x][z - 1].getBlockType().getMaterial().isAir()) {
                                        int n = i;
                                        faces[n] = faces[n] + 1;
                                    }
                                    if (newBlocks[y + 1][x][z].getBlockType().getMaterial().isAir()) {
                                        int n = i;
                                        faces[n] = faces[n] + 1;
                                    }
                                    if (newBlocks[y][x + 1][z].getBlockType().getMaterial().isAir()) {
                                        int n = i;
                                        faces[n] = faces[n] + 1;
                                    }
                                    if (newBlocks[y][x][z + 1].getBlockType().getMaterial().isAir()) {
                                        int n = i;
                                        faces[n] = faces[n] + 1;
                                    }
                                }
                                if (!now.equals((Object)now.getBlockType().getDefaultState())) {
                                    int n = i;
                                    data[n] = data[n] + 1;
                                }
                                types.add(now.getBlockType());
                                continue;
                            }
                            catch (NullPointerException e) {
                                e.printStackTrace();
                            }
                        }
                        variety[i] = types.size();
                        ++i;
                    }
                }
                PlotAnalysis analysis = new PlotAnalysis();
                analysis.changes = (int)(MathMan.getMean(changes) * 100.0);
                analysis.faces = (int)(MathMan.getMean(faces) * 100.0);
                analysis.data = (int)(MathMan.getMean(data) * 100.0);
                analysis.air = (int)(MathMan.getMean(air) * 100.0);
                analysis.variety = (int)(MathMan.getMean(variety) * 100.0);
                analysis.changes_sd = (int)(MathMan.getSD(changes, (double)analysis.changes) * 100.0);
                analysis.faces_sd = (int)(MathMan.getSD(faces, (double)analysis.faces) * 100.0);
                analysis.data_sd = (int)(MathMan.getSD(data, (double)analysis.data) * 100.0);
                analysis.air_sd = (int)(MathMan.getSD(air, (double)analysis.air) * 100.0);
                analysis.variety_sd = (int)(MathMan.getSD(variety, (double)analysis.variety) * 100.0);
                System.gc();
                System.gc();
                whenDone.value = analysis;
                whenDone.run();
            });
            queue.setCompleteTask(run);
            queue.enqueue();
        });
    }

    public void analyzePlot(final Plot origin, final RunnableVal<PlotAnalysis> whenDone) {
        final ArrayDeque<CuboidRegion> zones = new ArrayDeque<CuboidRegion>(origin.getRegions());
        final ArrayList analysis = new ArrayList();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (zones.isEmpty()) {
                    if (!analysis.isEmpty()) {
                        whenDone.value = new PlotAnalysis();
                        for (PlotAnalysis data : analysis) {
                            ((PlotAnalysis)whenDone.value).air += data.air;
                            ((PlotAnalysis)whenDone.value).air_sd += data.air_sd;
                            ((PlotAnalysis)whenDone.value).changes += data.changes;
                            ((PlotAnalysis)whenDone.value).changes_sd += data.changes_sd;
                            ((PlotAnalysis)whenDone.value).data += data.data;
                            ((PlotAnalysis)whenDone.value).data_sd += data.data_sd;
                            ((PlotAnalysis)whenDone.value).faces += data.faces;
                            ((PlotAnalysis)whenDone.value).faces_sd += data.faces_sd;
                            ((PlotAnalysis)whenDone.value).variety += data.variety;
                            ((PlotAnalysis)whenDone.value).variety_sd += data.variety_sd;
                        }
                        ((PlotAnalysis)whenDone.value).air /= analysis.size();
                        ((PlotAnalysis)whenDone.value).air_sd /= analysis.size();
                        ((PlotAnalysis)whenDone.value).changes /= analysis.size();
                        ((PlotAnalysis)whenDone.value).changes_sd /= analysis.size();
                        ((PlotAnalysis)whenDone.value).data /= analysis.size();
                        ((PlotAnalysis)whenDone.value).data_sd /= analysis.size();
                        ((PlotAnalysis)whenDone.value).faces /= analysis.size();
                        ((PlotAnalysis)whenDone.value).faces_sd /= analysis.size();
                        ((PlotAnalysis)whenDone.value).variety /= analysis.size();
                        ((PlotAnalysis)whenDone.value).variety_sd /= analysis.size();
                    } else {
                        whenDone.value = analysis.get(0);
                    }
                    ArrayList<Integer> result = new ArrayList<Integer>();
                    result.add(((PlotAnalysis)whenDone.value).changes);
                    result.add(((PlotAnalysis)whenDone.value).faces);
                    result.add(((PlotAnalysis)whenDone.value).data);
                    result.add(((PlotAnalysis)whenDone.value).air);
                    result.add(((PlotAnalysis)whenDone.value).variety);
                    result.add(((PlotAnalysis)whenDone.value).changes_sd);
                    result.add(((PlotAnalysis)whenDone.value).faces_sd);
                    result.add(((PlotAnalysis)whenDone.value).data_sd);
                    result.add(((PlotAnalysis)whenDone.value).air_sd);
                    result.add(((PlotAnalysis)whenDone.value).variety_sd);
                    Object plotFlag = GlobalFlagContainer.getInstance().getFlag(AnalysisFlag.class).createFlagInstance(result);
                    PlotFlagAddEvent event = new PlotFlagAddEvent((PlotFlag<?, ?>)plotFlag, origin);
                    if (event.getEventResult() == Result.DENY) {
                        return;
                    }
                    origin.setFlag(event.getFlag());
                    TaskManager.runTask(whenDone);
                    return;
                }
                CuboidRegion region = (CuboidRegion)zones.poll();
                final 1 task = this;
                HybridUtils.this.analyzeRegion(origin.getWorldName(), region, new RunnableVal<PlotAnalysis>(){

                    @Override
                    public void run(PlotAnalysis value) {
                        analysis.add(value);
                        TaskManager.runTaskLater(task, TaskTime.ticks(1L));
                    }
                });
            }
        };
        run.run();
    }

    public int checkModified(QueueCoordinator queue, int x1, int x2, int y1, int y2, int z1, int z2, BlockState[] blocks) {
        int count = 0;
        for (int y = y1; y <= y2; ++y) {
            for (int x = x1; x <= x2; ++x) {
                for (int z = z1; z <= z2; ++z) {
                    BlockState block = queue.getBlock(x, y, z);
                    boolean same = Arrays.stream(blocks).anyMatch(p -> this.worldUtil.isBlockSame(block, (BlockState)p));
                    if (same) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public final ArrayList<BlockVector2> getChunks(BlockVector2 region) {
        ArrayList<BlockVector2> chunks = new ArrayList<BlockVector2>();
        int sx = region.getX() << 5;
        int sz = region.getZ() << 5;
        for (int x = sx; x < sx + 32; ++x) {
            for (int z = sz; z < sz + 32; ++z) {
                chunks.add(BlockVector2.at((int)x, (int)z));
            }
        }
        return chunks;
    }

    public boolean scheduleRoadUpdate(PlotArea area, int extend) {
        if (UPDATE) {
            return false;
        }
        UPDATE = true;
        Set<BlockVector2> regions = this.worldUtil.getChunkChunks(area.getWorldName());
        return this.scheduleRoadUpdate(area, regions, extend, new HashSet<BlockVector2>());
    }

    public boolean scheduleSingleRegionRoadUpdate(Plot plot, int extend) {
        if (UPDATE) {
            return false;
        }
        UPDATE = true;
        HashSet<BlockVector2> regions = new HashSet<BlockVector2>();
        regions.add(RegionManager.getRegion(plot.getCenterSynchronous()));
        return this.scheduleRoadUpdate(plot.getArea(), regions, extend, new HashSet<BlockVector2>());
    }

    public boolean scheduleRoadUpdate(final PlotArea area, Set<BlockVector2> regions, final int extend, final Set<BlockVector2> chunks) {
        HybridUtils.regions = regions;
        HybridUtils.area = area;
        height = extend;
        HybridUtils.chunks = chunks;
        final AtomicInteger count = new AtomicInteger(0);
        TaskManager.runTask(new Runnable(){

            @Override
            public void run() {
                if (!UPDATE) {
                    Iterator iter = chunks.iterator();
                    while (iter.hasNext()) {
                        BlockVector2 chunk = (BlockVector2)iter.next();
                        iter.remove();
                        boolean regenedRoad = HybridUtils.this.regenerateRoad(area, chunk, extend);
                        if (regenedRoad) continue;
                        LOGGER.info("Failed to regenerate roads");
                    }
                    LOGGER.info("Cancelled road task");
                    return;
                }
                count.incrementAndGet();
                if (count.intValue() % 20 == 0) {
                    LOGGER.info("Progress: {}%", (Object)(100 * (2048 - chunks.size()) / 2048));
                }
                if (regions.isEmpty() && chunks.isEmpty()) {
                    HybridUtils.this.regeneratePlotWalls(area);
                    UPDATE = false;
                    LOGGER.info("Finished road conversion");
                } else {
                    2 task = this;
                    TaskManager.runTaskAsync(() -> {
                        try {
                            if (chunks.size() < 1024 && !regions.isEmpty()) {
                                Iterator<BlockVector2> iterator = regions.iterator();
                                BlockVector2 loc = iterator.next();
                                iterator.remove();
                                LOGGER.info("Updating .mcr: {}, {} (approx 1024 chunks)", (Object)loc.getX(), (Object)loc.getZ());
                                LOGGER.info("- Remaining: {}", (Object)regions.size());
                                chunks.addAll(HybridUtils.this.getChunks(loc));
                                System.gc();
                            }
                            if (!chunks.isEmpty()) {
                                TaskManager.getPlatformImplementation().sync(() -> {
                                    long start = System.currentTimeMillis();
                                    Iterator iterator = chunks.iterator();
                                    while (System.currentTimeMillis() - start < 20L && !chunks.isEmpty()) {
                                        BlockVector2 chunk = (BlockVector2)iterator.next();
                                        iterator.remove();
                                        boolean regenedRoads = HybridUtils.this.regenerateRoad(area, chunk, extend);
                                        if (regenedRoads) continue;
                                        LOGGER.info("Failed to regenerate road");
                                    }
                                    return null;
                                });
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Iterator<BlockVector2> iterator = regions.iterator();
                            BlockVector2 loc = iterator.next();
                            iterator.remove();
                            LOGGER.error("Error! Could not update '{}/region/r.{}.{}.mca' (Corrupt chunk?)", (Object)area.getWorldHash(), (Object)loc.getX(), (Object)loc.getZ());
                        }
                        TaskManager.runTaskLater(task, TaskTime.seconds(1L));
                    });
                }
            }
        });
        return true;
    }

    public boolean setupRoadSchematic(Plot plot) {
        String world = plot.getWorldName();
        QueueCoordinator queue = this.blockQueue.getNewQueue(this.worldUtil.getWeWorld(world));
        Location bot = plot.getBottomAbs().subtract(1, 0, 1);
        Location top = plot.getTopAbs();
        HybridPlotWorld plotworld = (HybridPlotWorld)plot.getArea();
        PlotManager plotManager = plotworld.getPlotManager();
        int schemY = Math.min(plotworld.PLOT_HEIGHT, Math.min(plotworld.WALL_HEIGHT, plotworld.ROAD_HEIGHT));
        int sx = bot.getX() - plotworld.ROAD_WIDTH + 1;
        int sz = bot.getZ() + 1;
        int sy = Settings.Schematics.PASTE_ROAD_ON_TOP ? schemY : plot.getArea().getMinBuildHeight();
        int ex = bot.getX();
        int ez = top.getZ();
        int ey = this.get_ey(plotManager, queue, sx, ex, sz, ez, sy);
        int bz = sz - plotworld.ROAD_WIDTH;
        int tz = sz - 1;
        int ty = this.get_ey(plotManager, queue, sx, ex, bz, tz, sy);
        Set<CuboidRegion> sideRoad = Collections.singleton(RegionUtil.createRegion(sx, ex, sy, ey, sz, ez));
        Set<CuboidRegion> intersection = Collections.singleton(RegionUtil.createRegion(sx, ex, sy, ty, bz, tz));
        String dir = Settings.Paths.SCHEMATICS + File.separator + "GEN_ROAD_SCHEMATIC" + File.separator + plot.getArea().toString() + File.separator;
        this.schematicHandler.getCompoundTag(world, sideRoad).whenComplete((compoundTag, throwable) -> {
            this.schematicHandler.save((CompoundTag)compoundTag, dir + "sideroad.schem");
            this.schematicHandler.getCompoundTag(world, intersection).whenComplete((c, t) -> {
                this.schematicHandler.save((CompoundTag)c, dir + "intersection.schem");
                plotworld.ROAD_SCHEMATIC_ENABLED = true;
                try {
                    plotworld.setupSchematics();
                }
                catch (SchematicHandler.UnsupportedFormatException e) {
                    e.printStackTrace();
                }
            });
        });
        return true;
    }

    public int get_ey(PlotManager pm, QueueCoordinator queue, int sx, int ex, int sz, int ez, int sy) {
        int ey = sy;
        for (int x = sx; x <= ex; ++x) {
            for (int z = sz; z <= ez; ++z) {
                for (int y = sy; y <= pm.getWorldHeight(); ++y) {
                    BlockState block;
                    if (y <= ey || (block = queue.getBlock(x, y, z)).getBlockType().getMaterial().isAir()) continue;
                    ey = y;
                }
            }
        }
        return ey;
    }

    public boolean regenerateRoad(PlotArea area, BlockVector2 chunk, int extend) {
        int x = chunk.getX() << 4;
        int z = chunk.getZ() << 4;
        int ex = x + 15;
        int ez = z + 15;
        HybridPlotWorld plotWorld = (HybridPlotWorld)area;
        if (!plotWorld.ROAD_SCHEMATIC_ENABLED) {
            return false;
        }
        AtomicBoolean toCheck = new AtomicBoolean(false);
        if (plotWorld.getType() == PlotAreaType.PARTIAL) {
            boolean chunk1 = area.contains(x, z);
            boolean chunk2 = area.contains(ex, ez);
            if (!chunk1 && !chunk2) {
                return false;
            }
            toCheck.set(chunk1 ^ chunk2);
        }
        PlotManager manager = area.getPlotManager();
        PlotId id1 = manager.getPlotId(x, 0, z);
        PlotId id2 = manager.getPlotId(ex, 0, ez);
        int finalX = x -= plotWorld.ROAD_OFFSET_X;
        int finalZ = z -= plotWorld.ROAD_OFFSET_Z;
        QueueCoordinator queue = this.blockQueue.getNewQueue(this.worldUtil.getWeWorld(plotWorld.getWorldName()));
        if (id1 == null || id2 == null || id1 != id2) {
            this.chunkManager.loadChunk(area.getWorldName(), chunk, false).thenRun(() -> {
                Plot p2;
                Plot p1;
                if (id1 != null && (p1 = area.getPlotAbs(id1)) != null && p1.hasOwner() && p1.isMerged()) {
                    toCheck.set(true);
                }
                if (id2 != null && !toCheck.get() && (p2 = area.getPlotAbs(id2)) != null && p2.hasOwner() && p2.isMerged()) {
                    toCheck.set(true);
                }
                short size = plotWorld.SIZE;
                for (int X = 0; X < 16; ++X) {
                    short absX = (short)((finalX + X) % size);
                    for (int Z = 0; Z < 16; ++Z) {
                        boolean condition;
                        short absZ = (short)((finalZ + Z) % size);
                        if (absX < 0) {
                            absX = (short)(absX + size);
                        }
                        if (absZ < 0) {
                            absZ = (short)(absZ + size);
                        }
                        if (toCheck.get()) {
                            condition = manager.getPlotId(finalX + X + plotWorld.ROAD_OFFSET_X, 1, finalZ + Z + plotWorld.ROAD_OFFSET_Z) == null;
                        } else {
                            boolean gx = absX > plotWorld.PATH_WIDTH_LOWER;
                            boolean gz = absZ > plotWorld.PATH_WIDTH_LOWER;
                            boolean lx = absX < plotWorld.PATH_WIDTH_UPPER;
                            boolean lz = absZ < plotWorld.PATH_WIDTH_UPPER;
                            boolean bl = condition = !gx || !gz || !lx || !lz;
                        }
                        if (!condition) continue;
                        BaseBlock[] blocks = plotWorld.G_SCH.get(MathMan.pair(absX, absZ));
                        int minY = Settings.Schematics.PASTE_ROAD_ON_TOP ? plotWorld.SCHEM_Y : 1;
                        int maxY = Math.max(extend, blocks.length);
                        for (int y = 0; y < maxY; ++y) {
                            if (y > blocks.length - 1) {
                                queue.setBlock(finalX + X + plotWorld.ROAD_OFFSET_X, minY + y, finalZ + Z + plotWorld.ROAD_OFFSET_Z, WEExtent.AIRBASE);
                                continue;
                            }
                            BaseBlock block = blocks[y];
                            if (block != null) {
                                queue.setBlock(finalX + X + plotWorld.ROAD_OFFSET_X, minY + y, finalZ + Z + plotWorld.ROAD_OFFSET_Z, block);
                                continue;
                            }
                            queue.setBlock(finalX + X + plotWorld.ROAD_OFFSET_X, minY + y, finalZ + Z + plotWorld.ROAD_OFFSET_Z, WEExtent.AIRBASE);
                        }
                        BiomeType biome = plotWorld.G_SCH_B.get(MathMan.pair(absX, absZ));
                        if (biome != null) {
                            queue.setBiome(finalX + X + plotWorld.ROAD_OFFSET_X, finalZ + Z + plotWorld.ROAD_OFFSET_Z, biome);
                            continue;
                        }
                        queue.setBiome(finalX + X + plotWorld.ROAD_OFFSET_X, finalZ + Z + plotWorld.ROAD_OFFSET_Z, plotWorld.getPlotBiome());
                    }
                }
                queue.enqueue();
            });
            return true;
        }
        return false;
    }

    static {
        chunks = new HashSet<BlockVector2>();
        UPDATE = false;
    }
}

