/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.inject.factory.HybridPlotWorldFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.ScopedQueueCoordinator;
import com.plotsquared.core.util.MathMan;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.checkerframework.checker.nullness.qual.NonNull;

public class HybridGen
extends IndependentPlotGenerator {
    private final HybridPlotWorldFactory hybridPlotWorldFactory;

    @Inject
    public HybridGen(@NonNull HybridPlotWorldFactory hybridPlotWorldFactory) {
        this.hybridPlotWorldFactory = hybridPlotWorldFactory;
    }

    @Override
    public String getName() {
        return PlotSquared.platform().pluginName();
    }

    private void placeSchem(HybridPlotWorld world, ScopedQueueCoordinator result, short relativeX, short relativeZ, int x, int z, boolean isRoad) {
        BiomeType biome;
        int minY = isRoad && Settings.Schematics.PASTE_ROAD_ON_TOP || !isRoad && Settings.Schematics.PASTE_ON_TOP ? world.SCHEM_Y : world.getMinBuildHeight();
        BaseBlock[] blocks = world.G_SCH.get(MathMan.pair(relativeX, relativeZ));
        if (blocks != null) {
            for (int y = 0; y < blocks.length; ++y) {
                if (blocks[y] == null) continue;
                result.setBlock(x, minY + y, z, blocks[y]);
            }
        }
        if ((biome = world.G_SCH_B.get(MathMan.pair(relativeX, relativeZ))) != null) {
            result.setBiome(x, z, biome);
        }
    }

    @Override
    public void generateChunk(@NonNull ScopedQueueCoordinator result, @NonNull PlotArea settings) {
        Preconditions.checkNotNull((Object)result, (Object)"result cannot be null");
        Preconditions.checkNotNull((Object)settings, (Object)"settings cannot be null");
        HybridPlotWorld hybridPlotWorld = (HybridPlotWorld)settings;
        result.fillBiome(hybridPlotWorld.getPlotBiome());
        if (hybridPlotWorld.PLOT_BEDROCK) {
            for (int x = 0; x < 16; x = (int)((short)(x + 1))) {
                for (int z = 0; z < 16; z = (int)((short)(z + 1))) {
                    result.setBlock(x, 0, z, BlockTypes.BEDROCK.getDefaultState());
                }
            }
        }
        Location min = result.getMin();
        int bx = min.getX() - hybridPlotWorld.ROAD_OFFSET_X;
        int bz = min.getZ() - hybridPlotWorld.ROAD_OFFSET_Z;
        short relativeOffsetX = bx < 0 ? (short)(hybridPlotWorld.SIZE + bx % hybridPlotWorld.SIZE) : (short)(bx % hybridPlotWorld.SIZE);
        short relativeOffsetZ = bz < 0 ? (short)(hybridPlotWorld.SIZE + bz % hybridPlotWorld.SIZE) : (short)(bz % hybridPlotWorld.SIZE);
        short[] relativeX = new short[16];
        boolean[] insideRoadX = new boolean[16];
        boolean[] insideWallX = new boolean[16];
        for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
            short v = (short)(relativeOffsetX + i);
            while (v >= hybridPlotWorld.SIZE) {
                v = (short)(v - hybridPlotWorld.SIZE);
            }
            relativeX[i] = v;
            if (hybridPlotWorld.ROAD_WIDTH == 0) continue;
            insideRoadX[i] = v < hybridPlotWorld.PATH_WIDTH_LOWER || v > hybridPlotWorld.PATH_WIDTH_UPPER;
            insideWallX[i] = v == hybridPlotWorld.PATH_WIDTH_LOWER || v == hybridPlotWorld.PATH_WIDTH_UPPER;
        }
        short[] relativeZ = new short[16];
        boolean[] insideRoadZ = new boolean[16];
        boolean[] insideWallZ = new boolean[16];
        for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
            short v = (short)(relativeOffsetZ + i);
            while (v >= hybridPlotWorld.SIZE) {
                v = (short)(v - hybridPlotWorld.SIZE);
            }
            relativeZ[i] = v;
            if (hybridPlotWorld.ROAD_WIDTH == 0) continue;
            insideRoadZ[i] = v < hybridPlotWorld.PATH_WIDTH_LOWER || v > hybridPlotWorld.PATH_WIDTH_UPPER;
            insideWallZ[i] = v == hybridPlotWorld.PATH_WIDTH_LOWER || v == hybridPlotWorld.PATH_WIDTH_UPPER;
        }
        int startY = hybridPlotWorld.PLOT_BEDROCK ? 1 : 0;
        for (int x = 0; x < 16; x = (int)((short)(x + 1))) {
            int y;
            int z;
            if (insideRoadX[x]) {
                for (z = 0; z < 16; z = (int)((short)(z + 1))) {
                    for (y = startY; y <= hybridPlotWorld.ROAD_HEIGHT; ++y) {
                        result.setBlock(x, y, z, hybridPlotWorld.ROAD_BLOCK.toPattern());
                    }
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                    this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, true);
                }
                continue;
            }
            if (insideWallX[x]) {
                for (z = 0; z < 16; z = (int)((short)(z + 1))) {
                    if (insideRoadZ[z]) {
                        for (y = startY; y <= hybridPlotWorld.ROAD_HEIGHT; ++y) {
                            result.setBlock(x, y, z, hybridPlotWorld.ROAD_BLOCK.toPattern());
                        }
                        if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                        this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, true);
                        continue;
                    }
                    for (y = startY; y <= hybridPlotWorld.WALL_HEIGHT; ++y) {
                        result.setBlock(x, y, z, hybridPlotWorld.WALL_FILLING.toPattern());
                    }
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
                        if (!hybridPlotWorld.PLACE_TOP_BLOCK) continue;
                        result.setBlock(x, hybridPlotWorld.WALL_HEIGHT + 1, z, hybridPlotWorld.WALL_BLOCK.toPattern());
                        continue;
                    }
                    this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, true);
                }
                continue;
            }
            for (z = 0; z < 16; z = (int)((short)(z + 1))) {
                if (insideRoadZ[z]) {
                    for (y = startY; y <= hybridPlotWorld.ROAD_HEIGHT; ++y) {
                        result.setBlock(x, y, z, hybridPlotWorld.ROAD_BLOCK.toPattern());
                    }
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                    this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, true);
                    continue;
                }
                if (insideWallZ[z]) {
                    for (y = startY; y <= hybridPlotWorld.WALL_HEIGHT; ++y) {
                        result.setBlock(x, y, z, hybridPlotWorld.WALL_FILLING.toPattern());
                    }
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
                        if (!hybridPlotWorld.PLACE_TOP_BLOCK) continue;
                        result.setBlock(x, hybridPlotWorld.WALL_HEIGHT + 1, z, hybridPlotWorld.WALL_BLOCK.toPattern());
                        continue;
                    }
                    this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, true);
                    continue;
                }
                for (y = startY; y < hybridPlotWorld.PLOT_HEIGHT; ++y) {
                    result.setBlock(x, y, z, hybridPlotWorld.MAIN_BLOCK.toPattern());
                }
                result.setBlock(x, hybridPlotWorld.PLOT_HEIGHT, z, hybridPlotWorld.TOP_BLOCK.toPattern());
                if (!hybridPlotWorld.PLOT_SCHEMATIC) continue;
                this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, false);
            }
        }
    }

    @Override
    public PlotArea getNewPlotArea(String world, String id, PlotId min, PlotId max) {
        return this.hybridPlotWorldFactory.create(world, id, this, min, max);
    }

    @Override
    public void initialize(PlotArea area) {
    }
}

