/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.setup.SetupProcess;
import com.plotsquared.core.setup.SetupStep;
import com.plotsquared.core.util.SetupUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="setup", permission="plots.admin.command.setup", usage="/plot setup", aliases={"create"}, category=CommandCategory.ADMINISTRATION)
public class Setup
extends SubCommand {
    private final SetupUtils setupUtils;

    @Inject
    public Setup(@NonNull SetupUtils setupUtils) {
        this.setupUtils = setupUtils;
    }

    public void displayGenerators(PlotPlayer<?> player) {
        StringBuilder message = new StringBuilder();
        message.append(TranslatableCaption.of("setup.choose_generator").getComponent(player));
        for (Map.Entry<String, GeneratorWrapper<?>> entry : SetupUtils.generators.entrySet()) {
            if (entry.getKey().equals(PlotSquared.platform().pluginName())) {
                message.append("\n<dark_gray> - </dark_gray><dark_green>").append(entry.getKey()).append(" (Default Generator)</dark_green>");
                continue;
            }
            if (entry.getValue().isFull()) {
                message.append("\n<dark_gray> - </dark_gray><gray>").append(entry.getKey()).append(" (Plot Generator)</gray>");
                continue;
            }
            message.append("\n<dark_gray> - </dark_gray><gray>").append(entry.getKey()).append(" (Unknown structure)</gray>");
        }
        player.sendMessage(StaticCaption.of(message.toString()), new Template[0]);
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        try (MetaDataAccess<SetupProcess> metaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SETUP);){
            SetupProcess process = metaDataAccess.get().orElse(null);
            if (process == null) {
                if (args.length > 0) {
                    player.sendMessage(TranslatableCaption.of("setup.setup_not_started"), new Template[0]);
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.template((String)"value", (String)"Use /plot setup to start a setup process."));
                    boolean bl = true;
                    return bl;
                }
                process = new SetupProcess();
                metaDataAccess.set(process);
                this.setupUtils.updateGenerators(false);
                SetupStep step = process.getCurrentStep();
                step.announce(player);
                this.displayGenerators(player);
                boolean bl = true;
                return bl;
            }
            if (args.length == 1) {
                if ("back".equalsIgnoreCase(args[0])) {
                    process.back();
                    process.getCurrentStep().announce(player);
                } else if ("cancel".equalsIgnoreCase(args[0])) {
                    metaDataAccess.remove();
                    player.sendMessage(TranslatableCaption.of("setup.setup_cancelled"), new Template[0]);
                } else {
                    process.handleInput(player, args[0]);
                    if (process.getCurrentStep() != null) {
                        process.getCurrentStep().announce(player);
                    }
                }
            } else {
                process.getCurrentStep().announce(player);
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        SetupProcess process;
        try (MetaDataAccess<SetupProcess> metaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SETUP);){
            process = metaDataAccess.get().orElse(null);
        }
        if (process == null) {
            return Collections.emptyList();
        }
        if (args.length > 1 || args.length == 1 && space) {
            return Collections.emptyList();
        }
        SetupStep setupStep = process.getCurrentStep();
        ArrayList<Command> commands = new ArrayList<Command>(setupStep.createSuggestions(player, space ? "" : args[0]));
        this.tryAddSubCommand("back", args[0], commands);
        this.tryAddSubCommand("cancel", args[0], commands);
        return commands;
    }

    private void tryAddSubCommand(String subCommand, String argument, List<Command> suggestions) {
        if (!argument.isEmpty() && subCommand.startsWith(argument)) {
            suggestions.add(new Command(null, false, subCommand, "", RequiredType.NONE, null){});
        }
    }
}

