/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.StringMan;
import net.kyori.adventure.text.minimessage.Template;

public abstract class SetCommand
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Location location = player.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (!plot.hasOwner() && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_COMMAND.format(this.getFullId()))) {
            player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.template((String)"node", (String)Permission.PERMISSION_ADMIN_COMMAND.format(this.getFullId())));
            player.sendMessage(TranslatableCaption.of("working.plot_not_claimed"), new Template[0]);
            return false;
        }
        if (!plot.isOwner(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_COMMAND.format(this.getFullId()))) {
            player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.template((String)"node", (String)Permission.PERMISSION_ADMIN_COMMAND.format(this.getFullId())));
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
            return false;
        }
        if (args.length == 0) {
            return this.set(player, plot, "");
        }
        return this.set(player, plot, StringMan.join(args, " "));
    }

    public abstract boolean set(PlotPlayer<?> var1, Plot var2, String var3);
}

