/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.uuid.UUIDMapping;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.minimessage.Template;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(usage="/plot purge world:<world> area:<area> id:<id> owner:<owner> shared:<shared> unknown:[true | false] clear:[true | false]", command="purge", permission="plots.admin", category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.CONSOLE, confirmation=true)
public class Purge
extends SubCommand {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + Purge.class.getSimpleName()));
    private final PlotAreaManager plotAreaManager;
    private final PlotListener plotListener;

    @Inject
    public Purge(@NonNull PlotAreaManager plotAreaManager, @NonNull PlotListener plotListener) {
        this.plotAreaManager = plotAreaManager;
        this.plotListener = plotListener;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean onCommand(final PlotPlayer<?> player, String[] args) {
        void var11_13;
        if (args.length == 0) {
            this.sendUsage(player);
            return false;
        }
        String world = null;
        PlotArea area = null;
        PlotId id = null;
        UUID owner = null;
        UUID added = null;
        boolean clear = false;
        String[] stringArray = args;
        int n = stringArray.length;
        boolean bl = false;
        while (var11_13 < n) {
            String arg = stringArray[var11_13];
            String[] split = arg.split(":");
            if (split.length != 2) {
                this.sendUsage(player);
                return false;
            }
            switch (split[0].toLowerCase()) {
                case "world": 
                case "w": {
                    world = split[1];
                    break;
                }
                case "area": 
                case "a": {
                    area = this.plotAreaManager.getPlotAreaByString(split[1]);
                    if (area != null) break;
                    player.sendMessage(TranslatableCaption.of("errors.not_valid_plot_world"), Template.template((String)"value", (String)split[1]));
                    return false;
                }
                case "plotid": 
                case "id": {
                    try {
                        id = PlotId.fromString(split[1]);
                        break;
                    }
                    catch (IllegalArgumentException ignored) {
                        player.sendMessage(TranslatableCaption.of("invalid.not_valid_plot_id"), Template.template((String)"value", (String)split[1]));
                        return false;
                    }
                }
                case "owner": 
                case "o": {
                    UUIDMapping ownerMapping = PlotSquared.get().getImpromptuUUIDPipeline().getImmediately(split[1]);
                    if (ownerMapping == null) {
                        player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.template((String)"value", (String)split[1]));
                        return false;
                    }
                    owner = ownerMapping.getUuid();
                    break;
                }
                case "shared": 
                case "s": {
                    UUIDMapping addedMapping = PlotSquared.get().getImpromptuUUIDPipeline().getImmediately(split[1]);
                    if (addedMapping == null) {
                        player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.template((String)"value", (String)split[1]));
                        return false;
                    }
                    owner = addedMapping.getUuid();
                    break;
                }
                case "clear": 
                case "c": 
                case "delete": 
                case "d": 
                case "del": {
                    clear = Boolean.parseBoolean(split[1]);
                    break;
                }
                default: {
                    this.sendUsage(player);
                    return false;
                }
            }
            ++var11_13;
        }
        HashSet<Plot> toDelete = new HashSet<Plot>();
        for (Plot plot : PlotQuery.newQuery().whereBasePlot()) {
            if (world != null && !plot.getWorldName().equalsIgnoreCase(world) || area != null && !plot.getArea().equals(area) || id != null && !plot.getId().equals(id) || owner != null && !plot.isOwner(owner) || added != null && !plot.isAdded(added)) continue;
            toDelete.addAll(plot.getConnectedPlots());
        }
        if (PlotSquared.get().plots_tmp != null) {
            for (Map.Entry entry : PlotSquared.get().plots_tmp.entrySet()) {
                String worldName = (String)entry.getKey();
                if (world != null && !world.equalsIgnoreCase(worldName)) continue;
                for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                    Plot plot = (Plot)entry2.getValue();
                    if (id != null && !plot.getId().equals(id) || owner != null && !plot.isOwner(owner) || added != null && !plot.isAdded(added)) continue;
                    toDelete.add(plot);
                }
            }
        }
        if (toDelete.isEmpty()) {
            player.sendMessage(TranslatableCaption.of("invalid.found_no_plots"), new Template[0]);
            return false;
        }
        String cmd = "/plot purge " + StringMan.join(args, " ") + " (" + toDelete.size() + " plots)";
        boolean bl2 = clear;
        Runnable run = () -> {
            LOGGER.info("Calculating plots to purge, please wait...");
            final HashSet ids = new HashSet();
            final Iterator iterator = toDelete.iterator();
            final AtomicBoolean cleared = new AtomicBoolean(true);
            Runnable runasync = new Runnable(){

                @Override
                public void run() {
                    while (iterator.hasNext() && cleared.get()) {
                        cleared.set(false);
                        Plot plot = (Plot)iterator.next();
                        if (plot.temp != Integer.MAX_VALUE) {
                            try {
                                ids.add(plot.temp);
                                if (finalClear) {
                                    plot.getPlotModificationManager().clear(false, true, player, () -> LOGGER.info("Plot {} cleared by purge", (Object)plot.getId()));
                                } else {
                                    plot.getPlotModificationManager().removeSign();
                                }
                                plot.getArea().removePlot(plot.getId());
                                for (PlotPlayer<?> pp : plot.getPlayersInPlot()) {
                                    Purge.this.plotListener.plotEntry(pp, plot);
                                }
                            }
                            catch (NullPointerException e) {
                                LOGGER.error("NullPointer during purge detected. This is likely because you are deleting a world that has been removed", (Throwable)e);
                            }
                        }
                        cleared.set(true);
                    }
                    if (iterator.hasNext()) {
                        TaskManager.runTaskAsync(this);
                    } else {
                        TaskManager.runTask(() -> {
                            DBFunc.purgeIds(ids);
                            player.sendMessage(TranslatableCaption.of("purge.purge_success"), Template.template((String)"amount", (String)(ids.size() + "/" + toDelete.size())));
                        });
                    }
                }
            };
            TaskManager.runTaskAsync(runasync);
        };
        if (this.hasConfirmation(player)) {
            CmdConfirm.addPending(player, cmd, run);
        } else {
            run.run();
        }
        return true;
    }
}

