/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(usage="/plot move <X;Z>", command="move", permission="plots.move", category=CommandCategory.CLAIMING, requiredType=RequiredType.PLAYER)
public class Move
extends SubCommand {
    private final PlotAreaManager plotAreaManager;

    @Inject
    public Move(@NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        Plot plot2;
        Location location = player.getLocation();
        Plot plot1 = location.getPlotAbs();
        if (plot1 == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (!plot1.isOwner(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN)) {
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
            return CompletableFuture.completedFuture(false);
        }
        boolean override = false;
        if (args.length == 2 && args[1].equalsIgnoreCase("-f")) {
            args = new String[]{args[0]};
            override = true;
        }
        if (args.length != 1) {
            this.sendUsage(player);
            return CompletableFuture.completedFuture(false);
        }
        PlotArea area = this.plotAreaManager.getPlotAreaByString(args[0]);
        if (area == null) {
            plot2 = Plot.getPlotFromString(player, args[0], true);
            if (plot2 == null) {
                return CompletableFuture.completedFuture(false);
            }
        } else {
            plot2 = area.getPlotAbs(plot1.getId());
        }
        if (plot1.equals(plot2)) {
            player.sendMessage(TranslatableCaption.of("invalid.origin_cant_be_target"), new Template[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (!(plot1.getArea().isCompatible(plot2.getArea()) || override && Permissions.hasPermission(player, Permission.PERMISSION_ADMIN))) {
            player.sendMessage(TranslatableCaption.of("errors.plotworld_incompatible"), new Template[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (plot1.isMerged() || plot2.isMerged()) {
            player.sendMessage(TranslatableCaption.of("move.move_merged"), new Template[0]);
            return CompletableFuture.completedFuture(false);
        }
        return plot1.getPlotModificationManager().move(plot2, player, () -> {}, false).thenApply(result -> {
            if (result.booleanValue()) {
                player.sendMessage(TranslatableCaption.of("move.move_success"), Template.template((String)"origin", (String)plot1.toString()), Template.template((String)"target", (String)plot2.toString()));
                return true;
            }
            player.sendMessage(TranslatableCaption.of("move.requires_unowned"), new Template[0]);
            return false;
        });
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        return true;
    }
}

