/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotMergeEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.PlotExpression;
import com.plotsquared.core.util.StringMan;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.Template;
import net.kyori.adventure.text.minimessage.template.TemplateResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="merge", aliases={"m"}, permission="plots.merge", usage="/plot merge <all | n | e | s | w> [removeroads]", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE, confirmation=true)
public class Merge
extends SubCommand {
    public static final String[] values = new String[]{"north", "east", "south", "west"};
    public static final String[] aliases = new String[]{"n", "e", "s", "w"};
    private final EventDispatcher eventDispatcher;
    private final EconHandler econHandler;

    @Inject
    public Merge(@NonNull EventDispatcher eventDispatcher, @NonNull EconHandler econHandler) {
        this.eventDispatcher = eventDispatcher;
        this.econHandler = econHandler;
    }

    public static String direction(float yaw) {
        int i = Math.round(yaw /= 90.0f);
        return switch (i) {
            case -4, 0, 4 -> "SOUTH";
            case -1, 3 -> "EAST";
            case -2, 2 -> "NORTH";
            case -3, 1 -> "WEST";
            default -> "";
        };
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Location location = player.getLocationFull();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("info.plot_unowned"), new Template[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new Template[0]);
            return false;
        }
        Direction direction = null;
        if (args.length == 0) {
            switch (Merge.direction(player.getLocationFull().getYaw())) {
                case "NORTH": {
                    direction = Direction.NORTH;
                    break;
                }
                case "EAST": {
                    direction = Direction.EAST;
                    break;
                }
                case "SOUTH": {
                    direction = Direction.SOUTH;
                    break;
                }
                case "WEST": {
                    direction = Direction.WEST;
                }
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (!args[0].equalsIgnoreCase(values[i]) && !args[0].equalsIgnoreCase(aliases[i])) continue;
                direction = Direction.getFromIndex(i);
                break;
            }
            if (direction == null && (args[0].equalsIgnoreCase("all") || args[0].equalsIgnoreCase("auto"))) {
                direction = Direction.ALL;
            }
        }
        if (direction == null) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.template((String)"value", (String)("/plot merge <" + StringMan.join(values, " | ") + "> [removeroads]")));
            player.sendMessage(TranslatableCaption.of("help.direction"), Template.template((String)"dir", (String)Merge.direction(location.getYaw())));
            return false;
        }
        int size = plot.getConnectedPlots().size();
        int max = Permissions.hasPermissionRange(player, "plots.merge", Settings.Limit.MAX_PLOTS);
        PlotMergeEvent event = this.eventDispatcher.callMerge(plot, direction, max, player);
        if (event.getEventResult() == Result.DENY) {
            player.sendMessage(TranslatableCaption.of("events.event_denied"), Template.template((String)"value", (String)"Merge"));
            return false;
        }
        boolean force = event.getEventResult() == Result.FORCE;
        direction = event.getDir();
        int maxSize = event.getMax();
        if (!force && size - 1 > maxSize) {
            player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.template((String)"node", (String)(Permission.PERMISSION_MERGE + "." + (size + 1))));
            return false;
        }
        PlotArea plotArea = plot.getArea();
        PlotExpression priceExr = plotArea.getPrices().getOrDefault("merge", null);
        double price = priceExr == null ? 0.0 : priceExr.evaluate(size);
        UUID uuid = player.getUUID();
        if (!force && !plot.isOwner(uuid)) {
            if (!Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_COMMAND_MERGE)) {
                player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
                return false;
            }
            uuid = plot.getOwnerAbs();
        }
        if (direction == Direction.ALL) {
            boolean terrain = true;
            if (args.length == 2) {
                terrain = "true".equalsIgnoreCase(args[1]);
            }
            if (!(force || terrain || Permissions.hasPermission(player, Permission.PERMISSION_MERGE_KEEP_ROAD))) {
                player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.template((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_MERGE_KEEP_ROAD)));
                return true;
            }
            if (plot.getPlotModificationManager().autoMerge(Direction.ALL, maxSize, uuid, player, terrain)) {
                if (this.econHandler.isEnabled(plotArea) && price > 0.0) {
                    this.econHandler.withdrawMoney(player, price);
                    player.sendMessage(TranslatableCaption.of("economy.removed_balance"), Template.template((String)"money", (String)this.econHandler.format(price)), Template.template((String)"balance", (String)this.econHandler.format(this.econHandler.getMoney(player))));
                }
                player.sendMessage(TranslatableCaption.of("merge.success_merge"), new Template[0]);
                this.eventDispatcher.callPostMerge(player, plot);
                return true;
            }
            player.sendMessage(TranslatableCaption.of("merge.no_available_automerge"), new Template[0]);
            return false;
        }
        if (!force && this.econHandler.isEnabled(plotArea) && price > 0.0 && this.econHandler.getMoney(player) < price) {
            player.sendMessage(TranslatableCaption.of("economy.cannot_afford_merge"), Template.template((String)"money", (String)this.econHandler.format(price)));
            return false;
        }
        boolean terrain = args.length == 2 ? "true".equalsIgnoreCase(args[1]) : true;
        if (!(force || terrain || Permissions.hasPermission(player, Permission.PERMISSION_MERGE_KEEP_ROAD))) {
            player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.template((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_MERGE_KEEP_ROAD)));
            return true;
        }
        if (plot.getPlotModificationManager().autoMerge(direction, maxSize - size, uuid, player, terrain)) {
            if (this.econHandler.isEnabled(plotArea) && price > 0.0) {
                this.econHandler.withdrawMoney(player, price);
                player.sendMessage(TranslatableCaption.of("economy.removed_balance"), Template.template((String)"money", (String)this.econHandler.format(price)));
            }
            player.sendMessage(TranslatableCaption.of("merge.success_merge"), new Template[0]);
            this.eventDispatcher.callPostMerge(player, plot);
            return true;
        }
        Plot adjacent = plot.getRelative(direction);
        if (adjacent == null || !adjacent.hasOwner() || adjacent.isMerged((direction.getIndex() + 2) % 4) || !force && adjacent.isOwner(uuid)) {
            player.sendMessage(TranslatableCaption.of("merge.no_available_automerge"), new Template[0]);
            return false;
        }
        if (!force && !Permissions.hasPermission(player, Permission.PERMISSION_MERGE_OTHER)) {
            player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.template((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_MERGE_OTHER)));
            return false;
        }
        Set<UUID> uuids = adjacent.getOwners();
        boolean isOnline = false;
        for (UUID owner : uuids) {
            PlotPlayer<?> accepter = PlotSquared.platform().playerManager().getPlayerIfExists(owner);
            if (!force && accepter == null) continue;
            isOnline = true;
            Direction dir = direction;
            Runnable run = () -> {
                accepter.sendMessage(TranslatableCaption.of("merge.merge_accepted"), new Template[0]);
                plot.getPlotModificationManager().autoMerge(dir, maxSize - size, owner, player, terrain);
                PlotPlayer<?> plotPlayer = PlotSquared.platform().playerManager().getPlayerIfExists(player.getUUID());
                if (plotPlayer == null) {
                    accepter.sendMessage(TranslatableCaption.of("merge.merge_not_valid"), new Template[0]);
                    return;
                }
                if (this.econHandler.isEnabled(plotArea) && price > 0.0) {
                    if (!force && this.econHandler.getMoney(player) < price) {
                        player.sendMessage(TranslatableCaption.of("economy.cannot_afford_merge"), Template.template((String)"money", (String)this.econHandler.format(price)));
                        return;
                    }
                    this.econHandler.withdrawMoney(player, price);
                    player.sendMessage(TranslatableCaption.of("economy.removed_balance"), Template.template((String)"money", (String)this.econHandler.format(price)));
                }
                player.sendMessage(TranslatableCaption.of("merge.success_merge"), new Template[0]);
                this.eventDispatcher.callPostMerge(player, plot);
            };
            if (!force && this.hasConfirmation(player)) {
                CmdConfirm.addPending(accepter, (String)MINI_MESSAGE.serialize(MINI_MESSAGE.deserialize(TranslatableCaption.of("merge.merge_request_confirm").getComponent(player), TemplateResolver.templates((Template[])new Template[]{Template.template((String)"player", (String)player.getName()), Template.template((String)"location", (String)(plot.getWorldName() + ";" + plot.getId()))}))), run);
                continue;
            }
            run.run();
        }
        if (!force && !isOnline) {
            player.sendMessage(TranslatableCaption.of("merge.no_available_automerge"), new Template[0]);
            return false;
        }
        player.sendMessage(TranslatableCaption.of("merge.merge_requested"), new Template[0]);
        return true;
    }
}

