/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Injector;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Add;
import com.plotsquared.core.command.Alias;
import com.plotsquared.core.command.Area;
import com.plotsquared.core.command.Auto;
import com.plotsquared.core.command.Backup;
import com.plotsquared.core.command.Biome;
import com.plotsquared.core.command.Buy;
import com.plotsquared.core.command.Caps;
import com.plotsquared.core.command.Chat;
import com.plotsquared.core.command.Claim;
import com.plotsquared.core.command.Clear;
import com.plotsquared.core.command.Cluster;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.Comment;
import com.plotsquared.core.command.Condense;
import com.plotsquared.core.command.Confirm;
import com.plotsquared.core.command.Continue;
import com.plotsquared.core.command.Copy;
import com.plotsquared.core.command.CreateRoadSchematic;
import com.plotsquared.core.command.DatabaseCommand;
import com.plotsquared.core.command.Debug;
import com.plotsquared.core.command.DebugAllowUnsafe;
import com.plotsquared.core.command.DebugExec;
import com.plotsquared.core.command.DebugImportWorlds;
import com.plotsquared.core.command.DebugLoadTest;
import com.plotsquared.core.command.DebugPaste;
import com.plotsquared.core.command.DebugRoadRegen;
import com.plotsquared.core.command.DebugSaveTest;
import com.plotsquared.core.command.Delete;
import com.plotsquared.core.command.Deny;
import com.plotsquared.core.command.Desc;
import com.plotsquared.core.command.Dislike;
import com.plotsquared.core.command.Done;
import com.plotsquared.core.command.Download;
import com.plotsquared.core.command.FlagCommand;
import com.plotsquared.core.command.Grant;
import com.plotsquared.core.command.Help;
import com.plotsquared.core.command.HomeCommand;
import com.plotsquared.core.command.Inbox;
import com.plotsquared.core.command.Info;
import com.plotsquared.core.command.Kick;
import com.plotsquared.core.command.Leave;
import com.plotsquared.core.command.Like;
import com.plotsquared.core.command.ListCmd;
import com.plotsquared.core.command.Load;
import com.plotsquared.core.command.Merge;
import com.plotsquared.core.command.Middle;
import com.plotsquared.core.command.Move;
import com.plotsquared.core.command.Music;
import com.plotsquared.core.command.Near;
import com.plotsquared.core.command.Owner;
import com.plotsquared.core.command.PluginCmd;
import com.plotsquared.core.command.Purge;
import com.plotsquared.core.command.Rate;
import com.plotsquared.core.command.RegenAllRoads;
import com.plotsquared.core.command.Reload;
import com.plotsquared.core.command.Remove;
import com.plotsquared.core.command.Save;
import com.plotsquared.core.command.SchematicCmd;
import com.plotsquared.core.command.Set;
import com.plotsquared.core.command.SetHome;
import com.plotsquared.core.command.Setup;
import com.plotsquared.core.command.Swap;
import com.plotsquared.core.command.Target;
import com.plotsquared.core.command.Template;
import com.plotsquared.core.command.Toggle;
import com.plotsquared.core.command.Trim;
import com.plotsquared.core.command.Trust;
import com.plotsquared.core.command.Unlink;
import com.plotsquared.core.command.Visit;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.PlotExpression;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@CommandDeclaration(command="plot", aliases={"plots", "p", "plotsquared", "plot2", "p2", "ps", "2", "plotme", "plotz", "ap"})
public class MainCommand
extends Command {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + MainCommand.class.getSimpleName()));
    private static MainCommand instance;
    public Help help;
    public Toggle toggle;

    private MainCommand() {
        super(null, true);
        instance = this;
    }

    public static MainCommand getInstance() {
        if (instance == null) {
            instance = new MainCommand();
            Injector injector = PlotSquared.platform().injector();
            LinkedList<Class<Rate>> commands = new LinkedList<Class<Rate>>();
            commands.add(Caps.class);
            commands.add(Buy.class);
            if (Settings.Web.LEGACY_WEBINTERFACE) {
                LOGGER.warn("Legacy webinterface is used. Please note that it will be removed in future.");
                commands.add(Save.class);
            }
            commands.add(Load.class);
            commands.add(Confirm.class);
            commands.add(Template.class);
            commands.add(Download.class);
            commands.add(Setup.class);
            commands.add(Area.class);
            commands.add(DebugSaveTest.class);
            commands.add(DebugLoadTest.class);
            commands.add(CreateRoadSchematic.class);
            commands.add(DebugAllowUnsafe.class);
            commands.add(RegenAllRoads.class);
            commands.add(Claim.class);
            commands.add(Auto.class);
            commands.add(HomeCommand.class);
            commands.add(Visit.class);
            commands.add(Set.class);
            commands.add(Clear.class);
            commands.add(Delete.class);
            commands.add(Trust.class);
            commands.add(Add.class);
            commands.add(Leave.class);
            commands.add(Deny.class);
            commands.add(Remove.class);
            commands.add(Info.class);
            commands.add(Near.class);
            commands.add(ListCmd.class);
            commands.add(Debug.class);
            commands.add(SchematicCmd.class);
            commands.add(PluginCmd.class);
            commands.add(Purge.class);
            commands.add(Reload.class);
            commands.add(Merge.class);
            commands.add(DebugPaste.class);
            commands.add(Unlink.class);
            commands.add(Kick.class);
            commands.add(Inbox.class);
            commands.add(Comment.class);
            commands.add(DatabaseCommand.class);
            commands.add(Swap.class);
            commands.add(Music.class);
            commands.add(DebugRoadRegen.class);
            commands.add(DebugExec.class);
            commands.add(FlagCommand.class);
            commands.add(Target.class);
            commands.add(Move.class);
            commands.add(Condense.class);
            commands.add(Copy.class);
            commands.add(Chat.class);
            commands.add(Trim.class);
            commands.add(Done.class);
            commands.add(Continue.class);
            commands.add(Middle.class);
            commands.add(Grant.class);
            commands.add(Owner.class);
            commands.add(Desc.class);
            commands.add(Biome.class);
            commands.add(Alias.class);
            commands.add(SetHome.class);
            commands.add(Cluster.class);
            commands.add(DebugImportWorlds.class);
            commands.add(Backup.class);
            if (Settings.Ratings.USE_LIKES) {
                commands.add(Like.class);
                commands.add(Dislike.class);
            } else {
                commands.add(Rate.class);
            }
            for (Class clazz : commands) {
                try {
                    injector.getInstance(clazz);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to register command {}", (Object)clazz.getCanonicalName());
                    e.printStackTrace();
                }
            }
            MainCommand.instance.toggle = (Toggle)injector.getInstance(Toggle.class);
            MainCommand.instance.help = new Help(instance);
        }
        return instance;
    }

    public static boolean onCommand(final PlotPlayer<?> player, String ... args) {
        String[] split2;
        final EconHandler econHandler = PlotSquared.platform().econHandler();
        if (args.length >= 1 && args[0].contains(":") && (split2 = args[0].split(":")).length == 2) {
            String[] tmp = new String[args.length + 1];
            tmp[0] = split2[0];
            tmp[args.length] = split2[1];
            if (args.length >= 2) {
                System.arraycopy(args, 1, tmp, 1, args.length - 1);
            }
            args = tmp;
        }
        try {
            MainCommand.getInstance().execute(player, args, new RunnableVal3<Command, Runnable, Runnable>(){

                @Override
                public void run(Command cmd, Runnable success, Runnable failure) {
                    if (cmd.hasConfirmation(player)) {
                        CmdConfirm.addPending(player, cmd.getUsage(), () -> {
                            PlotArea area = player.getApplicablePlotArea();
                            if (area != null && econHandler.isEnabled(area)) {
                                double price;
                                PlotExpression priceEval = area.getPrices().get(cmd.getFullId());
                                double d = price = priceEval != null ? priceEval.evaluate(0.0) : 0.0;
                                if (econHandler.getMoney(player) < price) {
                                    if (failure != null) {
                                        failure.run();
                                    }
                                    return;
                                }
                            }
                            if (success != null) {
                                success.run();
                            }
                        });
                        return;
                    }
                    PlotArea area = player.getApplicablePlotArea();
                    if (area != null && econHandler.isEnabled(area)) {
                        double price;
                        PlotExpression priceEval = area.getPrices().get(cmd.getFullId());
                        double d = price = priceEval != null ? priceEval.evaluate(0.0) : 0.0;
                        if (price != 0.0 && econHandler.getMoney(player) < price) {
                            if (failure != null) {
                                failure.run();
                            }
                            return;
                        }
                    }
                    if (success != null) {
                        success.run();
                    }
                }
            }, new RunnableVal2<Command, Command.CommandResult>(){

                @Override
                public void run(Command cmd, Command.CommandResult result) {
                }
            }).thenAccept(result -> {});
        }
        catch (Command.CommandException e) {
            e.perform(player);
        }
        return true;
    }

    @Override
    public CompletableFuture<Boolean> execute(final PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        Location location = null;
        Plot plot = null;
        boolean tp = false;
        if (args.length >= 2) {
            final PlotArea area = player.getApplicablePlotArea();
            Plot newPlot = Plot.fromString(area, args[0]);
            if (newPlot != null && (player instanceof ConsolePlayer || newPlot.getArea().equals(area) || Permissions.hasPermission(player, Permission.PERMISSION_ADMIN) || Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_AREA_SUDO)) && !newPlot.isDenied(player.getUUID())) {
                Location newLoc = newPlot.getArea() instanceof SinglePlotArea ? (newPlot.isLoaded() ? newPlot.getCenterSynchronous() : Location.at("", 0, 0, 0)) : newPlot.getCenterSynchronous();
                if (player.canTeleport(newLoc)) {
                    try (MetaDataAccess<Location> locationMetaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);){
                        location = locationMetaDataAccess.get().orElse(null);
                        locationMetaDataAccess.set(newLoc);
                    }
                    try (MetaDataAccess<Plot> plotMetaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                        plot = plotMetaDataAccess.get().orElse(null);
                        plotMetaDataAccess.set(newPlot);
                    }
                    tp = true;
                } else {
                    player.sendMessage(TranslatableCaption.of("border.denied"), new net.kyori.adventure.text.minimessage.Template[0]);
                }
                args = Arrays.copyOfRange(args, 1, args.length);
            }
            if (args.length >= 2 && !args[0].isEmpty() && args[0].charAt(0) == '-') {
                if ("f".equals(args[0].substring(1))) {
                    confirm = new RunnableVal3<Command, Runnable, Runnable>(){

                        @Override
                        public void run(Command cmd, Runnable success, Runnable failure) {
                            if (area != null && PlotSquared.platform().econHandler().isEnabled(area)) {
                                double price;
                                PlotExpression priceEval = area.getPrices().get(cmd.getFullId());
                                double d = price = priceEval != null ? priceEval.evaluate(0.0) : 0.0;
                                if (price != 0.0 && PlotSquared.platform().econHandler().getMoney(player) < price) {
                                    if (failure != null) {
                                        failure.run();
                                    }
                                    return;
                                }
                            }
                            if (success != null) {
                                success.run();
                            }
                        }
                    };
                    args = Arrays.copyOfRange(args, 1, args.length);
                } else {
                    player.sendMessage(TranslatableCaption.of("errors.invalid_command_flag"), new net.kyori.adventure.text.minimessage.Template[0]);
                    return CompletableFuture.completedFuture(false);
                }
            }
        }
        try {
            super.execute(player, args, confirm, whenDone);
        }
        catch (Command.CommandException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            String message = e.getMessage();
            if (message != null) {
                player.sendMessage(TranslatableCaption.of("errors.error"), net.kyori.adventure.text.minimessage.Template.template((String)"value", (String)message));
            }
            player.sendMessage(TranslatableCaption.of("errors.error_console"), new net.kyori.adventure.text.minimessage.Template[0]);
        }
        if (tp && !(player instanceof ConsolePlayer)) {
            try (MetaDataAccess<Location> locationMetaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);){
                if (location == null) {
                    locationMetaDataAccess.remove();
                } else {
                    locationMetaDataAccess.set(location);
                }
            }
            try (MetaDataAccess<Plot> plotMetaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                if (plot == null) {
                    plotMetaDataAccess.remove();
                } else {
                    plotMetaDataAccess.set(plot);
                }
            }
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public boolean canExecute(PlotPlayer<?> player, boolean message) {
        return true;
    }
}

