/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SetCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DescriptionFlag;
import com.plotsquared.core.util.EventDispatcher;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="setdescription", permission="plots.set.desc", usage="/plot desc <description>", aliases={"desc", "setdesc", "setd", "description"}, category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER)
public class Desc
extends SetCommand {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Desc(@NonNull EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public boolean set(PlotPlayer<?> player, Plot plot, String desc) {
        if (desc.isEmpty()) {
            PlotFlagRemoveEvent event = this.eventDispatcher.callFlagRemove(plot.getFlagContainer().getFlag(DescriptionFlag.class), plot);
            if (event.getEventResult() == Result.DENY) {
                player.sendMessage(TranslatableCaption.of("events.event_denied"), Template.template((String)"value", (String)"Description removal"));
                return false;
            }
            plot.removeFlag(event.getFlag());
            player.sendMessage(TranslatableCaption.of("desc.desc_unset"), new Template[0]);
            return true;
        }
        PlotFlagAddEvent event = this.eventDispatcher.callFlagAdd((PlotFlag<?, ?>)plot.getFlagContainer().getFlag(DescriptionFlag.class).createFlagInstance(desc), plot);
        if (event.getEventResult() == Result.DENY) {
            player.sendMessage(TranslatableCaption.of("events.event_denied"), Template.template((String)"value", (String)"Description set"));
            return false;
        }
        boolean result = plot.setFlag(event.getFlag());
        if (!result) {
            player.sendMessage(TranslatableCaption.of("flag.flag_not_added"), new Template[0]);
            return false;
        }
        player.sendMessage(TranslatableCaption.of("desc.desc_set"), new Template[0]);
        return true;
    }
}

