/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.database.MySQL;
import com.plotsquared.core.database.SQLManager;
import com.plotsquared.core.database.SQLite;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.TaskManager;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="database", aliases={"convert"}, category=CommandCategory.ADMINISTRATION, permission="plots.database", requiredType=RequiredType.CONSOLE, usage="/plot database [area] <sqlite | mysql | import>")
public class DatabaseCommand
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private final PlotListener plotListener;
    private final YamlConfiguration worldConfiguration;

    @Inject
    public DatabaseCommand(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull PlotListener plotListener, @WorldConfig @NonNull YamlConfiguration worldConfiguration) {
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
        this.plotListener = plotListener;
        this.worldConfiguration = worldConfiguration;
    }

    public static void insertPlots(SQLManager manager, List<Plot> plots, PlotPlayer<?> player) {
        TaskManager.runTaskAsync(() -> {
            try {
                ArrayList<Plot> ps = new ArrayList<Plot>(plots);
                player.sendMessage(TranslatableCaption.of("database.starting_conversion"), new Template[0]);
                manager.createPlotsAndData(ps, () -> {
                    player.sendMessage(TranslatableCaption.of("database.conversion_done"), new Template[0]);
                    manager.close();
                });
            }
            catch (Exception e) {
                player.sendMessage(TranslatableCaption.of("database.conversion_failed"), new Template[0]);
                e.printStackTrace();
            }
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        if (args.length < 1) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new Template[]{Template.template((String)"value", (String)"/plot database [area] <sqlite | mysql | import>")});
            return false;
        }
        area = this.plotAreaManager.getPlotAreaByString(args[0]);
        if (area != null) {
            plots = PlotSquared.get().sortPlotsByTemp(area.getPlots());
            args = Arrays.copyOfRange(args, 1, args.length);
        } else {
            plots = PlotSquared.get().sortPlotsByTemp(PlotQuery.newQuery().allPlots().asList());
        }
        if (args.length < 1) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new Template[]{Template.template((String)"value", (String)"/plot database [area] <sqlite|mysql|import>")});
            player.sendMessage(TranslatableCaption.of("database.arg"), new Template[0]);
            return false;
        }
        prefix = "";
        var7_6 = args[0].toLowerCase();
        var8_8 = -1;
        switch (var7_6.hashCode()) {
            case -1184795739: {
                if (!var7_6.equals("import")) break;
                var8_8 = 0;
                break;
            }
            case 104382626: {
                if (!var7_6.equals("mysql")) break;
                var8_8 = 1;
                break;
            }
            case -894935028: {
                if (!var7_6.equals("sqlite")) break;
                var8_8 = 2;
            }
        }
        switch (var8_8) {
            case 0: {
                if (args.length < 2) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), new Template[]{Template.template((String)"value", (String)"/plot database import <sqlite file> [prefix]")});
                    return false;
                }
                file = FileUtils.getFile(PlotSquared.platform().getDirectory(), (String)(args[1].endsWith(".db") != false ? args[1] : args[1] + ".db"));
                if (!file.exists()) {
                    player.sendMessage(TranslatableCaption.of("database.does_not_exist"), new Template[]{Template.template((String)"value", (String)String.valueOf(file))});
                    return false;
                }
                player.sendMessage(TranslatableCaption.of("database.starting_conversion"), new Template[0]);
                implementation = new SQLite(file);
                manager = new SQLManager(implementation, args.length == 3 ? args[2] : "", this.eventDispatcher, this.plotListener, this.worldConfiguration);
                map = manager.getPlots();
                plots = new ArrayList<Plot>();
                for (Map.Entry<String, HashMap<PlotId, Plot>> entry : map.entrySet()) {
                    areaName = entry.getKey();
                    pa = this.plotAreaManager.getPlotAreaByString(areaName);
                    if (pa != null) {
                        for (Map.Entry<PlotId, Plot> entry2 : entry.getValue().entrySet()) {
                            plot = entry2.getValue();
                            if (pa.getOwnedPlotAbs(plot.getId()) != null) {
                                if (pa instanceof SinglePlotArea && (newPlot = pa.getNextFreePlot(null, plot.getId())) != null) {
                                    newId = newPlot.getId();
                                    id = plot.getId();
                                    worldFile = new File(PlotSquared.platform().worldContainer(), id.toCommaSeparatedString());
                                    if (worldFile.exists()) {
                                        newFile = new File(PlotSquared.platform().worldContainer(), newId.toCommaSeparatedString());
                                        worldFile.renameTo(newFile);
                                    }
                                    plot.setId(newId.copy());
                                    plot.setArea(pa);
                                    plots.add(plot);
                                    continue;
                                }
                                player.sendMessage(TranslatableCaption.of("database.skipping_duplicated_plot"), new Template[]{Template.template((String)"plot", (String)String.valueOf(plot)), Template.template((String)"id", (String)String.valueOf(plot.temp))});
                                continue;
                            }
                            plot.setArea(pa);
                            plots.add(plot);
                        }
                        continue;
                    }
                    plotMap = PlotSquared.get().plots_tmp.computeIfAbsent(areaName, (Function<String, HashMap>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onCommand$2(java.lang.String ), (Ljava/lang/String;)Ljava/util/HashMap;)());
                    plotMap.putAll((Map)entry.getValue());
                }
                DBFunc.createPlotsAndData(plots, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onCommand$3(com.plotsquared.core.player.PlotPlayer ), ()V)(player));
                return true;
            }
            case 1: {
                if (args.length < 6) {
                    player.sendMessage(StaticCaption.of("/plot database mysql [host] [port] [username] [password] [database] {prefix}"), new Template[0]);
                    return false;
                }
                host = args[1];
                port = args[2];
                username = args[3];
                password = args[4];
                database = args[5];
                if (args.length > 6) {
                    prefix = args[6];
                }
                implementation /* !! */  = new MySQL(host, port, database, username, password);
                ** break;
            }
            case 2: {
                if (args.length < 2) {
                    player.sendMessage(StaticCaption.of("/plot database sqlite [file]"), new Template[0]);
                    return false;
                }
                sqliteFile = FileUtils.getFile(PlotSquared.platform().getDirectory(), args[1] + ".db");
                implementation /* !! */  = new SQLite(sqliteFile);
                ** break;
            }
            default: {
                player.sendMessage(StaticCaption.of("/plot database [sqlite/mysql]"), new Template[0]);
                return false;
lbl99:
                // 2 sources

                break;
            }
        }
        try {
            manager = new SQLManager(implementation /* !! */ , prefix, this.eventDispatcher, this.plotListener, this.worldConfiguration);
            DatabaseCommand.insertPlots(manager, plots, player);
            return true;
        }
        catch (ClassNotFoundException | SQLException e) {
            try {
                player.sendMessage(TranslatableCaption.of("database.failed_to_save_plots"), new Template[0]);
                player.sendMessage(TranslatableCaption.of("errors.stacktrace_begin"), new Template[0]);
                e.printStackTrace();
                player.sendMessage(TranslatableCaption.of("errors.stacktrace_end"), new Template[0]);
                player.sendMessage(TranslatableCaption.of("database.invalid_args"), new Template[0]);
                return false;
            }
            catch (ClassNotFoundException | SQLException e) {
                player.sendMessage(TranslatableCaption.of("database.failed_to_open"), new Template[0]);
                player.sendMessage(TranslatableCaption.of("errors.stacktrace_begin"), new Template[0]);
                e.printStackTrace();
                player.sendMessage(TranslatableCaption.of("errors.stacktrace_end"), new Template[0]);
                player.sendMessage(TranslatableCaption.of("database.invalid_args"), new Template[0]);
                return false;
            }
        }
    }

    private static /* synthetic */ void lambda$onCommand$3(PlotPlayer player) {
        player.sendMessage(TranslatableCaption.of("database.conversion_done"), new Template[0]);
    }

    private static /* synthetic */ HashMap lambda$onCommand$2(String k) {
        return new HashMap();
    }
}

