/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.Permissions;
import net.kyori.adventure.text.minimessage.Template;

@CommandDeclaration(command="copy", permission="plots.copy", aliases={"copypaste"}, category=CommandCategory.CLAIMING, usage="/plot copy <X;Z>", requiredType=RequiredType.NONE)
public class Copy
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Location location = player.getLocation();
        Plot plot1 = location.getPlotAbs();
        if (plot1 == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (!plot1.isOwner(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN.toString())) {
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
            return false;
        }
        if (args.length != 1) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.template((String)"value", (String)"/plot copy <X;Z>"));
            return false;
        }
        Plot plot2 = Plot.getPlotFromString(player, args[0], true);
        if (plot2 == null) {
            return false;
        }
        if (plot1.equals(plot2)) {
            player.sendMessage(TranslatableCaption.of("invalid.origin_cant_be_target"), new Template[0]);
            return false;
        }
        if (!plot1.getArea().isCompatible(plot2.getArea())) {
            player.sendMessage(TranslatableCaption.of("errors.plotworld_incompatible"), new Template[0]);
            return false;
        }
        plot1.getPlotModificationManager().copy(plot2, player).thenAccept(result -> {
            if (result.booleanValue()) {
                player.sendMessage(TranslatableCaption.of("move.copy_success"), Template.template((String)"origin", (String)String.valueOf(plot1)), Template.template((String)"target", (String)String.valueOf(plot2)));
            } else {
                player.sendMessage(TranslatableCaption.of("move.requires_unowned"), new Template[0]);
            }
        });
        return true;
    }
}

