/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.Permissions;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="continue", permission="plots.continue", category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER)
public class Continue
extends SubCommand {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Continue(@NonNull EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Plot plot = player.getCurrentPlot();
        if (plot == null || !plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (!plot.isOwner(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_COMMAND_CONTINUE)) {
            player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.template((String)"node", (String)TranslatableCaption.of("permission.no_plot_perms").getComponent(player)));
            return false;
        }
        if (!DoneFlag.isDone(plot)) {
            player.sendMessage(TranslatableCaption.of("done.done_not_done"), new Template[0]);
            return false;
        }
        int size = plot.getConnectedPlots().size();
        if (Settings.Done.COUNTS_TOWARDS_LIMIT && player.getAllowedPlots() < player.getPlotCount() + size) {
            player.sendMessage(TranslatableCaption.of("permission.cant_claim_more_plots"), Template.template((String)"amount", (String)String.valueOf(player.getAllowedPlots())));
            return false;
        }
        if (plot.getRunning() > 0) {
            player.sendMessage(TranslatableCaption.of("errors.wait_for_timer"), new Template[0]);
            return false;
        }
        DoneFlag plotFlag = plot.getFlagContainer().getFlag(DoneFlag.class);
        PlotFlagRemoveEvent event = this.eventDispatcher.callFlagRemove(plotFlag, plot);
        if (event.getEventResult() == Result.DENY) {
            player.sendMessage(TranslatableCaption.of("events.event_denied"), Template.template((String)"value", (String)"Done flag removal"));
            return true;
        }
        plot.removeFlag(event.getFlag());
        player.sendMessage(TranslatableCaption.of("done.done_removed"), new Template[0]);
        return true;
    }
}

