/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.comment.CommentInbox;
import com.plotsquared.core.plot.comment.CommentManager;
import com.plotsquared.core.plot.comment.PlotComment;
import com.plotsquared.core.util.StringMan;
import java.util.Arrays;
import java.util.Locale;
import net.kyori.adventure.text.minimessage.Template;

@CommandDeclaration(command="comment", aliases={"msg"}, category=CommandCategory.CHAT, requiredType=RequiredType.PLAYER, permission="plots.comment")
public class Comment
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        int index;
        if (args.length < 2) {
            player.sendMessage(TranslatableCaption.of("comment.comment_syntax"), Template.template((String)"command", (String)"/plot comment [X;Z]"), Template.template((String)"list", (String)StringMan.join(CommentManager.inboxes.keySet(), "|")));
            return false;
        }
        Plot plot = null;
        if (!CommentManager.inboxes.containsKey(args[0].toLowerCase(Locale.ENGLISH))) {
            plot = Plot.getPlotFromString(player, args[0], false);
        }
        if (plot == null) {
            index = 1;
            plot = player.getLocation().getPlotAbs();
        } else {
            if (args.length < 3) {
                player.sendMessage(TranslatableCaption.of("comment.comment_syntax"), Template.template((String)"command", (String)"/plot comment [X;Z]"), Template.template((String)"list", (String)StringMan.join(CommentManager.inboxes.keySet(), "|")));
                return false;
            }
            index = 2;
        }
        CommentInbox inbox = CommentManager.inboxes.get(args[index - 1].toLowerCase());
        if (inbox == null) {
            player.sendMessage(TranslatableCaption.of("comment.comment_syntax"), Template.template((String)"command", (String)"/plot comment [X;Z]"), Template.template((String)"list", (String)StringMan.join(CommentManager.inboxes.keySet(), "|")));
            return false;
        }
        if (!inbox.canWrite(plot, player)) {
            player.sendMessage(TranslatableCaption.of("comment.no_perm_inbox"), new Template[0]);
            return false;
        }
        String message = StringMan.join(Arrays.copyOfRange(args, index, args.length), " ");
        PlotComment comment = new PlotComment(player.getLocation().getWorldName(), plot.getId(), message, player.getName(), inbox.toString(), System.currentTimeMillis());
        boolean result = inbox.addComment(plot, comment);
        if (!result) {
            player.sendMessage(TranslatableCaption.of("comment.no_plot_inbox"), new Template[0]);
            player.sendMessage(TranslatableCaption.of("comment.comment_syntax"), Template.template((String)"command", (String)"/plot comment [X;Z]"), Template.template((String)"list", (String)StringMan.join(CommentManager.inboxes.keySet(), "|")));
            return false;
        }
        for (PlotPlayer<?> pp : PlotSquared.platform().playerManager().getPlayers()) {
            if (!pp.getAttribute("chatspy")) continue;
            pp.sendMessage(StaticCaption.of("/plot comment " + StringMan.join(args, " ")), new Template[0]);
        }
        player.sendMessage(TranslatableCaption.of("comment.comment_added"), new Template[0]);
        return true;
    }
}

