/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.AnimalCapFlag;
import com.plotsquared.core.plot.flag.implementations.EntityCapFlag;
import com.plotsquared.core.plot.flag.implementations.HostileCapFlag;
import com.plotsquared.core.plot.flag.implementations.MiscCapFlag;
import com.plotsquared.core.plot.flag.implementations.MobCapFlag;
import com.plotsquared.core.plot.flag.implementations.VehicleCapFlag;
import com.plotsquared.core.util.Permissions;
import net.kyori.adventure.text.minimessage.Template;

@CommandDeclaration(command="caps", category=CommandCategory.INFO, usage="/plot caps")
public class Caps
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Plot plot = player.getCurrentPlot();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (!plot.isAdded(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_CAPS_OTHER)) {
            player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.template((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_ADMIN_CAPS_OTHER)));
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new Template[0]);
            return false;
        }
        player.sendMessage(TranslatableCaption.of("info.plot_caps_header"), new Template[0]);
        int[] countedEntities = plot.countEntities();
        this.sendFormatted(plot, player, MobCapFlag.class, countedEntities, "mobs", 3);
        this.sendFormatted(plot, player, HostileCapFlag.class, countedEntities, "hostile", 2);
        this.sendFormatted(plot, player, AnimalCapFlag.class, countedEntities, "animals", 1);
        this.sendFormatted(plot, player, VehicleCapFlag.class, countedEntities, "vehicle", 4);
        this.sendFormatted(plot, player, MiscCapFlag.class, countedEntities, "misc", 5);
        this.sendFormatted(plot, player, EntityCapFlag.class, countedEntities, "entities", 0);
        return true;
    }

    private <T extends PlotFlag<Integer, T>> void sendFormatted(Plot plot, PlotPlayer<?> player, Class<T> capFlag, int[] countedEntities, String name, int type) {
        int current = countedEntities[type];
        int max = (Integer)plot.getFlag(capFlag);
        String percentage = String.format("%.1f", Float.valueOf(100.0f * ((float)current / (float)max)));
        String maxBeautified = max >= Integer.MAX_VALUE ? TranslatableCaption.of("info.infinite").getComponent(player) : String.valueOf(max);
        player.sendMessage(TranslatableCaption.of("info.plot_caps_format"), Template.template((String)"cap", (String)name), Template.template((String)"current", (String)String.valueOf(current)), Template.template((String)"limit", (String)maxBeautified), Template.template((String)"percentage", (String)percentage));
    }
}

