/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="add", usage="/plot add <player | *>", category=CommandCategory.SETTINGS, permission="plots.add", requiredType=RequiredType.PLAYER)
public class Add
extends Command {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Add(@NonNull EventDispatcher eventDispatcher) {
        super(MainCommand.getInstance(), true);
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) throws Command.CommandException {
        Plot plot = this.check(player.getCurrentPlot(), TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
        this.checkTrue(plot.hasOwner(), TranslatableCaption.of("info.plot_unowned"), new Template[0]);
        this.checkTrue(plot.isOwner(player.getUUID()) || Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_COMMAND_TRUST), TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
        this.checkTrue(args.length == 1, TranslatableCaption.of("commandconfig.command_syntax"), Template.template((String)"value", (String)"/plot add <player | *>"));
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        PlayerManager.getUUIDsFromString(args[0], (uuids, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof TimeoutException) {
                    player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new Template[0]);
                } else {
                    player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.template((String)"value", (String)args[0]));
                }
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            try {
                this.checkTrue(!uuids.isEmpty(), TranslatableCaption.of("errors.invalid_player"), Template.template((String)"value", (String)args[0]));
                Iterator iterator = uuids.iterator();
                int size = plot.getTrusted().size() + plot.getMembers().size();
                while (iterator.hasNext()) {
                    UUID uuid = (UUID)iterator.next();
                    if (uuid == DBFunc.EVERYONE && !Permissions.hasPermission((PermissionHolder)player, Permission.PERMISSION_TRUST_EVERYONE) && !Permissions.hasPermission((PermissionHolder)player, Permission.PERMISSION_ADMIN_COMMAND_TRUST)) {
                        player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.template((String)"value", (String)PlayerManager.getName(uuid)));
                        iterator.remove();
                        continue;
                    }
                    if (plot.isOwner(uuid)) {
                        player.sendMessage(TranslatableCaption.of("member.already_added"), Template.template((String)"player", (String)PlayerManager.getName(uuid)));
                        iterator.remove();
                        continue;
                    }
                    if (plot.getMembers().contains(uuid)) {
                        player.sendMessage(TranslatableCaption.of("member.already_added"), Template.template((String)"player", (String)PlayerManager.getName(uuid)));
                        iterator.remove();
                        continue;
                    }
                    size += plot.getTrusted().contains(uuid) ? 0 : 1;
                }
                this.checkTrue(!uuids.isEmpty(), null, new Template[0]);
                int localAddSize = plot.getMembers().size();
                int maxAddSize = Permissions.hasPermissionRange(player, Permission.PERMISSION_ADD, Settings.Limit.MAX_PLOTS);
                if (localAddSize >= maxAddSize) {
                    player.sendMessage(TranslatableCaption.of("members.plot_max_members_added"), Template.template((String)"amount", (String)String.valueOf(localAddSize)));
                    return;
                }
                confirm.run(this, () -> {
                    for (UUID uuid : uuids) {
                        if (uuid != DBFunc.EVERYONE && !plot.removeTrusted(uuid) && plot.getDenied().contains(uuid)) {
                            plot.removeDenied(uuid);
                        }
                        plot.addMember(uuid);
                        this.eventDispatcher.callMember(player, plot, uuid, true);
                        player.sendMessage(TranslatableCaption.of("member.member_added"), new Template[0]);
                    }
                }, null);
            }
            catch (Throwable exception) {
                future.completeExceptionally(exception);
                return;
            }
            future.complete(true);
        });
        return future;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }
}

