/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.NoWorldeditFlag;
import com.plotsquared.core.util.RegionUtil;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class WEManager {
    private static final BlockVector3 MIN = BlockVector3.at((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
    private static final BlockVector3 MAX = BlockVector3.at((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);

    public static boolean maskContains(Set<CuboidRegion> mask, int x, int y, int z) {
        for (CuboidRegion region : mask) {
            if (!RegionUtil.contains(region, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public static boolean maskContains(Set<CuboidRegion> mask, int x, int z) {
        for (CuboidRegion region : mask) {
            if (!RegionUtil.contains(region, x, z)) continue;
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="6.11.1")
    public static boolean maskContains(Set<CuboidRegion> mask, double dx, double dy, double dz) {
        int x = Math.toIntExact(Math.round(dx >= 0.0 ? dx - 0.5 : dx + 0.5));
        int y = Math.toIntExact(Math.round(dy - 0.5));
        int z = Math.toIntExact(Math.round(dz >= 0.0 ? dz - 0.5 : dz + 0.5));
        for (CuboidRegion region : mask) {
            if (!RegionUtil.contains(region, x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="6.11.1")
    public static boolean maskContains(Set<CuboidRegion> mask, double dx, double dz) {
        int x = Math.toIntExact(Math.round(dx >= 0.0 ? dx - 0.5 : dx + 0.5));
        int z = Math.toIntExact(Math.round(dz >= 0.0 ? dz - 0.5 : dz + 0.5));
        for (CuboidRegion region : mask) {
            if (!RegionUtil.contains(region, x, z)) continue;
            return true;
        }
        return false;
    }

    public static HashSet<CuboidRegion> getMask(PlotPlayer<?> player) {
        HashSet<CuboidRegion> regions = new HashSet<CuboidRegion>();
        UUID uuid = player.getUUID();
        Location location = player.getLocation();
        String world = location.getWorldName();
        if (!PlotSquared.get().getPlotAreaManager().hasPlotArea(world)) {
            regions.add(new CuboidRegion(MIN, MAX));
            return regions;
        }
        PlotArea area = player.getApplicablePlotArea();
        if (area == null) {
            return regions;
        }
        boolean allowMember = player.hasPermission("plots.worldedit.member");
        Plot plot = player.getCurrentPlot();
        try (MetaDataAccess<Plot> metaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_WORLD_EDIT_REGION_PLOT);){
            if (plot == null) {
                plot = metaDataAccess.get().orElse(null);
            }
            if (!(plot == null || Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone(plot) || !(allowMember && plot.isAdded(uuid) || !allowMember && plot.isOwner(uuid)) && !plot.getTrusted().contains(uuid) || ((Boolean)plot.getFlag(NoWorldeditFlag.class)).booleanValue())) {
                for (CuboidRegion region : plot.getRegions()) {
                    BlockVector3 pos1 = region.getMinimumPoint().withY(area.getMinBuildHeight());
                    BlockVector3 pos2 = region.getMaximumPoint().withY(area.getMaxBuildHeight() - 1);
                    CuboidRegion copy = new CuboidRegion(pos1, pos2);
                    regions.add(copy);
                }
                metaDataAccess.set(plot);
            }
        }
        return regions;
    }

    @Deprecated(forRemoval=true, since="6.11.1")
    public static boolean intersects(CuboidRegion region1, CuboidRegion region2) {
        return RegionUtil.intersects(region1, region2);
    }

    @Deprecated(forRemoval=true, since="6.11.1")
    public static boolean regionContains(CuboidRegion selection, HashSet<CuboidRegion> mask) {
        for (CuboidRegion region : mask) {
            if (!WEManager.intersects(region, selection)) continue;
            return true;
        }
        return false;
    }
}

