/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.location.Location;
import com.sk89q.worldedit.math.BlockVector2;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ChunkUtil {
    private static final short[] x_loc = new short[4096];
    private static final short[] y_loc = new short[4096];
    private static final short[] z_loc = new short[4096];
    private static final short[][][] CACHE_J;

    private ChunkUtil() {
    }

    public static int getJ(int x, int y, int z) {
        return CACHE_J[y & 0xF][x & 0xF][z & 0xF];
    }

    public static int getX(int j) {
        return x_loc[j];
    }

    public static int getY(int i, int j) {
        return (i << 4) + y_loc[j];
    }

    public static int getZ(int j) {
        return z_loc[j];
    }

    @Deprecated(forRemoval=true, since="6.11.1")
    public static boolean isWholeChunk(@NonNull Location pos1, @NonNull Location pos2, @NonNull BlockVector2 chunk) {
        int x1 = pos1.getX();
        int z1 = pos1.getZ();
        int x2 = pos2.getX();
        int z2 = pos2.getZ();
        int cx = chunk.getX() << 4;
        int cz = chunk.getZ() << 4;
        return cx > x1 && cz > z1 && cx < x2 && cz < z2;
    }

    static {
        for (int j = 0; j < 4096; ++j) {
            int y = j >> 8;
            int a = j - ((y & 0xF) << 8);
            int z1 = a >> 4;
            int x1 = a - (z1 << 4);
            ChunkUtil.x_loc[j] = (short)x1;
            ChunkUtil.y_loc[j] = (short)y;
            ChunkUtil.z_loc[j] = (short)z1;
        }
        CACHE_J = new short[16][16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    short j;
                    ChunkUtil.CACHE_J[y][x][z] = j = (short)((y & 0xF) << 8 | z << 4 | x);
                }
            }
        }
    }
}

