/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.ClassicPlotManagerComponent;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.generator.SquarePlotManager;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.BlockBucket;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.task.TaskManager;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassicPlotManager
extends SquarePlotManager {
    private final ClassicPlotWorld classicPlotWorld;
    private final RegionManager regionManager;
    private final ProgressSubscriberFactory subscriberFactory;

    @Inject
    public ClassicPlotManager(@NonNull ClassicPlotWorld classicPlotWorld, @NonNull RegionManager regionManager) {
        super(classicPlotWorld, regionManager);
        this.classicPlotWorld = classicPlotWorld;
        this.regionManager = regionManager;
        this.subscriberFactory = (ProgressSubscriberFactory)PlotSquared.platform().injector().getInstance(ProgressSubscriberFactory.class);
    }

    @Override
    public boolean setComponent(@NonNull PlotId plotId, @NonNull String component, @NonNull Pattern blocks, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        Optional<ClassicPlotManagerComponent> componentOptional = ClassicPlotManagerComponent.fromString(component);
        return componentOptional.map(classicPlotManagerComponent -> switch (classicPlotManagerComponent) {
            default -> throw new IncompatibleClassChangeError();
            case ClassicPlotManagerComponent.FLOOR -> this.setFloor(plotId, blocks, actor, queue);
            case ClassicPlotManagerComponent.WALL -> this.setWallFilling(plotId, blocks, actor, queue);
            case ClassicPlotManagerComponent.AIR -> this.setAir(plotId, blocks, actor, queue);
            case ClassicPlotManagerComponent.MAIN -> this.setMain(plotId, blocks, actor, queue);
            case ClassicPlotManagerComponent.MIDDLE -> this.setMiddle(plotId, blocks, queue);
            case ClassicPlotManagerComponent.OUTLINE -> this.setOutline(plotId, blocks, actor, queue);
            case ClassicPlotManagerComponent.BORDER -> this.setWall(plotId, blocks, actor, queue);
            case ClassicPlotManagerComponent.ALL -> this.setAll(plotId, blocks, actor, queue);
        }).orElse(false);
    }

    @Override
    public boolean unClaimPlot(@NonNull Plot plot, @Nullable Runnable whenDone, @Nullable QueueCoordinator queue) {
        this.setWallFilling(plot.getId(), this.classicPlotWorld.WALL_FILLING.toPattern(), null, queue);
        if (!(!this.classicPlotWorld.PLACE_TOP_BLOCK || this.classicPlotWorld.WALL_BLOCK.isAir() && this.classicPlotWorld.WALL_BLOCK.equals(this.classicPlotWorld.CLAIMED_WALL_BLOCK))) {
            this.setWall(plot.getId(), this.classicPlotWorld.WALL_BLOCK.toPattern(), null, queue);
        }
        TaskManager.runTask(whenDone);
        return true;
    }

    public boolean setFloor(@NonNull PlotId plotId, @NonNull Pattern blocks, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot != null && plot.isBasePlot()) {
            return this.regionManager.setCuboids(this.classicPlotWorld, plot.getRegions(), blocks, this.classicPlotWorld.PLOT_HEIGHT, this.classicPlotWorld.PLOT_HEIGHT, actor, queue);
        }
        return false;
    }

    public boolean setAll(@NonNull PlotId plotId, @NonNull Pattern blocks, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot != null && plot.isBasePlot()) {
            return this.regionManager.setCuboids(this.classicPlotWorld, plot.getRegions(), blocks, this.classicPlotWorld.getMinBuildHeight(), this.classicPlotWorld.getMaxBuildHeight() - 1, actor, queue);
        }
        return false;
    }

    public boolean setAir(@NonNull PlotId plotId, @NonNull Pattern blocks, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot != null && plot.isBasePlot()) {
            return this.regionManager.setCuboids(this.classicPlotWorld, plot.getRegions(), blocks, this.classicPlotWorld.PLOT_HEIGHT + 1, this.classicPlotWorld.getMaxBuildHeight() - 1, actor, queue);
        }
        return false;
    }

    public boolean setMain(@NonNull PlotId plotId, @NonNull Pattern blocks, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot == null || plot.isBasePlot()) {
            return this.regionManager.setCuboids(this.classicPlotWorld, plot.getRegions(), blocks, this.classicPlotWorld.getMinBuildHeight(), this.classicPlotWorld.PLOT_HEIGHT - 1, actor, queue);
        }
        return false;
    }

    public boolean setMiddle(@NonNull PlotId plotId, @NonNull Pattern blocks, @Nullable QueueCoordinator queue) {
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot == null || !plot.isBasePlot()) {
            return false;
        }
        Location[] corners = plot.getCorners();
        boolean enqueue = false;
        if (queue == null) {
            queue = this.classicPlotWorld.getQueue();
            enqueue = true;
        }
        int x = MathMan.average(corners[0].getX(), corners[1].getX());
        int z = MathMan.average(corners[0].getZ(), corners[1].getZ());
        queue.setBlock(x, this.classicPlotWorld.PLOT_HEIGHT, z, blocks);
        return !enqueue || queue.enqueue();
    }

    public boolean setOutline(@NonNull PlotId plotId, @NonNull Pattern blocks, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        int z;
        int x;
        int y;
        int x2;
        int z2;
        if (this.classicPlotWorld.ROAD_WIDTH == 0) {
            return false;
        }
        if (this.classicPlotWorld.getTerrain() == PlotAreaTerrainType.ALL) {
            return true;
        }
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot == null) {
            return false;
        }
        Location bottom = plot.getBottomAbs();
        Location top = plot.getExtendedTopAbs();
        boolean enqueue = false;
        if (queue == null) {
            queue = this.classicPlotWorld.getQueue();
            enqueue = true;
            if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
                queue.addProgressSubscriber(this.subscriberFactory.createWithActor(actor));
            }
        }
        int maxY = this.classicPlotWorld.getMaxBuildHeight() - 1;
        if (!plot.isMerged(Direction.NORTH)) {
            z2 = bottom.getZ();
            for (x2 = bottom.getX(); x2 <= top.getX(); ++x2) {
                for (y = this.classicPlotWorld.PLOT_HEIGHT; y <= maxY; ++y) {
                    queue.setBlock(x2, y, z2, blocks);
                }
            }
        }
        if (!plot.isMerged(Direction.WEST)) {
            x = bottom.getX();
            for (z = bottom.getZ(); z <= top.getZ(); ++z) {
                for (y = this.classicPlotWorld.PLOT_HEIGHT; y <= maxY; ++y) {
                    queue.setBlock(x, y, z, blocks);
                }
            }
        }
        if (!plot.isMerged(Direction.SOUTH)) {
            z2 = top.getZ();
            for (x2 = bottom.getX(); x2 <= top.getX(); ++x2) {
                for (y = this.classicPlotWorld.PLOT_HEIGHT; y <= maxY; ++y) {
                    queue.setBlock(x2, y, z2, blocks);
                }
            }
        }
        if (!plot.isMerged(Direction.EAST)) {
            x = top.getX();
            for (z = bottom.getZ(); z <= top.getZ(); ++z) {
                for (y = this.classicPlotWorld.PLOT_HEIGHT; y <= maxY; ++y) {
                    queue.setBlock(x, y, z, blocks);
                }
            }
        }
        if (plot.isBasePlot()) {
            for (CuboidRegion region : plot.getRegions()) {
                Location pos1 = Location.at(this.classicPlotWorld.getWorldName(), region.getMinimumPoint().getX(), maxY, region.getMinimumPoint().getZ());
                Location pos2 = Location.at(this.classicPlotWorld.getWorldName(), region.getMaximumPoint().getX(), maxY, region.getMaximumPoint().getZ());
                queue.setCuboid(pos1, pos2, blocks);
            }
        }
        return !enqueue || queue.enqueue();
    }

    public boolean setWallFilling(@NonNull PlotId plotId, @NonNull Pattern blocks, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        int z;
        int x;
        int y;
        int x2;
        int z2;
        if (this.classicPlotWorld.ROAD_WIDTH == 0) {
            return false;
        }
        if (this.classicPlotWorld.getTerrain() == PlotAreaTerrainType.ALL) {
            return true;
        }
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot == null) {
            return false;
        }
        Location bot = plot.getExtendedBottomAbs().subtract(plot.isMerged(Direction.WEST) ? 0 : 1, 0, plot.isMerged(Direction.NORTH) ? 0 : 1);
        Location top = plot.getExtendedTopAbs().add(1, 0, 1);
        boolean enqueue = false;
        if (queue == null) {
            queue = this.classicPlotWorld.getQueue();
            enqueue = true;
            if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
                queue.addProgressSubscriber(this.subscriberFactory.createWithActor(actor));
            }
        }
        if (!plot.isMerged(Direction.NORTH)) {
            z2 = bot.getZ();
            for (x2 = bot.getX(); x2 < top.getX(); ++x2) {
                for (y = this.classicPlotWorld.getMinBuildHeight(); y <= this.classicPlotWorld.WALL_HEIGHT; ++y) {
                    queue.setBlock(x2, y, z2, blocks);
                }
            }
        }
        if (!plot.isMerged(Direction.WEST)) {
            x = bot.getX();
            for (z = bot.getZ(); z < top.getZ(); ++z) {
                for (y = this.classicPlotWorld.getMinBuildHeight(); y <= this.classicPlotWorld.WALL_HEIGHT; ++y) {
                    queue.setBlock(x, y, z, blocks);
                }
            }
        }
        if (!plot.isMerged(Direction.SOUTH)) {
            z2 = top.getZ();
            for (x2 = bot.getX(); x2 < top.getX() + (plot.isMerged(Direction.EAST) ? 0 : 1); ++x2) {
                for (y = this.classicPlotWorld.getMinBuildHeight(); y <= this.classicPlotWorld.WALL_HEIGHT; ++y) {
                    queue.setBlock(x2, y, z2, blocks);
                }
            }
        }
        if (!plot.isMerged(Direction.EAST)) {
            x = top.getX();
            for (z = bot.getZ(); z < top.getZ() + (plot.isMerged(Direction.SOUTH) ? 0 : 1); ++z) {
                for (y = this.classicPlotWorld.getMinBuildHeight(); y <= this.classicPlotWorld.WALL_HEIGHT; ++y) {
                    queue.setBlock(x, y, z, blocks);
                }
            }
        }
        return !enqueue || queue.enqueue();
    }

    public boolean setWall(@NonNull PlotId plotId, @NonNull Pattern blocks, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        int z;
        int x;
        int x2;
        int z2;
        if (this.classicPlotWorld.ROAD_WIDTH == 0) {
            return false;
        }
        if (this.classicPlotWorld.getTerrain() == PlotAreaTerrainType.ALL) {
            return true;
        }
        Plot plot = this.classicPlotWorld.getPlotAbs(plotId);
        if (plot == null) {
            return false;
        }
        Location bot = plot.getExtendedBottomAbs().subtract(plot.isMerged(Direction.WEST) ? 0 : 1, 0, plot.isMerged(Direction.NORTH) ? 0 : 1);
        Location top = plot.getExtendedTopAbs().add(1, 0, 1);
        boolean enqueue = false;
        if (queue == null) {
            enqueue = true;
            queue = this.classicPlotWorld.getQueue();
            if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
                queue.addProgressSubscriber(this.subscriberFactory.createWithActor(actor));
            }
        }
        int y = this.classicPlotWorld.WALL_HEIGHT + 1;
        if (!plot.isMerged(Direction.NORTH)) {
            z2 = bot.getZ();
            for (x2 = bot.getX(); x2 < top.getX(); ++x2) {
                queue.setBlock(x2, y, z2, blocks);
            }
        }
        if (!plot.isMerged(Direction.WEST)) {
            x = bot.getX();
            for (z = bot.getZ(); z < top.getZ(); ++z) {
                queue.setBlock(x, y, z, blocks);
            }
        }
        if (!plot.isMerged(Direction.SOUTH)) {
            z2 = top.getZ();
            for (x2 = bot.getX(); x2 < top.getX() + (plot.isMerged(Direction.EAST) ? 0 : 1); ++x2) {
                queue.setBlock(x2, y, z2, blocks);
            }
        }
        if (!plot.isMerged(Direction.EAST)) {
            x = top.getX();
            for (z = bot.getZ(); z < top.getZ() + (plot.isMerged(Direction.SOUTH) ? 0 : 1); ++z) {
                queue.setBlock(x, y, z, blocks);
            }
        }
        return !enqueue || queue.enqueue();
    }

    @Override
    public boolean createRoadEast(@NonNull Plot plot, @Nullable QueueCoordinator queue) {
        Location pos1 = this.getPlotBottomLocAbs(plot.getId());
        Location pos2 = this.getPlotTopLocAbs(plot.getId());
        int sx = pos2.getX() + 1;
        int ex = sx + this.classicPlotWorld.ROAD_WIDTH - 1;
        int sz = pos1.getZ() - 2;
        int ez = pos2.getZ() + 2;
        boolean enqueue = false;
        if (queue == null) {
            queue = this.classicPlotWorld.getQueue();
            enqueue = true;
        }
        int maxY = this.classicPlotWorld.getMaxGenHeight();
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.schematicStartHeight() + 1, sz + 1), Location.at(this.classicPlotWorld.getWorldName(), ex, maxY, ez - 1), BlockTypes.AIR.getDefaultState());
        if (this.classicPlotWorld.PLOT_BEDROCK) {
            queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.getMinGenHeight(), sz + 1), Location.at(this.classicPlotWorld.getWorldName(), ex, this.classicPlotWorld.getMinGenHeight(), ez - 1), BlockTypes.BEDROCK.getDefaultState());
        }
        int startYOffset = this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0;
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), ex, this.classicPlotWorld.getMinGenHeight() + startYOffset, sz + 1), Location.at(this.classicPlotWorld.getWorldName(), ex, this.classicPlotWorld.WALL_HEIGHT, ez - 1), this.classicPlotWorld.WALL_FILLING.toPattern());
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.getMinGenHeight() + startYOffset, sz + 1), Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.WALL_HEIGHT, ez - 1), this.classicPlotWorld.WALL_FILLING.toPattern());
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.getMinGenHeight() + startYOffset, sz + 1), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.ROAD_HEIGHT, ez - 1), this.classicPlotWorld.ROAD_BLOCK.toPattern());
        if (this.classicPlotWorld.PLACE_TOP_BLOCK) {
            queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.WALL_HEIGHT + 1, sz + 1), Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.WALL_HEIGHT + 1, ez - 1), this.classicPlotWorld.WALL_BLOCK.toPattern());
            queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), ex, this.classicPlotWorld.WALL_HEIGHT + 1, sz + 1), Location.at(this.classicPlotWorld.getWorldName(), ex, this.classicPlotWorld.WALL_HEIGHT + 1, ez - 1), this.classicPlotWorld.WALL_BLOCK.toPattern());
        }
        return !enqueue || queue.enqueue();
    }

    @Override
    public boolean createRoadSouth(@NonNull Plot plot, @Nullable QueueCoordinator queue) {
        Location pos1 = this.getPlotBottomLocAbs(plot.getId());
        Location pos2 = this.getPlotTopLocAbs(plot.getId());
        int sz = pos2.getZ() + 1;
        int ez = sz + this.classicPlotWorld.ROAD_WIDTH - 1;
        int sx = pos1.getX() - 2;
        int ex = pos2.getX() + 2;
        boolean enqueue = false;
        if (queue == null) {
            queue = this.classicPlotWorld.getQueue();
            enqueue = true;
        }
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.schematicStartHeight() + 1, sz), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.getMaxGenHeight(), ez), BlockTypes.AIR.getDefaultState());
        if (this.classicPlotWorld.PLOT_BEDROCK) {
            queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.getMinGenHeight(), sz), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.getMinGenHeight(), ez), BlockTypes.BEDROCK.getDefaultState());
        }
        int startYOffset = this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0;
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.getMinGenHeight() + startYOffset, sz), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.WALL_HEIGHT, sz), this.classicPlotWorld.WALL_FILLING.toPattern());
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.getMinGenHeight() + startYOffset, ez), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.WALL_HEIGHT, ez), this.classicPlotWorld.WALL_FILLING.toPattern());
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.getMinGenHeight() + startYOffset, sz + 1), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.ROAD_HEIGHT, ez - 1), this.classicPlotWorld.ROAD_BLOCK.toPattern());
        if (this.classicPlotWorld.PLACE_TOP_BLOCK) {
            queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.WALL_HEIGHT + 1, sz), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.WALL_HEIGHT + 1, sz), this.classicPlotWorld.WALL_BLOCK.toPattern());
            queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.WALL_HEIGHT + 1, ez), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.WALL_HEIGHT + 1, ez), this.classicPlotWorld.WALL_BLOCK.toPattern());
        }
        return !enqueue || queue.enqueue();
    }

    @Override
    public boolean createRoadSouthEast(@NonNull Plot plot, @Nullable QueueCoordinator queue) {
        Location pos2 = this.getPlotTopLocAbs(plot.getId());
        int sx = pos2.getX() + 1;
        int ex = sx + this.classicPlotWorld.ROAD_WIDTH - 1;
        int sz = pos2.getZ() + 1;
        int ez = sz + this.classicPlotWorld.ROAD_WIDTH - 1;
        boolean enqueue = false;
        if (queue == null) {
            queue = this.classicPlotWorld.getQueue();
            enqueue = true;
        }
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.ROAD_HEIGHT + 1, sz + 1), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.getMaxGenHeight(), ez - 1), BlockTypes.AIR.getDefaultState());
        if (this.classicPlotWorld.PLOT_BEDROCK) {
            queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.getMinGenHeight(), sz + 1), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.getMinGenHeight(), ez - 1), BlockTypes.BEDROCK.getDefaultState());
        }
        int startYOffset = this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0;
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.getMinGenHeight() + startYOffset, sz + 1), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.ROAD_HEIGHT, ez - 1), this.classicPlotWorld.ROAD_BLOCK.toPattern());
        return !enqueue || queue.enqueue();
    }

    @Override
    public boolean removeRoadEast(@NonNull Plot plot, @Nullable QueueCoordinator queue) {
        Location pos1 = this.getPlotBottomLocAbs(plot.getId());
        Location pos2 = this.getPlotTopLocAbs(plot.getId());
        int sx = pos2.getX() + 1;
        int ex = sx + this.classicPlotWorld.ROAD_WIDTH - 1;
        int sz = pos1.getZ() - 1;
        int ez = pos2.getZ() + 1;
        boolean enqueue = false;
        if (queue == null) {
            queue = this.classicPlotWorld.getQueue();
            enqueue = true;
        }
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.schematicStartHeight() + 1, sz), Location.at(this.classicPlotWorld.getWorldName(), ex, this.classicPlotWorld.getMaxGenHeight(), ez), BlockTypes.AIR.getDefaultState());
        int startYOffset = this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0;
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.getMinGenHeight() + startYOffset, sz + 1), Location.at(this.classicPlotWorld.getWorldName(), ex, this.classicPlotWorld.PLOT_HEIGHT - 1, ez - 1), this.classicPlotWorld.MAIN_BLOCK.toPattern());
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.PLOT_HEIGHT, sz + 1), Location.at(this.classicPlotWorld.getWorldName(), ex, this.classicPlotWorld.PLOT_HEIGHT, ez - 1), this.classicPlotWorld.TOP_BLOCK.toPattern());
        return !enqueue || queue.enqueue();
    }

    @Override
    public boolean removeRoadSouth(@NonNull Plot plot, @Nullable QueueCoordinator queue) {
        Location pos1 = this.getPlotBottomLocAbs(plot.getId());
        Location pos2 = this.getPlotTopLocAbs(plot.getId());
        int sz = pos2.getZ() + 1;
        int ez = sz + this.classicPlotWorld.ROAD_WIDTH - 1;
        int sx = pos1.getX() - 1;
        int ex = pos2.getX() + 1;
        boolean enqueue = false;
        if (queue == null) {
            queue = this.classicPlotWorld.getQueue();
            enqueue = true;
        }
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.schematicStartHeight() + 1, sz), Location.at(this.classicPlotWorld.getWorldName(), ex, this.classicPlotWorld.getMaxGenHeight(), ez), BlockTypes.AIR.getDefaultState());
        int startYOffset = this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0;
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.getMinGenHeight() + startYOffset, sz), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.PLOT_HEIGHT - 1, ez), this.classicPlotWorld.MAIN_BLOCK.toPattern());
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx + 1, this.classicPlotWorld.PLOT_HEIGHT, sz), Location.at(this.classicPlotWorld.getWorldName(), ex - 1, this.classicPlotWorld.PLOT_HEIGHT, ez), this.classicPlotWorld.TOP_BLOCK.toPattern());
        return !enqueue || queue.enqueue();
    }

    @Override
    public boolean removeRoadSouthEast(@NonNull Plot plot, @Nullable QueueCoordinator queue) {
        Location location = this.getPlotTopLocAbs(plot.getId());
        int sx = location.getX() + 1;
        int ex = sx + this.classicPlotWorld.ROAD_WIDTH - 1;
        int sz = location.getZ() + 1;
        int ez = sz + this.classicPlotWorld.ROAD_WIDTH - 1;
        boolean enqueue = false;
        if (queue == null) {
            queue = this.classicPlotWorld.getQueue();
            enqueue = true;
        }
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.schematicStartHeight() + 1, sz), Location.at(this.classicPlotWorld.getWorldName(), ex, this.classicPlotWorld.getMaxGenHeight(), ez), BlockTypes.AIR.getDefaultState());
        int startYOffset = this.classicPlotWorld.PLOT_BEDROCK ? 1 : 0;
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.getMinGenHeight() + startYOffset, sz), Location.at(this.classicPlotWorld.getWorldName(), ex, this.classicPlotWorld.PLOT_HEIGHT - 1, ez), this.classicPlotWorld.MAIN_BLOCK.toPattern());
        queue.setCuboid(Location.at(this.classicPlotWorld.getWorldName(), sx, this.classicPlotWorld.PLOT_HEIGHT, sz), Location.at(this.classicPlotWorld.getWorldName(), ex, this.classicPlotWorld.PLOT_HEIGHT, ez), this.classicPlotWorld.TOP_BLOCK.toPattern());
        return !enqueue || queue.enqueue();
    }

    @Override
    public boolean finishPlotMerge(@NonNull List<PlotId> plotIds, @Nullable QueueCoordinator queue) {
        BlockBucket claim = this.classicPlotWorld.CLAIMED_WALL_BLOCK;
        if (!(!this.classicPlotWorld.PLACE_TOP_BLOCK || claim.isAir() && claim.equals(this.classicPlotWorld.WALL_BLOCK))) {
            for (PlotId plotId : plotIds) {
                this.setWall(plotId, claim.toPattern(), null, queue);
            }
        }
        if (Settings.General.MERGE_REPLACE_WALL) {
            BlockBucket wallBlock = this.classicPlotWorld.WALL_FILLING;
            for (PlotId id : plotIds) {
                this.setWallFilling(id, wallBlock.toPattern(), null, queue);
            }
        }
        return true;
    }

    @Override
    public boolean finishPlotUnlink(@NonNull List<PlotId> plotIds, @Nullable QueueCoordinator queue) {
        BlockBucket claim = this.classicPlotWorld.CLAIMED_WALL_BLOCK;
        if (!(!this.classicPlotWorld.PLACE_TOP_BLOCK || claim.isAir() && claim.equals(this.classicPlotWorld.WALL_BLOCK))) {
            for (PlotId id : plotIds) {
                this.setWall(id, claim.toPattern(), null, queue);
            }
        }
        return true;
    }

    @Override
    public boolean startPlotMerge(@NonNull List<PlotId> plotIds, @Nullable QueueCoordinator queue) {
        return true;
    }

    @Override
    public boolean startPlotUnlink(@NonNull List<PlotId> plotIds, @Nullable QueueCoordinator queue) {
        return true;
    }

    @Override
    public boolean claimPlot(@NonNull Plot plot, @Nullable QueueCoordinator queue) {
        BlockBucket claim = this.classicPlotWorld.CLAIMED_WALL_BLOCK;
        if (!(!this.classicPlotWorld.PLACE_TOP_BLOCK || claim.isAir() && claim.equals(this.classicPlotWorld.WALL_BLOCK))) {
            return this.setWall(plot.getId(), claim.toPattern(), null, queue);
        }
        return true;
    }

    @Override
    public String[] getPlotComponents(@NonNull PlotId plotId) {
        return ClassicPlotManagerComponent.stringValues();
    }

    @Override
    public Location getSignLoc(@NonNull Plot plot) {
        plot = plot.getBasePlot(false);
        Location bot = plot.getBottomAbs();
        return Location.at(this.classicPlotWorld.getWorldName(), bot.getX() - 1, this.classicPlotWorld.ROAD_HEIGHT + 1, bot.getZ() - 2);
    }
}

