/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlotRateEvent;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.Rating;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.TaskManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="like", permission="plots.like", usage="/plot like [next | purge]", category=CommandCategory.INFO, requiredType=RequiredType.PLAYER)
public class Like
extends SubCommand {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Like(@NonNull EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public static double getLikesPercentage(Plot plot) {
        if (!plot.hasRatings()) {
            return 0.0;
        }
        Collection<Boolean> reactions = plot.getLikes().values();
        double numLikes = 0.0;
        double numDislikes = 0.0;
        for (boolean reaction : reactions) {
            if (reaction) {
                numLikes += 1.0;
                continue;
            }
            numDislikes += 1.0;
        }
        if (numLikes == 0.0 && numDislikes == 0.0) {
            return 0.0;
        }
        if (numDislikes == 0.0) {
            return 1.0;
        }
        return numLikes / (numLikes + numDislikes);
    }

    protected boolean handleLike(PlotPlayer<?> player, String[] args, boolean like) {
        Plot plot;
        UUID uuid = player.getUUID();
        if (args.length == 1) {
            switch (args[0].toLowerCase()) {
                case "next": {
                    List<Plot> plots = PlotQuery.newQuery().whereBasePlot().asList();
                    plots.sort((p1, p2) -> {
                        double v2;
                        double v1 = Like.getLikesPercentage(p1);
                        if (v1 == (v2 = Like.getLikesPercentage(p2))) {
                            return 0;
                        }
                        return v2 > v1 ? 1 : -1;
                    });
                    for (Plot plot2 : plots) {
                        if (Settings.Done.REQUIRED_FOR_RATINGS && !DoneFlag.isDone(plot2) || !plot2.isBasePlot() || plot2.getLikes().containsKey(uuid)) continue;
                        plot2.teleportPlayer(player, TeleportCause.COMMAND_LIKE, result -> {});
                        player.sendMessage(TranslatableCaption.of("tutorial.rate_this"), new Template[0]);
                        return true;
                    }
                    player.sendMessage(TranslatableCaption.of("invalid.found_no_plots"), new Template[0]);
                    return true;
                }
                case "purge": {
                    Plot plot3 = player.getCurrentPlot();
                    if (plot3 == null) {
                        player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
                        return false;
                    }
                    if (!player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_PURGE_RATINGS, true)) {
                        return false;
                    }
                    plot3.clearRatings();
                    player.sendMessage(TranslatableCaption.of("ratings.ratings_purged"), new Template[0]);
                    return true;
                }
            }
        }
        if ((plot = player.getCurrentPlot()) == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("ratings.rating_not_owned"), new Template[0]);
            return false;
        }
        if (plot.isOwner(player.getUUID())) {
            player.sendMessage(TranslatableCaption.of("ratings.rating_not_your_own"), new Template[0]);
            return false;
        }
        if (Settings.Done.REQUIRED_FOR_RATINGS && !DoneFlag.isDone(plot)) {
            player.sendMessage(TranslatableCaption.of("ratings.rating_not_done"), new Template[0]);
            return false;
        }
        Runnable run = () -> {
            Boolean oldRating = plot.getLikes().get(uuid);
            if (oldRating != null) {
                player.sendMessage(TranslatableCaption.of("ratings.rating_already_exists"), Template.of((String)"plot", (String)plot.getId().toString()));
                return;
            }
            int rating = like ? 10 : 1;
            plot.addRating(uuid, new Rating(rating));
            PlotRateEvent event = this.eventDispatcher.callRating(player, plot, new Rating(rating));
            if (event.getRating() != null) {
                plot.addRating(uuid, event.getRating());
                if (like) {
                    player.sendMessage(TranslatableCaption.of("ratings.rating_liked"), Template.of((String)"plot", (String)plot.getId().toString()));
                } else {
                    player.sendMessage(TranslatableCaption.of("ratings.rating_disliked"), Template.of((String)"plot", (String)plot.getId().toString()));
                }
            }
        };
        if (plot.getSettings().getRatings() == null) {
            if (!Settings.Enabled_Components.RATING_CACHE) {
                TaskManager.runTaskAsync(() -> {
                    plot.getSettings().setRatings(DBFunc.getRatings(plot));
                    run.run();
                });
                return true;
            }
            plot.getSettings().setRatings(new HashMap<UUID, Integer>());
        }
        run.run();
        return true;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        return this.handleLike(player, args, true);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        if (args.length == 1) {
            LinkedList<String> completions = new LinkedList<String>();
            if (player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_PURGE_RATINGS)) {
                completions.add("purge");
            }
            List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.PLAYER, CommandCategory.INFO){}).collect(Collectors.toCollection(LinkedList::new));
            if (player.hasPermission(Permission.PERMISSION_RATE) && args[0].length() > 0) {
                commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
            }
            return commands;
        }
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }
}

