/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.query.SortingStrategy;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="home", permission="plots.home", usage="/plot home [<page> | <alias> | <area;x;y> | <area> <x;y> | <area> <page>]", aliases={"h"}, requiredType=RequiredType.PLAYER, category=CommandCategory.TELEPORT)
public class HomeCommand
extends Command {
    private final PlotAreaManager plotAreaManager;

    @Inject
    public HomeCommand(@NonNull PlotAreaManager plotAreaManager) {
        super(MainCommand.getInstance(), true);
        this.plotAreaManager = plotAreaManager;
    }

    private void home(@NonNull PlotPlayer<?> player, @NonNull PlotQuery query, int page, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        List<Plot> plots = query.asList();
        if (plots.isEmpty()) {
            player.sendMessage(TranslatableCaption.of("invalid.found_no_plots"), new Template[0]);
            return;
        }
        if (plots.size() < page || page < 1) {
            player.sendMessage(TranslatableCaption.of("invalid.number_not_in_range"), Template.of((String)"min", (String)"1"), Template.of((String)"max", (String)String.valueOf(plots.size())));
            return;
        }
        Plot plot = plots.get(page - 1);
        confirm.run(this, () -> plot.teleportPlayer(player, TeleportCause.COMMAND_HOME, result -> {
            if (result.booleanValue()) {
                whenDone.run(this, Command.CommandResult.SUCCESS);
            } else {
                whenDone.run(this, Command.CommandResult.FAILURE);
            }
        }), () -> whenDone.run(this, Command.CommandResult.FAILURE));
    }

    private @NonNull PlotQuery query(@NonNull PlotPlayer<?> player) {
        return PlotQuery.newQuery().thatPasses(plot -> plot.isOwner(player.getUUID()));
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) throws Command.CommandException {
        if (!player.hasPermission(Permission.PERMISSION_VISIT_OWNED) && !player.hasPermission(Permission.PERMISSION_HOME)) {
            player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)Permission.PERMISSION_VISIT_OWNED.toString()));
            return CompletableFuture.completedFuture(false);
        }
        if (args.length > 2) {
            this.sendUsage(player);
            return CompletableFuture.completedFuture(false);
        }
        PlotQuery query = this.query(player);
        int page = 1;
        boolean basePlotOnly = true;
        switch (args.length) {
            case 1: {
                String identifier = args[0];
                if (MathMan.isInteger(identifier)) {
                    try {
                        page = Integer.parseInt(identifier);
                    }
                    catch (NumberFormatException ignored) {
                        player.sendMessage(TranslatableCaption.of("invalid.not_a_number"), Template.of((String)"value", (String)identifier));
                        return CompletableFuture.completedFuture(false);
                    }
                    this.sortBySettings(query, player);
                    break;
                }
                Plot fromId = Plot.getPlotFromString(player, identifier, false);
                if (fromId != null && fromId.isOwner(player.getUUID())) {
                    basePlotOnly = false;
                    query.withPlot(fromId);
                    break;
                }
                PlotArea plotArea = this.plotAreaManager.getPlotAreaByString(args[0]);
                if (plotArea != null) {
                    query.inArea(plotArea);
                    break;
                }
                query.withAlias(identifier);
                break;
            }
            case 2: {
                PlotArea plotArea = this.plotAreaManager.getPlotAreaByString(args[0]);
                String identifier = args[1];
                if (plotArea == null) {
                    query.noPlots();
                    break;
                }
                query.inArea(plotArea);
                if (MathMan.isInteger(identifier)) {
                    try {
                        page = Integer.parseInt(identifier);
                    }
                    catch (NumberFormatException ignored) {
                        player.sendMessage(TranslatableCaption.of("invalid.not_a_number"), Template.of((String)"value", (String)identifier));
                        return CompletableFuture.completedFuture(false);
                    }
                    query.withSortingStrategy(SortingStrategy.SORT_BY_CREATION);
                    break;
                }
                PlotId id = PlotId.fromStringOrNull(identifier);
                if (id == null) {
                    query.noPlots();
                    break;
                }
                Plot plot = plotArea.getPlot(id);
                if (plot == null) {
                    query.noPlots();
                    break;
                }
                basePlotOnly = false;
                query.withPlot(plot);
                break;
            }
            case 0: {
                this.sortBySettings(query, player);
            }
        }
        if (basePlotOnly) {
            query.whereBasePlot();
        }
        this.home(player, query, page, confirm, whenDone);
        return CompletableFuture.completedFuture(true);
    }

    private void sortBySettings(PlotQuery plotQuery, PlotPlayer<?> player) {
        PlotArea area = player.getApplicablePlotArea();
        if (Settings.Teleport.PER_WORLD_VISIT && area != null) {
            plotQuery.relativeToArea(area).withSortingStrategy(SortingStrategy.SORT_BY_CREATION);
        } else {
            plotQuery.withSortingStrategy(SortingStrategy.SORT_BY_TEMP);
        }
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        ArrayList<Command> completions = new ArrayList<Command>();
        switch (args.length - 1) {
            case 0: {
                completions.addAll(TabCompletions.completeAreas(args[0]));
                if (args[0].isEmpty()) {
                    completions.addAll(TabCompletions.asCompletions("1", "2", "3"));
                    break;
                }
                completions.addAll(TabCompletions.completeNumbers(args[0], 10, 999));
                break;
            }
            case 1: {
                completions.addAll(TabCompletions.completeNumbers(args[1], 10, 999));
            }
        }
        return completions;
    }
}

